/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.optimized;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import org.gridgain.internal.dr.common.ByteArrayCacheObjectImpl;
import org.gridgain.internal.dr.common.KeyCacheObjectImpl;
import org.gridgain.internal.dr.common.MarshallerException;
import org.gridgain.internal.dr.common.ValueCacheObjectImpl;
import org.gridgain.internal.dr.optimized.DuplicateTypeIdException;
import org.gridgain.internal.dr.optimized.OptimizedClassDescriptor;

public class OptimizedContext {
    private static final byte JAVA_ID = 0;
    private final Int2ObjectMap<OptimizedClassDescriptor> descriptors = new Int2ObjectOpenHashMap<OptimizedClassDescriptor>();

    public static OptimizedContext create() {
        OptimizedContext ctx = new OptimizedContext();
        try {
            ctx.registerClassName(KeyCacheObjectImpl.class, "org.apache.ignite.internal.processors.cache.KeyCacheObjectImpl");
            ctx.registerClassName(ValueCacheObjectImpl.class, "org.apache.ignite.internal.processors.cache.CacheObjectImpl");
            ctx.registerClassName(ByteArrayCacheObjectImpl.class, "org.apache.ignite.internal.processors.cache.CacheObjectByteArrayImpl");
            ctx.registerClassName(LocalTime.class);
            ctx.registerClassName(LocalDate.class);
            ctx.registerClassName(LocalDateTime.class);
            ctx.registerClassName(BitSet.class);
            ctx.registerClassName(BigInteger.class);
            ctx.registerClassName(BigDecimal.class);
            ctx.registerClassName(String.class);
            ctx.registerClassName(Class.forName("java.time.Ser"));
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return ctx;
    }

    private OptimizedContext() {
    }

    public OptimizedClassDescriptor classDescriptor(String className) {
        return this.classDescriptor(OptimizedContext.resolveTypeId(className));
    }

    public OptimizedClassDescriptor classDescriptor(int typeId) {
        OptimizedClassDescriptor descriptor = (OptimizedClassDescriptor)this.descriptors.get(typeId);
        if (descriptor == null) {
            throw new MarshallerException("Unregistered class descriptor for type: typeId=" + typeId);
        }
        return descriptor;
    }

    void registerClassName(Class<?> cls) throws IOException {
        this.registerClassName(cls, cls.getName());
    }

    private void registerClassName(Class<?> cls, String className) throws IOException {
        int typeId = OptimizedContext.resolveTypeId(className);
        OptimizedClassDescriptor desc = (OptimizedClassDescriptor)this.descriptors.get(typeId);
        if (desc == null) {
            desc = new OptimizedClassDescriptor(cls, typeId, className);
            OptimizedClassDescriptor old = this.descriptors.putIfAbsent(typeId, desc);
            assert (old == null);
        } else if (desc.getClass() != cls) {
            throw new DuplicateTypeIdException(0, typeId, desc.getName(), className);
        }
    }

    private static int resolveTypeId(String clsName) {
        return clsName.hashCode();
    }
}

