/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.nio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.util.CharsetUtil;
import java.util.Arrays;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.gridgain.internal.dr.DrUtils;
import org.jetbrains.annotations.Nullable;

public class DrNioMessageDecoder
extends LengthFieldBasedFrameDecoder {
    private State state = State.INITIAL;
    private static final int HEADER_SIZE = 4;

    public DrNioMessageDecoder() {
        super(0x7FFFFFFB, 0, 4, 0, 4, true);
    }

    @Override
    @Nullable
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        if (!this.readMagic(in)) {
            return null;
        }
        return super.decode(ctx, in);
    }

    private boolean readMagic(ByteBuf byteBuf) {
        if (this.state == State.FAILED) {
            return false;
        }
        if (this.state == State.VERIFIED) {
            return true;
        }
        if (byteBuf.readableBytes() < DrUtils.MAGIC_BYTES.length) {
            return false;
        }
        byte[] data = new byte[DrUtils.MAGIC_BYTES.length];
        byteBuf.readBytes(data);
        if (Arrays.equals(data, DrUtils.MAGIC_BYTES)) {
            this.state = State.VERIFIED;
            return true;
        }
        this.state = State.FAILED;
        throw new IgniteException(ErrorGroups.Client.HANDSHAKE_HEADER_ERR, "Invalid magic header in DR receiver connection. Expected '\u0000\u0000GG', but was '" + new String(data, CharsetUtil.US_ASCII) + "'.");
    }

    public String toString() {
        return S.toString(DrNioMessageDecoder.class, this);
    }

    static enum State {
        INITIAL,
        VERIFIED,
        FAILED;

    }
}

