/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.binary;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.nio.charset.StandardCharsets;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.gridgain.internal.dr.MarshallerContext;
import org.gridgain.internal.dr.binary.BinaryObjectException;
import org.gridgain.internal.dr.binary.BinaryPrimitives;
import org.gridgain.internal.dr.binary.BinarySchema;
import org.gridgain.internal.dr.binary.BinaryUtils;
import org.gridgain.internal.dr.common.CacheObject;
import org.jetbrains.annotations.Nullable;

public class BinaryObject
implements CacheObject {
    private final MarshallerContext ctx;
    private final byte[] arr;
    private final int start;

    BinaryObject(MarshallerContext ctx, byte[] arr, int start) {
        assert (ctx != null);
        assert (arr != null);
        this.ctx = ctx;
        this.arr = arr;
        this.start = start;
        BinaryUtils.checkProtocolVersion(BinaryPrimitives.readByte(arr, start + 1));
        byte type = BinaryPrimitives.readByte(arr, start);
        assert (type == 27 || type == 103) : type;
    }

    boolean isFlagSet(short flag) {
        short flags = BinaryPrimitives.readShort(this.arr, this.start + 2);
        return BinaryUtils.isFlagSet(flags, flag);
    }

    public int typeId() {
        int off = this.start + 4;
        int typeId = BinaryPrimitives.readInt(this.arr, off);
        if (typeId == 0) {
            off = this.start + 24;
            assert (this.arr[off] == 9) : this.arr[off];
            int len = BinaryPrimitives.readInt(this.arr, ++off);
            String clsName = new String(this.arr, off + 4, len, StandardCharsets.UTF_8);
            typeId = this.ctx.binaryContext().typeId(clsName);
        }
        return typeId;
    }

    @Nullable
    public <F> F fieldByOrder(int order) {
        if (order == -1) {
            return null;
        }
        assert (this.hasSchema());
        assert (this.isFlagSet((short)1));
        int footerStart = this.start + BinaryPrimitives.readInt(this.arr, this.start + 20);
        short flags = BinaryPrimitives.readShort(this.arr, this.start + 2);
        int fieldIdLen = BinaryUtils.fieldIdLength(flags);
        int fieldOffLen = BinaryUtils.fieldOffsetLength(flags);
        int fieldOffsetPos = footerStart + order * (fieldIdLen + fieldOffLen) + fieldIdLen;
        int fieldPos = fieldOffLen == 1 ? this.start + (BinaryPrimitives.readByte(this.arr, fieldOffsetPos) & 0xFF) : (fieldOffLen == 2 ? this.start + (BinaryPrimitives.readShort(this.arr, fieldOffsetPos) & 0xFFFF) : this.start + BinaryPrimitives.readInt(this.arr, fieldOffsetPos));
        return (F)BinaryUtils.unmarshal(this.ctx, this.arr, fieldPos);
    }

    public boolean hasSchema() {
        short flags = BinaryPrimitives.readShort(this.arr, this.start + 2);
        return BinaryUtils.hasSchema(flags);
    }

    public int schemaId() {
        return BinaryPrimitives.readInt(this.arr, this.start + 16);
    }

    public BinarySchema readSchema() {
        short flags = BinaryPrimitives.readShort(this.arr, this.start + 2);
        assert (BinaryUtils.hasSchema(flags));
        if (BinaryUtils.isCompactFooter(flags)) {
            throw new BinaryObjectException(IgniteStringFormatter.format("Can't read schema for object with compact footer: [typeId={}, schemaId={}", BinaryPrimitives.readInt(this.arr, 4), BinaryPrimitives.readInt(this.arr, 16)));
        }
        int fieldOffLen = BinaryUtils.fieldOffsetLength(flags);
        int offset = BinaryPrimitives.readInt(this.arr, this.start + 20);
        int len = BinaryPrimitives.readInt(this.arr, this.start + 12);
        int footerStart = this.start + offset;
        int footerLen = len - offset;
        IntList fields = this.readFieldList(footerStart, footerLen, 4 + fieldOffLen);
        return new BinarySchema(this.schemaId(), fields);
    }

    private IntList readFieldList(int startOffset, int length, int listEntrySize) {
        IntArrayList fields = new IntArrayList(length / listEntrySize);
        int searchEnd = startOffset + length;
        for (int searchPos = startOffset; searchPos < searchEnd; searchPos += listEntrySize) {
            int fieldId = BinaryPrimitives.readInt(this.arr, searchPos);
            fields.add(fieldId);
        }
        return fields;
    }
}

