/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.binary;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.CollectionUtils;
import org.gridgain.internal.dr.binary.BinaryFieldMetadata;
import org.gridgain.internal.dr.binary.BinarySchema;
import org.jetbrains.annotations.Nullable;

public class BinaryMetadata {
    public static final int VERSION = 1;
    @IgniteToStringInclude(sensitive=true)
    private final int typeId;
    @IgniteToStringInclude(sensitive=true)
    private final String typeName;
    @IgniteToStringInclude(sensitive=true)
    private final Map<String, BinaryFieldMetadata> fields;
    @IgniteToStringInclude
    private final Int2ObjectMap<BinarySchema> schemas;
    private final Int2ObjectMap<String> fieldNameById;

    public BinaryMetadata(int typeId, String typeName, Map<String, BinaryFieldMetadata> fields, Int2ObjectMap<BinarySchema> schemas) {
        this.typeId = typeId;
        this.typeName = typeName;
        this.fields = fields;
        this.schemas = schemas;
        this.fieldNameById = fields.entrySet().stream().collect(CollectionUtils.toIntMapCollector(e -> ((BinaryFieldMetadata)e.getValue()).fieldId(), Map.Entry::getKey));
    }

    public int typeId() {
        return this.typeId;
    }

    public String typeName() {
        return this.typeName;
    }

    public Map<String, BinaryFieldMetadata> fieldsMap() {
        return this.fields != null ? this.fields : Collections.emptyMap();
    }

    public String fieldName(int fieldId) {
        return (String)this.fieldNameById.get(fieldId);
    }

    @Nullable
    public BinarySchema schema(int schemaId) {
        return (BinarySchema)this.schemas.get(schemaId);
    }

    public IntSet schemasIds() {
        return this.schemas.keySet();
    }

    public Collection<BinarySchema> schemas() {
        return this.schemas.values();
    }

    public String toString() {
        return S.toString(BinaryMetadata.class, this);
    }
}

