/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.internal.util.io.IgniteUnsafeDataOutput;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.QualifiedNameHelper;
import org.apache.ignite.table.Table;
import org.apache.ignite.table.Tuple;
import org.gridgain.internal.dr.DrUpdate;
import org.gridgain.internal.dr.common.GridCacheRawVersionedEntry;
import org.gridgain.internal.dr.common.GridCacheVersion;
import org.gridgain.internal.dr.common.MarshallerException;
import org.gridgain.internal.dr.messages.DrExternalBatchRequest;
import org.jetbrains.annotations.Nullable;

public final class DrUtils {
    public static final String DR_PROTO_VER = "1.0-20140117";
    public static final ByteOrder DR_BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    public static final byte[] MAGIC_BYTES = new byte[]{0, 0, 71, 71};
    public static final byte TYP_HND_REQ = 0;
    public static final byte TYP_HND_RESP = 1;
    public static final byte TYP_PING_REQ = 2;
    public static final byte TYP_PING_RESP = 3;
    public static final byte TYP_BATCH_REQ = 4;
    public static final byte TYP_BATCH_RESP = 5;
    public static final byte TYP_META_REQ = 6;
    public static final byte TYP_META_RESP = 7;
    public static final byte[] PING_REQ_BYTES = new byte[]{0, 0, 0, 1, 2};
    public static final byte[] PING_RESP_BYTES = new byte[]{0, 0, 0, 1, 3};
    static final String SUPPORTED_MARSHALLER_CLASS = "org.apache.ignite.internal.binary.BinaryMarshaller";
    static final String DR_SYSTEM_COLUMN_NAME = "DrVersion";
    public static final QualifiedName DR_TOMBSTONES_TABLE_NAME = QualifiedNameHelper.fromNormalized("PUBLIC", "_DR_TOMBSTONES");
    public static final String TOMBSTONES_KEY_COLUMN_NAME = "key";
    public static final String TOMBSTONES_VERSION_COLUMN_NAME = "version";
    public static final String TOMBSTONES_TTL_COLUMN_NAME = "ttl";
    public static final long DEFAULT_TOMBSTONE_TTL = 1800000L;

    private DrUtils() {
    }

    public static InetAddress toInetAddress(String hostStr) {
        try {
            if (StringUtils.nullOrEmpty(hostStr)) {
                return InetAddress.getLocalHost();
            }
            return InetAddress.getByName(hostStr);
        }
        catch (IOException e) {
            throw new IgniteException(ErrorGroups.Common.COMPONENT_NOT_STARTED_ERR, "Failed to resolve TCP server local inbound host: host=" + hostStr, (Throwable)e);
        }
    }

    public static List<GridCacheRawVersionedEntry> unmarshalEntries(DrExternalBatchRequest req) {
        ArrayList<GridCacheRawVersionedEntry> arrayList;
        ArrayList<GridCacheRawVersionedEntry> values = new ArrayList<GridCacheRawVersionedEntry>(req.entryCount());
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(req.dataBytes()));
        try {
            for (int i = 0; i < req.entryCount(); ++i) {
                GridCacheRawVersionedEntry obj = DrUtils.readDrEntry(req.dataCenterId(), in);
                values.add(obj);
            }
            arrayList = values;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new MarshallerException("Failed to read batch entries.", (Throwable)ex);
            }
        }
        in.close();
        return arrayList;
    }

    public static GridCacheRawVersionedEntry readDrEntry(byte dataCenterId, DataInput in) throws IOException {
        byte[] keyBytes = DrUtils.readByteArray(in);
        byte[] valBytes = DrUtils.readByteArray(in);
        assert (keyBytes != null);
        if (in.readBoolean()) {
            in.readLong();
            in.readLong();
        }
        GridCacheVersion ver = new GridCacheVersion(in.readInt(), in.readLong(), in.readInt(), dataCenterId);
        return new GridCacheRawVersionedEntry(keyBytes, valBytes, ver);
    }

    public static byte @Nullable [] readByteArray(DataInput in) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        byte[] res = new byte[len];
        in.readFully(res);
        return res;
    }

    public static void writeByteArray(DataOutput out, byte @Nullable [] arr) throws IOException {
        if (arr == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(arr.length);
            out.write(arr);
        }
    }

    static byte[] marshalVersion(GridCacheVersion version) {
        ByteBuffer bb = ByteBuffer.allocate(17).order(DR_BYTE_ORDER);
        bb.putInt(version.topologyVersion());
        bb.putLong(version.order());
        bb.putInt(version.nodeOrder());
        bb.put(version.dataCenterId());
        return bb.array();
    }

    @Nullable
    public static GridCacheVersion unmarshalVersion(byte @Nullable [] value) {
        if (value == null) {
            return null;
        }
        assert (value.length == 17);
        ByteBuffer bb = ByteBuffer.wrap(value).order(DR_BYTE_ORDER);
        return new GridCacheVersion(bb.getInt(), bb.getLong(), bb.getInt(), bb.get());
    }

    static Table initTombstonesTable(Ignite node) {
        QualifiedName tableName = DR_TOMBSTONES_TABLE_NAME;
        String createTableForTombstones = IgniteStringFormatter.format("CREATE TABLE IF NOT EXISTS {} ( {} VARBINARY PRIMARY KEY, {} VARBINARY, {} TIMESTAMP WITH LOCAL TIME ZONE) EXPIRE AT {}", tableName.toCanonicalForm(), TOMBSTONES_KEY_COLUMN_NAME, TOMBSTONES_VERSION_COLUMN_NAME, TOMBSTONES_TTL_COLUMN_NAME, TOMBSTONES_TTL_COLUMN_NAME);
        node.sql().execute(null, createTableForTombstones, new Object[0]).close();
        return node.tables().table(tableName);
    }

    static long getOrDefaultTtlInSeconds(Duration tombstoneTtl) {
        if (tombstoneTtl == null || tombstoneTtl.isZero()) {
            return TimeUnit.MILLISECONDS.toSeconds(1800000L);
        }
        if (tombstoneTtl.isNegative() || tombstoneTtl.getSeconds() == 0L) {
            throw new IllegalArgumentException("Tombstone TTL must be greater than or equal to 1 second.");
        }
        return tombstoneTtl.getSeconds();
    }

    static Tuple createTombstoneKey(String tableName, DrUpdate row) {
        Tuple tuple;
        IgniteUnsafeDataOutput output = new IgniteUnsafeDataOutput(128);
        try {
            output.write(tableName.getBytes(StandardCharsets.UTF_8));
            output.write(row.keyBytes());
            tuple = Tuple.create().set(TOMBSTONES_KEY_COLUMN_NAME, output.array());
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        output.close();
        return tuple;
    }

    static Tuple createTombstoneValue(GridCacheVersion version, long ttlInSeconds) {
        byte[] versionBytes = DrUtils.marshalVersion(version);
        return Tuple.create().set(TOMBSTONES_VERSION_COLUMN_NAME, versionBytes).set(TOMBSTONES_TTL_COLUMN_NAME, Instant.now().plusSeconds(ttlInSeconds));
    }
}

