/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.worker;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.failure.FailureContext;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.failure.FailureType;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.ComponentContext;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.worker.CriticalWorker;
import org.apache.ignite.internal.worker.CriticalWorkerRegistry;
import org.apache.ignite.internal.worker.configuration.CriticalWorkersConfiguration;
import org.jetbrains.annotations.Nullable;

public class CriticalWorkerWatchdog
implements CriticalWorkerRegistry,
IgniteComponent {
    private static final IgniteLogger LOG = Loggers.forClass(CriticalWorkerWatchdog.class);
    private final CriticalWorkersConfiguration configuration;
    private final ScheduledExecutorService scheduler;
    private final Set<CriticalWorker> registeredWorkers = ConcurrentHashMap.newKeySet();
    @Nullable
    private volatile ScheduledFuture<?> livenessProbeTaskFuture;
    private final ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
    private final FailureManager failureManager;

    public CriticalWorkerWatchdog(CriticalWorkersConfiguration configuration, ScheduledExecutorService scheduler, FailureManager failureManager) {
        this.configuration = configuration;
        this.scheduler = scheduler;
        this.failureManager = failureManager;
    }

    @Override
    public void register(CriticalWorker worker) {
        this.registeredWorkers.add(worker);
    }

    @Override
    public void unregister(CriticalWorker worker) {
        this.registeredWorkers.remove(worker);
    }

    @Override
    public CompletableFuture<Void> startAsync(ComponentContext componentContext) {
        long livenessCheckIntervalMs = (Long)this.configuration.livenessCheckIntervalMillis().value();
        this.livenessProbeTaskFuture = this.scheduler.scheduleAtFixedRate(this::probeLiveness, livenessCheckIntervalMs, livenessCheckIntervalMs, TimeUnit.MILLISECONDS);
        return CompletableFutures.nullCompletedFuture();
    }

    private void probeLiveness() {
        try {
            this.doProbeLiveness();
        }
        catch (AssertionError | Exception e) {
            LOG.debug("Error while probing liveness", (Throwable)e);
        }
        catch (Error e) {
            this.failureManager.process(new FailureContext(FailureType.CRITICAL_ERROR, e));
        }
    }

    private void doProbeLiveness() {
        ThreadInfo[] threadInfos;
        long maxAllowedLag = (Long)this.configuration.maxAllowedLagMillis().value();
        Long2LongMap delayedThreadIdsToDelays = this.getDelayedThreadIdsAndDelays(maxAllowedLag);
        if (delayedThreadIdsToDelays == null) {
            return;
        }
        for (ThreadInfo threadInfo : threadInfos = this.threadMxBean.getThreadInfo(delayedThreadIdsToDelays.keySet().toLongArray(), this.threadMxBean.isObjectMonitorUsageSupported(), this.threadMxBean.isSynchronizerUsageSupported())) {
            if (threadInfo == null) continue;
            StringBuilder message = new StringBuilder().append("A critical thread is blocked for ").append(delayedThreadIdsToDelays.get(threadInfo.getThreadId())).append(" ms that is more than the allowed ").append(maxAllowedLag).append(" ms (defined at ignite.system.criticalWorkers.maxAllowedLagMillis local config property), it is ");
            CriticalWorkerWatchdog.appendThreadInfo(message, threadInfo);
            this.failureManager.process(new FailureContext(FailureType.SYSTEM_WORKER_BLOCKED, null, message.toString()));
        }
    }

    @Nullable
    private Long2LongMap getDelayedThreadIdsAndDelays(long maxAllowedLag) {
        long nowNanos = System.nanoTime();
        Long2LongOpenHashMap delayedThreadIdsToDelays = null;
        for (CriticalWorker worker : this.registeredWorkers) {
            long delayMillis;
            long heartbeatNanos = worker.heartbeatNanos();
            if (heartbeatNanos == Long.MAX_VALUE || (delayMillis = TimeUnit.NANOSECONDS.toMillis(nowNanos - heartbeatNanos)) <= maxAllowedLag) continue;
            if (delayedThreadIdsToDelays == null) {
                delayedThreadIdsToDelays = new Long2LongOpenHashMap();
            }
            delayedThreadIdsToDelays.put(worker.threadId(), delayMillis);
        }
        return delayedThreadIdsToDelays;
    }

    private static void appendThreadInfo(StringBuilder sb, ThreadInfo threadInfo) {
        sb.append('\"').append(threadInfo.getThreadName()).append('\"').append(threadInfo.isDaemon() ? " daemon" : "").append(" prio=").append(threadInfo.getPriority()).append(" Id=").append(threadInfo.getThreadId()).append(' ').append((Object)threadInfo.getThreadState());
        if (threadInfo.getLockName() != null) {
            sb.append(" on ").append(threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            sb.append(" owned by \"").append(threadInfo.getLockOwnerName()).append("\" Id=").append(threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        for (int i = 0; i < threadInfo.getStackTrace().length; ++i) {
            StackTraceElement ste = threadInfo.getStackTrace()[i];
            sb.append("\tat ").append(ste.toString()).append('\n');
            if (i == 0 && threadInfo.getLockInfo() != null) {
                Thread.State ts = threadInfo.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ").append(threadInfo.getLockInfo()).append('\n');
                        break;
                    }
                    case WAITING: 
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ").append(threadInfo.getLockInfo()).append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : threadInfo.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked ").append(lockInfo).append('\n');
            }
        }
        LockInfo[] locks = threadInfo.getLockedSynchronizers();
        if (locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ").append(locks.length).append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- ").append(lockInfo).append('\n');
            }
        }
        sb.append('\n');
    }

    @Override
    public CompletableFuture<Void> stopAsync(ComponentContext componentContext) {
        ScheduledFuture<?> taskFuture = this.livenessProbeTaskFuture;
        if (taskFuture != null) {
            taskFuture.cancel(false);
        }
        return CompletableFutures.nullCompletedFuture();
    }
}

