/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.vault;

import java.util.Arrays;
import java.util.Objects;
import org.apache.ignite.internal.lang.ByteArray;

public final class VaultEntry {
    private final ByteArray key;
    private final byte[] val;

    public VaultEntry(ByteArray key, byte[] val) {
        this.key = key;
        this.val = val;
    }

    public ByteArray key() {
        return this.key;
    }

    public byte[] value() {
        return this.val;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VaultEntry entry = (VaultEntry)o;
        return this.key.equals(entry.key) && Arrays.equals(this.val, entry.val);
    }

    public int hashCode() {
        int result = Objects.hash(this.key);
        result = 31 * result + Arrays.hashCode(this.val);
        return result;
    }
}

