/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.subscription;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.ignite.internal.util.subscription.AccumulateException;
import org.apache.ignite.internal.util.subscription.Accumulator;

public class MapAccumulator<T, K, R>
implements Accumulator<T, Map<K, R>> {
    private final Map<K, R> result = new ConcurrentHashMap<K, R>();
    private final Function<T, K> keyMapper;
    private final Function<T, R> valueMapper;

    public MapAccumulator(Function<T, K> keyMapper, Function<T, R> valueMapper) {
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
    }

    @Override
    public void accumulate(T item) {
        K key = this.keyMapper.apply(item);
        R value = this.valueMapper.apply(item);
        if (key != null && value != null) {
            this.result.put(key, value);
        }
    }

    @Override
    public Map<K, R> get() throws AccumulateException {
        return this.result;
    }
}

