/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteCheckedException;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.TraceableException;

public final class ViewUtils {
    public static <T> T sync(CompletableFuture<T> fut) {
        try {
            return fut.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw (RuntimeException)ExceptionUtils.sneakyThrow(ViewUtils.ensurePublicException(e));
        }
        catch (ExecutionException e) {
            Throwable cause = ExceptionUtils.unwrapCause(e);
            throw (RuntimeException)ExceptionUtils.sneakyThrow(ViewUtils.ensurePublicException(cause));
        }
    }

    public static Throwable ensurePublicException(Throwable e) {
        Objects.requireNonNull(e);
        e = ExceptionUtils.unwrapCause(e);
        if (e instanceof IgniteException) {
            return ViewUtils.copyExceptionWithCauseIfPossible((IgniteException)e);
        }
        if (e instanceof IgniteCheckedException) {
            return ViewUtils.copyExceptionWithCauseIfPossible((IgniteCheckedException)e);
        }
        e = IgniteExceptionMapperUtil.mapToPublicException(e);
        return new IgniteException(ErrorGroups.Common.INTERNAL_ERR, e.getMessage(), e);
    }

    private static <T extends Throwable> Throwable copyExceptionWithCauseIfPossible(T e) {
        Object copy = ExceptionUtils.copyExceptionWithCause(e.getClass(), ((TraceableException)((Object)e)).traceId(), ((TraceableException)((Object)e)).code(), e.getMessage(), e);
        if (copy != null) {
            return copy;
        }
        return new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Public Ignite exception-derived class does not have required constructor: " + e.getClass().getName(), e);
    }

    public static <K> void checkKeysForNulls(Collection<K> keys) {
        ViewUtils.checkCollectionForNulls(keys, "keys", "key");
    }

    public static <K> void checkCollectionForNulls(Collection<K> coll, String collectionName, String elementName) {
        Objects.requireNonNull(coll, collectionName);
        for (K key : coll) {
            Objects.requireNonNull(key, elementName);
        }
    }

    private ViewUtils() {
    }
}

