/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.threading;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.ignite.cache.Cache;
import org.apache.ignite.catalog.IgniteCatalog;
import org.apache.ignite.catalog.definitions.CacheDefinition;
import org.apache.ignite.catalog.definitions.TableDefinition;
import org.apache.ignite.catalog.definitions.ZoneDefinition;
import org.apache.ignite.internal.table.distributed.PublicApiThreadingCache;
import org.apache.ignite.internal.table.distributed.PublicApiThreadingTable;
import org.apache.ignite.internal.thread.PublicApiThreading;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.table.QualifiedName;
import org.apache.ignite.table.Table;

public class PublicApiThreadingIgniteCatalog
implements IgniteCatalog,
Wrapper {
    private final IgniteCatalog catalog;
    private final Executor asyncContinuationExecutor;

    public PublicApiThreadingIgniteCatalog(IgniteCatalog catalog, Executor asyncContinuationExecutor) {
        this.catalog = catalog;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    @Override
    public CompletableFuture<Table> createTableAsync(Class<?> recordClass) {
        return this.doAsyncOperationForTable(() -> this.catalog.createTableAsync(recordClass));
    }

    @Override
    public CompletableFuture<Table> createTableAsync(Class<?> keyClass, Class<?> valueClass) {
        return this.doAsyncOperationForTable(() -> this.catalog.createTableAsync(keyClass, valueClass));
    }

    @Override
    public CompletableFuture<Table> createTableAsync(TableDefinition definition) {
        return this.doAsyncOperationForTable(() -> this.catalog.createTableAsync(definition));
    }

    @Override
    public Table createTable(Class<?> recordClass) {
        Table table = PublicApiThreading.execUserSyncOperation(() -> this.catalog.createTable(recordClass));
        return this.wrapTableForPublicUse(table);
    }

    @Override
    public Table createTable(Class<?> keyClass, Class<?> valueClass) {
        Table table = PublicApiThreading.execUserSyncOperation(() -> this.catalog.createTable(keyClass, valueClass));
        return this.wrapTableForPublicUse(table);
    }

    @Override
    public Table createTable(TableDefinition definition) {
        Table table = PublicApiThreading.execUserSyncOperation(() -> this.catalog.createTable(definition));
        return this.wrapTableForPublicUse(table);
    }

    @Override
    public CompletableFuture<TableDefinition> tableDefinitionAsync(QualifiedName tableName) {
        return this.doAsyncOperation(() -> this.catalog.tableDefinitionAsync(tableName));
    }

    @Override
    public TableDefinition tableDefinition(QualifiedName tableName) {
        return PublicApiThreading.execUserSyncOperation(() -> this.catalog.tableDefinition(tableName));
    }

    @Override
    public CompletableFuture<Void> createZoneAsync(ZoneDefinition definition) {
        return this.doAsyncOperation(() -> this.catalog.createZoneAsync(definition));
    }

    @Override
    public void createZone(ZoneDefinition definition) {
        PublicApiThreading.execUserSyncOperation(() -> this.catalog.createZone(definition));
    }

    @Override
    public CompletableFuture<ZoneDefinition> zoneDefinitionAsync(String zoneName) {
        return PublicApiThreading.execUserSyncOperation(() -> this.catalog.zoneDefinitionAsync(zoneName));
    }

    @Override
    public ZoneDefinition zoneDefinition(String zoneName) {
        return PublicApiThreading.execUserSyncOperation(() -> this.catalog.zoneDefinition(zoneName));
    }

    @Override
    public CompletableFuture<Void> dropTableAsync(TableDefinition definition) {
        return this.doAsyncOperation(() -> this.catalog.dropTableAsync(definition));
    }

    @Override
    public CompletableFuture<Void> dropTableAsync(QualifiedName name) {
        return this.doAsyncOperation(() -> this.catalog.dropTableAsync(name));
    }

    @Override
    public void dropTable(TableDefinition definition) {
        PublicApiThreading.execUserSyncOperation(() -> this.catalog.dropTable(definition));
    }

    @Override
    public void dropTable(QualifiedName name) {
        PublicApiThreading.execUserSyncOperation(() -> this.catalog.dropTable(name));
    }

    @Override
    public CompletableFuture<Void> dropZoneAsync(ZoneDefinition definition) {
        return this.doAsyncOperation(() -> this.catalog.dropZoneAsync(definition));
    }

    @Override
    public CompletableFuture<Void> dropZoneAsync(String name) {
        return this.doAsyncOperation(() -> this.catalog.dropZoneAsync(name));
    }

    @Override
    public void dropZone(ZoneDefinition definition) {
        PublicApiThreading.execUserSyncOperation(() -> this.catalog.dropZone(definition));
    }

    @Override
    public void dropZone(String name) {
        PublicApiThreading.execUserSyncOperation(() -> this.catalog.dropZone(name));
    }

    @Override
    public Cache createCache(Class<?> keyClass, Class<?> valueClass) {
        Cache cache = PublicApiThreading.execUserSyncOperation(() -> this.catalog.createCache(keyClass, valueClass));
        return this.wrapCacheForPublicUse(cache);
    }

    @Override
    public Cache createCache(CacheDefinition definition) {
        Cache cache = PublicApiThreading.execUserSyncOperation(() -> this.catalog.createCache(definition));
        return this.wrapCacheForPublicUse(cache);
    }

    @Override
    public CompletableFuture<Cache> createCacheAsync(Class<?> keyClass, Class<?> valueClass) {
        return this.doAsyncOperationForCache(() -> this.catalog.createCacheAsync(keyClass, valueClass));
    }

    @Override
    public CompletableFuture<Cache> createCacheAsync(CacheDefinition definition) {
        return this.doAsyncOperationForCache(() -> this.catalog.createCacheAsync(definition));
    }

    @Override
    public CacheDefinition cacheDefinition(QualifiedName name) {
        return PublicApiThreading.execUserSyncOperation(() -> this.catalog.cacheDefinition(name));
    }

    @Override
    public CompletableFuture<CacheDefinition> cacheDefinitionAsync(QualifiedName name) {
        return this.doAsyncOperation(() -> this.catalog.cacheDefinitionAsync(name));
    }

    @Override
    public void dropCache(CacheDefinition definition) {
        PublicApiThreading.execUserSyncOperation(() -> this.catalog.dropCache(definition));
    }

    @Override
    public void dropCache(QualifiedName name) {
        PublicApiThreading.execUserSyncOperation(() -> this.catalog.dropCache(name));
    }

    @Override
    public CompletableFuture<Void> dropCacheAsync(CacheDefinition definition) {
        return this.doAsyncOperation(() -> this.catalog.dropCacheAsync(definition));
    }

    @Override
    public CompletableFuture<Void> dropCacheAsync(QualifiedName name) {
        return this.doAsyncOperation(() -> this.catalog.dropCacheAsync(name));
    }

    private CompletableFuture<Table> doAsyncOperationForTable(Supplier<CompletableFuture<Table>> operation) {
        return this.doAsyncOperation(operation).thenApply(this::wrapTableForPublicUse);
    }

    private <T> CompletableFuture<T> doAsyncOperation(Supplier<CompletableFuture<T>> operation) {
        CompletableFuture<T> future = PublicApiThreading.execUserAsyncOperation(operation);
        return PublicApiThreading.preventThreadHijack(future, this.asyncContinuationExecutor);
    }

    private PublicApiThreadingTable wrapTableForPublicUse(Table table) {
        return new PublicApiThreadingTable(table, this.asyncContinuationExecutor);
    }

    private CompletableFuture<Cache> doAsyncOperationForCache(Supplier<CompletableFuture<Cache>> operation) {
        return this.doAsyncOperation(operation).thenApply(this::wrapCacheForPublicUse);
    }

    private PublicApiThreadingCache wrapCacheForPublicUse(Cache cache) {
        return new PublicApiThreadingCache(cache, this.asyncContinuationExecutor);
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.catalog);
    }
}

