/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.restart;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.restart.IgniteAttachmentLock;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.lang.CancellationToken;
import org.apache.ignite.sql.BatchedArguments;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.sql.ResultSet;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.sql.Statement;
import org.apache.ignite.sql.async.AsyncResultSet;
import org.apache.ignite.table.mapper.Mapper;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

class RestartProofIgniteSql
implements IgniteSql,
Wrapper {
    private final IgniteAttachmentLock attachmentLock;

    RestartProofIgniteSql(IgniteAttachmentLock attachmentLock) {
        this.attachmentLock = attachmentLock;
    }

    @Override
    public Statement createStatement(String query) {
        return this.attachmentLock.attached(ignite -> ignite.sql().createStatement(query));
    }

    @Override
    public Statement.StatementBuilder statementBuilder() {
        return this.attachmentLock.attached(ignite -> ignite.sql().statementBuilder());
    }

    @Override
    public ResultSet<SqlRow> execute(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return this.attachmentLock.attached(ignite -> ignite.sql().execute(transaction, cancellationToken, query, arguments));
    }

    @Override
    public ResultSet<SqlRow> execute(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return this.attachmentLock.attached(ignite -> ignite.sql().execute(transaction, cancellationToken, statement, arguments));
    }

    @Override
    public <T> ResultSet<T> execute(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return this.attachmentLock.attached(ignite -> ignite.sql().execute(transaction, mapper, cancellationToken, query, arguments));
    }

    @Override
    public <T> ResultSet<T> execute(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return this.attachmentLock.attached(ignite -> ignite.sql().execute(transaction, mapper, cancellationToken, statement, arguments));
    }

    @Override
    public CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.sql().executeAsync(transaction, cancellationToken, query, arguments));
    }

    @Override
    public CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.sql().executeAsync(transaction, cancellationToken, statement, arguments));
    }

    @Override
    public <T> CompletableFuture<AsyncResultSet<T>> executeAsync(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.sql().executeAsync(transaction, mapper, cancellationToken, query, arguments));
    }

    @Override
    public <T> CompletableFuture<AsyncResultSet<T>> executeAsync(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.sql().executeAsync(transaction, mapper, cancellationToken, statement, arguments));
    }

    @Override
    public long[] executeBatch(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String dmlQuery, BatchedArguments batch) {
        return this.attachmentLock.attached(ignite -> ignite.sql().executeBatch(transaction, cancellationToken, dmlQuery, batch));
    }

    @Override
    public long[] executeBatch(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement dmlStatement, BatchedArguments batch) {
        return this.attachmentLock.attached(ignite -> ignite.sql().executeBatch(transaction, cancellationToken, dmlStatement, batch));
    }

    @Override
    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, BatchedArguments batch) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.sql().executeBatchAsync(transaction, cancellationToken, query, batch));
    }

    @Override
    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, BatchedArguments batch) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.sql().executeBatchAsync(transaction, cancellationToken, statement, batch));
    }

    @Override
    public void executeScript(String query, Object ... arguments) {
        this.attachmentLock.consumeAttached(ignite -> ignite.sql().executeScript(query, arguments));
    }

    @Override
    public void executeScript(@Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        this.attachmentLock.consumeAttached(ignite -> ignite.sql().executeScript(cancellationToken, query, arguments));
    }

    @Override
    public CompletableFuture<Void> executeScriptAsync(String query, Object ... arguments) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.sql().executeScriptAsync(query, arguments));
    }

    @Override
    public CompletableFuture<Void> executeScriptAsync(@Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.sql().executeScriptAsync(cancellationToken, query, arguments));
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)this.attachmentLock.attached(ignite -> Wrappers.unwrap(ignite.sql(), classToUnwrap));
    }
}

