/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.restart;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.restart.IgniteAttachmentLock;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.IgniteCluster;
import org.jetbrains.annotations.Nullable;

public class RestartProofIgniteCluster
implements IgniteCluster,
Wrapper {
    private final IgniteAttachmentLock attachmentLock;

    RestartProofIgniteCluster(IgniteAttachmentLock attachmentLock) {
        this.attachmentLock = attachmentLock;
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)this.attachmentLock.attached(ignite -> Wrappers.unwrap(ignite.cluster(), classToUnwrap));
    }

    @Override
    public UUID id() {
        return this.attachmentLock.attached(ignite -> ignite.cluster().id());
    }

    @Override
    public Collection<ClusterNode> nodes() {
        return this.attachmentLock.attached(ignite -> ignite.cluster().nodes());
    }

    @Override
    public CompletableFuture<Collection<ClusterNode>> nodesAsync() {
        return this.attachmentLock.attached(ignite -> ignite.cluster().nodesAsync());
    }

    @Override
    @Nullable
    public ClusterNode localNode() {
        return this.attachmentLock.attached(ignite -> ignite.cluster().localNode());
    }
}

