/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.restart;

import org.apache.ignite.Ignite;
import org.apache.ignite.cache.manager.IgniteCaches;
import org.apache.ignite.catalog.IgniteCatalog;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.internal.restart.IgniteAttachmentLock;
import org.apache.ignite.internal.restart.RestartProofIgniteCaches;
import org.apache.ignite.internal.restart.RestartProofIgniteCatalog;
import org.apache.ignite.internal.restart.RestartProofIgniteCluster;
import org.apache.ignite.internal.restart.RestartProofIgniteCompute;
import org.apache.ignite.internal.restart.RestartProofIgniteSql;
import org.apache.ignite.internal.restart.RestartProofIgniteTables;
import org.apache.ignite.internal.restart.RestartProofIgniteTransactions;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.network.IgniteCluster;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.tx.IgniteTransactions;
import org.gridgain.structure.IgniteStructures;

public class RestartProofIgnite
implements Ignite,
Wrapper {
    private final IgniteAttachmentLock attachmentLock;
    private final IgniteTables tables;
    private final IgniteTransactions transactions;
    private final IgniteSql sql;
    private final IgniteCompute compute;
    private final IgniteCatalog catalog;
    private final RestartProofIgniteCluster cluster;
    private final IgniteCaches caches;

    public RestartProofIgnite(IgniteAttachmentLock attachmentLock) {
        this.attachmentLock = attachmentLock;
        this.tables = new RestartProofIgniteTables(attachmentLock);
        this.transactions = new RestartProofIgniteTransactions(attachmentLock);
        this.sql = new RestartProofIgniteSql(attachmentLock);
        this.compute = new RestartProofIgniteCompute(attachmentLock);
        this.catalog = new RestartProofIgniteCatalog(attachmentLock);
        this.cluster = new RestartProofIgniteCluster(attachmentLock);
        this.caches = new RestartProofIgniteCaches(attachmentLock);
    }

    @Override
    public String name() {
        return this.attachmentLock.attached(Ignite::name);
    }

    @Override
    public IgniteTables tables() {
        return this.tables;
    }

    @Override
    public IgniteCaches caches() {
        return this.caches;
    }

    @Override
    public IgniteTransactions transactions() {
        return this.transactions;
    }

    @Override
    public IgniteSql sql() {
        return this.sql;
    }

    @Override
    public IgniteCompute compute() {
        return this.compute;
    }

    @Override
    public IgniteCatalog catalog() {
        return this.catalog;
    }

    @Override
    public IgniteCluster cluster() {
        return this.cluster;
    }

    @Override
    public IgniteStructures structures() {
        return this.attachmentLock.attached(Ignite::structures);
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)this.attachmentLock.attached(classToUnwrap::cast);
    }
}

