/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.restart;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.util.StripedVersatileReadWriteLock;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;

public class IgniteAttachmentLock {
    private final Supplier<Ignite> igniteRef;
    private final StripedVersatileReadWriteLock lock;

    public IgniteAttachmentLock(Supplier<Ignite> igniteRef, Executor asyncContinuationExecutor) {
        this.igniteRef = igniteRef;
        this.lock = new StripedVersatileReadWriteLock(asyncContinuationExecutor);
    }

    public <T> T attached(Function<? super Ignite, ? extends T> action) {
        this.lock.readLock();
        try {
            T t = action.apply(this.actualIgniteOrThrow());
            return t;
        }
        finally {
            this.lock.readUnlock();
        }
    }

    public void consumeAttached(Consumer<? super Ignite> action) {
        this.lock.readLock();
        try {
            action.accept(this.actualIgniteOrThrow());
        }
        finally {
            this.lock.readUnlock();
        }
    }

    public <T> CompletableFuture<T> attachedAsync(Function<? super Ignite, ? extends CompletableFuture<T>> action) {
        return this.lock.inReadLockAsync(() -> (CompletableFuture)action.apply(this.actualIgniteOrThrow()));
    }

    private Ignite actualIgniteOrThrow() {
        Ignite ignite = this.igniteRef.get();
        if (ignite == null) {
            throw new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "The node is already shut down.");
        }
        return ignite;
    }

    public <T> CompletableFuture<T> detachedAsync(Supplier<? extends CompletableFuture<T>> action) {
        return this.lock.inWriteLockAsync(action);
    }
}

