/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization.marshal;

import java.io.DataInput;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.apache.ignite.internal.network.serialization.DescriptorRegistry;
import org.apache.ignite.internal.network.serialization.FieldAccessor;
import org.apache.ignite.internal.network.serialization.FieldDescriptor;
import org.apache.ignite.internal.network.serialization.MergedField;
import org.apache.ignite.internal.network.serialization.MergedLayer;
import org.apache.ignite.internal.network.serialization.SpecialMethodInvocationException;
import org.apache.ignite.internal.network.serialization.marshal.BestEffortInstantiation;
import org.apache.ignite.internal.network.serialization.marshal.DefaultFieldsReaderWriter;
import org.apache.ignite.internal.network.serialization.marshal.DefaultNullsBitsetWriter;
import org.apache.ignite.internal.network.serialization.marshal.Instantiation;
import org.apache.ignite.internal.network.serialization.marshal.InstantiationException;
import org.apache.ignite.internal.network.serialization.marshal.MarshalException;
import org.apache.ignite.internal.network.serialization.marshal.MarshallingContext;
import org.apache.ignite.internal.network.serialization.marshal.NullsBitsetReader;
import org.apache.ignite.internal.network.serialization.marshal.NullsBitsetWriter;
import org.apache.ignite.internal.network.serialization.marshal.SchemaMismatchException;
import org.apache.ignite.internal.network.serialization.marshal.SchemaMismatchHandlers;
import org.apache.ignite.internal.network.serialization.marshal.SerializableInstantiation;
import org.apache.ignite.internal.network.serialization.marshal.TypedValueReader;
import org.apache.ignite.internal.network.serialization.marshal.TypedValueWriter;
import org.apache.ignite.internal.network.serialization.marshal.UnmarshalException;
import org.apache.ignite.internal.network.serialization.marshal.UnmarshallingContext;
import org.apache.ignite.internal.network.serialization.marshal.UnsafeInstantiation;
import org.apache.ignite.internal.network.serialization.marshal.UosObjectInputStream;
import org.apache.ignite.internal.network.serialization.marshal.UosObjectOutputStream;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.util.io.IgniteUnsafeDataInput;
import org.jetbrains.annotations.Nullable;

class StructuredObjectMarshaller
implements DefaultFieldsReaderWriter {
    private final DescriptorRegistry localDescriptors;
    private final TypedValueWriter valueWriter;
    private final TypedValueWriter unsharedWriter;
    private final TypedValueReader valueReader;
    private final TypedValueReader unsharedReader;
    private final SchemaMismatchHandlers schemaMismatchHandlers;
    private final Instantiation instantiation = new BestEffortInstantiation(new SerializableInstantiation(), new UnsafeInstantiation());
    private final NullsBitsetWriter nullsBitsetWriter = new DefaultNullsBitsetWriter();

    StructuredObjectMarshaller(DescriptorRegistry localDescriptors, TypedValueWriter valueWriter, TypedValueWriter unsharedWriter, TypedValueReader valueReader, TypedValueReader unsharedReader, SchemaMismatchHandlers schemaMismatchHandlers) {
        this.localDescriptors = localDescriptors;
        this.valueWriter = valueWriter;
        this.unsharedWriter = unsharedWriter;
        this.valueReader = valueReader;
        this.unsharedReader = unsharedReader;
        this.schemaMismatchHandlers = schemaMismatchHandlers;
    }

    void writeStructuredObject(Object object, ClassDescriptor descriptor, IgniteDataOutput output, MarshallingContext context) throws MarshalException, IOException {
        List<ClassDescriptor> lineage = descriptor.lineage();
        for (ClassDescriptor layer : lineage) {
            this.writeStructuredObjectLayer(object, layer, output, context);
        }
    }

    private void writeStructuredObjectLayer(Object object, ClassDescriptor layer, IgniteDataOutput output, MarshallingContext context) throws IOException, MarshalException {
        if (layer.hasWriteObject()) {
            this.writeWithWriteObject(object, layer, output, context);
        } else {
            this.defaultWriteFields(object, layer, output, context);
        }
        context.addUsedDescriptor(layer);
    }

    private void writeWithWriteObject(Object object, ClassDescriptor descriptor, IgniteDataOutput output, MarshallingContext context) throws IOException, MarshalException {
        UosObjectOutputStream oos = context.objectOutputStream(output, this.valueWriter, this.unsharedWriter, this);
        UosObjectOutputStream.UosPutField oldPut = oos.replaceCurrentPutFieldWithNull();
        context.startWritingWithWriteObject(object, descriptor);
        try {
            this.writeObjectWithLength(object, descriptor, oos);
            oos.flush();
        }
        catch (SpecialMethodInvocationException e) {
            throw new MarshalException("Cannot invoke writeObject()", (Throwable)e);
        }
        finally {
            context.endWritingWithWriteObject();
            oos.restoreCurrentPutFieldTo(oldPut);
        }
    }

    private void writeObjectWithLength(Object object, ClassDescriptor descriptor, UosObjectOutputStream oos) throws IOException, SpecialMethodInvocationException {
        int offsetBefore = oos.memoryBufferOffset();
        this.writeLengthPlaceholder(oos);
        descriptor.serializationMethods().writeObject(object, oos);
        oos.flush();
        int externalDataLength = oos.memoryBufferOffset() - offsetBefore - 4;
        oos.writeIntAtOffset(offsetBefore, externalDataLength);
    }

    private void writeLengthPlaceholder(UosObjectOutputStream oos) throws IOException {
        oos.writeInt(0);
    }

    @Override
    public void defaultWriteFields(Object object, ClassDescriptor descriptor, IgniteDataOutput output, MarshallingContext context) throws MarshalException, IOException {
        @Nullable BitSet nullsBitSet = this.nullsBitsetWriter.writeNullsBitSet(object, descriptor, output);
        for (FieldDescriptor fieldDescriptor : descriptor.fields()) {
            if (!StructuredObjectMarshaller.cannotAvoidWritingNull(fieldDescriptor, descriptor, nullsBitSet)) continue;
            this.writeField(object, fieldDescriptor, output, context);
        }
    }

    static boolean cannotAvoidWritingNull(FieldDescriptor fieldDescriptor, ClassDescriptor descriptor, @Nullable BitSet nullsBitSet) {
        int maybeIndexInBitmap = descriptor.fieldIndexInNullsBitmap(fieldDescriptor.name());
        assert (maybeIndexInBitmap < 0 || nullsBitSet != null) : "Index is " + maybeIndexInBitmap;
        return maybeIndexInBitmap < 0 || !nullsBitSet.get(maybeIndexInBitmap);
    }

    private void writeField(Object object, FieldDescriptor fieldDescriptor, IgniteDataOutput output, MarshallingContext context) throws MarshalException, IOException {
        if (fieldDescriptor.isPrimitive()) {
            this.writePrimitiveFieldValue(object, fieldDescriptor, output);
            context.addUsedDescriptor(this.localDescriptors.getRequiredDescriptor(fieldDescriptor.typeDescriptorId()));
        } else {
            Object fieldValue = this.getFieldValue(object, fieldDescriptor);
            this.valueWriter.write(fieldValue, fieldDescriptor, output, context);
        }
    }

    private Object getFieldValue(Object object, FieldDescriptor fieldDescriptor) {
        return fieldDescriptor.accessor().getObject(object);
    }

    private void writePrimitiveFieldValue(Object object, FieldDescriptor fieldDescriptor, IgniteDataOutput output) throws IOException {
        FieldAccessor fieldAccessor = fieldDescriptor.accessor();
        switch (fieldDescriptor.typeDescriptorId()) {
            case 0: {
                output.writeByte(fieldAccessor.getByte(object));
                break;
            }
            case 2: {
                output.writeShort(fieldAccessor.getShort(object));
                break;
            }
            case 4: {
                output.writeInt(fieldAccessor.getInt(object));
                break;
            }
            case 8: {
                output.writeLong(fieldAccessor.getLong(object));
                break;
            }
            case 6: {
                output.writeFloat(fieldAccessor.getFloat(object));
                break;
            }
            case 10: {
                output.writeDouble(fieldAccessor.getDouble(object));
                break;
            }
            case 14: {
                output.writeChar(fieldAccessor.getChar(object));
                break;
            }
            case 12: {
                output.writeBoolean(fieldAccessor.getBoolean(object));
                break;
            }
            default: {
                throw new IllegalStateException(fieldDescriptor.typeName() + " is primitive but not covered");
            }
        }
    }

    Object preInstantiateStructuredObject(ClassDescriptor descriptor) throws UnmarshalException {
        try {
            return this.instantiation.newInstance(descriptor.localClass());
        }
        catch (InstantiationException e) {
            throw new UnmarshalException("Cannot instantiate " + descriptor.className(), (Throwable)e);
        }
    }

    void fillStructuredObjectFrom(IgniteDataInput input, Object object, ClassDescriptor remoteDescriptor, UnmarshallingContext context) throws IOException, UnmarshalException {
        List<MergedLayer> lineage = remoteDescriptor.mergedLineage();
        for (MergedLayer mergedLayer : lineage) {
            if (mergedLayer.hasRemote()) {
                this.fillStructuredObjectLayerFrom(input, mergedLayer.remote(), object, context);
                continue;
            }
            if (!mergedLayer.hasLocal()) continue;
            this.fireEventsForLocalOnlyLayer(object, mergedLayer.local());
        }
    }

    private void fireEventsForLocalOnlyLayer(Object object, ClassDescriptor localLayer) throws SchemaMismatchException {
        this.fireOnFieldMissedOnLayerFields(object, localLayer);
        this.schemaMismatchHandlers.onReadObjectMissed(localLayer.className(), object);
    }

    private void fireOnFieldMissedOnLayerFields(Object object, ClassDescriptor layer) throws SchemaMismatchException {
        for (FieldDescriptor localField : layer.fields()) {
            this.schemaMismatchHandlers.onFieldMissed(layer.className(), object, localField.name());
        }
    }

    private void fillStructuredObjectLayerFrom(IgniteDataInput input, ClassDescriptor remoteLayer, Object object, UnmarshallingContext context) throws IOException, UnmarshalException {
        boolean hasReadObjectLocally;
        boolean bl = hasReadObjectLocally = remoteLayer.hasLocal() && remoteLayer.local().hasReadObject();
        if (remoteLayer.hasWriteObject()) {
            if (hasReadObjectLocally) {
                this.fillObjectWithReadObjectFrom(input, object, remoteLayer, context);
            } else {
                this.fireReadObjectIgnored(remoteLayer, object, input, context);
            }
        } else {
            this.defaultFillFieldsFrom(input, object, remoteLayer, context);
            if (hasReadObjectLocally) {
                this.schemaMismatchHandlers.onReadObjectMissed(remoteLayer.className(), object);
            }
        }
    }

    private void fillObjectWithReadObjectFrom(IgniteDataInput input, Object object, ClassDescriptor descriptor, UnmarshallingContext context) throws IOException, UnmarshalException {
        UosObjectInputStream ois = context.objectInputStream(input, this.valueReader, this.unsharedReader, this);
        UosObjectInputStream.UosGetField oldGet = ois.replaceCurrentGetFieldWithNull();
        context.startReadingWithReadObject(object, descriptor);
        try {
            this.readObjectWithLength(object, descriptor, ois);
        }
        catch (SpecialMethodInvocationException e) {
            throw new UnmarshalException("Cannot invoke readObject()", (Throwable)e);
        }
        finally {
            context.endReadingWithReadObject();
            ois.restoreCurrentGetFieldTo(oldGet);
        }
    }

    private void readObjectWithLength(Object object, ClassDescriptor descriptor, UosObjectInputStream ois) throws IOException, SpecialMethodInvocationException {
        this.skipWriteObjectDataLength(ois);
        descriptor.serializationMethods().readObject(object, ois);
    }

    private void skipWriteObjectDataLength(UosObjectInputStream ois) throws IOException {
        ois.readInt();
    }

    private void fireReadObjectIgnored(ClassDescriptor remoteLayer, Object object, IgniteDataInput input, UnmarshallingContext context) throws SchemaMismatchException, IOException {
        int writeObjectDataLength = input.readInt();
        byte[] writeObjectDataBytes = new byte[writeObjectDataLength];
        int actuallyRead = input.readFewBytes(writeObjectDataBytes, 0, writeObjectDataLength);
        if (actuallyRead != writeObjectDataLength) {
            throw new IOException("Premature end of the input stream: expected to read " + writeObjectDataLength + ", but only got " + actuallyRead);
        }
        IgniteUnsafeDataInput externalDataInput = new IgniteUnsafeDataInput(writeObjectDataBytes);
        try (UosObjectInputStream oos = new UosObjectInputStream(externalDataInput, this.valueReader, this.unsharedReader, this, context);){
            this.schemaMismatchHandlers.onReadObjectIgnored(remoteLayer.className(), object, oos);
        }
    }

    @Override
    public void defaultFillFieldsFrom(IgniteDataInput input, Object object, ClassDescriptor remoteLayer, UnmarshallingContext context) throws IOException, UnmarshalException {
        @Nullable BitSet nullsBitSet = NullsBitsetReader.readNullsBitSet(input, remoteLayer);
        for (MergedField mergedField : remoteLayer.mergedFields()) {
            if (mergedField.hasRemote()) {
                this.fillFieldWithNullSkippedCheckFrom(input, object, mergedField, remoteLayer, nullsBitSet, context);
                continue;
            }
            this.schemaMismatchHandlers.onFieldMissed(remoteLayer.className(), object, mergedField.name());
        }
    }

    private void fillFieldWithNullSkippedCheckFrom(IgniteDataInput input, Object object, MergedField mergedField, ClassDescriptor layerDescriptor, @Nullable BitSet nullsBitSet, UnmarshallingContext context) throws IOException, UnmarshalException {
        if (StructuredObjectMarshaller.nullWasSkippedWhileWriting(mergedField.remote(), layerDescriptor, nullsBitSet)) {
            this.setFieldValue(object, mergedField, null, layerDescriptor);
        } else {
            this.fillFieldFrom(input, object, context, mergedField, layerDescriptor);
        }
    }

    static boolean nullWasSkippedWhileWriting(FieldDescriptor fieldDescriptor, ClassDescriptor descriptor, @Nullable BitSet nullsBitSet) {
        int maybeIndexInBitmap = descriptor.fieldIndexInNullsBitmap(fieldDescriptor.name());
        assert (maybeIndexInBitmap < 0 || nullsBitSet != null) : "Index is " + maybeIndexInBitmap;
        return maybeIndexInBitmap >= 0 && nullsBitSet.get(maybeIndexInBitmap);
    }

    private void fillFieldFrom(IgniteDataInput input, Object object, UnmarshallingContext context, MergedField mergedField, ClassDescriptor layerDescriptor) throws IOException, UnmarshalException {
        if (mergedField.remote().isPrimitive()) {
            this.fillPrimitiveFieldFrom(input, object, mergedField, layerDescriptor);
        } else {
            Object fieldValue = this.valueReader.read(input, mergedField.remote(), context);
            this.setFieldValue(object, mergedField, fieldValue, layerDescriptor);
        }
    }

    private void setFieldValue(Object object, MergedField mergedField, Object fieldValue, ClassDescriptor layerDescriptor) throws SchemaMismatchException {
        if (!mergedField.hasLocal()) {
            this.fireFieldIgnored(layerDescriptor, object, mergedField, fieldValue);
            return;
        }
        if (mergedField.typesAreDifferent() && !mergedField.typesAreCompatible()) {
            this.fireFieldTypeChanged(layerDescriptor, object, mergedField, fieldValue);
            return;
        }
        if (mergedField.typesAreDifferent()) {
            fieldValue = mergedField.convertToLocalType(fieldValue);
        }
        mergedField.local().accessor().setObject(object, fieldValue);
    }

    private void fireFieldIgnored(ClassDescriptor layerDescriptor, Object object, MergedField mergedField, Object fieldValue) throws SchemaMismatchException {
        this.schemaMismatchHandlers.onFieldIgnored(layerDescriptor.className(), object, mergedField.name(), fieldValue);
    }

    private void fireFieldTypeChanged(ClassDescriptor layerDescriptor, Object object, MergedField mergedField, Object fieldValue) throws SchemaMismatchException {
        this.schemaMismatchHandlers.onFieldTypeChanged(layerDescriptor.className(), object, mergedField.name(), mergedField.remote().localClass(), fieldValue);
    }

    private void fillPrimitiveFieldFrom(DataInput input, Object object, MergedField mergedField, ClassDescriptor layerDescriptor) throws IOException, SchemaMismatchException {
        if (!mergedField.hasLocal()) {
            Object value = this.readPrimitiveValue(input, mergedField.remote());
            this.fireFieldIgnored(layerDescriptor, object, mergedField, value);
            return;
        }
        if (mergedField.typesAreDifferent()) {
            Object value = this.readPrimitiveValue(input, mergedField.remote());
            this.fireFieldTypeChanged(layerDescriptor, object, mergedField, value);
            return;
        }
        this.fillPrimitiveFieldWithAccessorFrom(input, object, mergedField, mergedField.local().accessor());
    }

    private Object readPrimitiveValue(DataInput input, FieldDescriptor fieldDescriptor) throws IOException {
        switch (fieldDescriptor.typeDescriptorId()) {
            case 0: {
                return input.readByte();
            }
            case 2: {
                return input.readShort();
            }
            case 4: {
                return input.readInt();
            }
            case 8: {
                return input.readLong();
            }
            case 6: {
                return Float.valueOf(input.readFloat());
            }
            case 10: {
                return input.readDouble();
            }
            case 14: {
                return Character.valueOf(input.readChar());
            }
            case 12: {
                return input.readBoolean();
            }
        }
        throw new IllegalStateException(fieldDescriptor.typeName() + " is primitive but not covered");
    }

    private void fillPrimitiveFieldWithAccessorFrom(DataInput input, Object object, MergedField mergedField, FieldAccessor localAccessor) throws IOException {
        switch (mergedField.remote().typeDescriptorId()) {
            case 0: {
                localAccessor.setByte(object, input.readByte());
                break;
            }
            case 2: {
                localAccessor.setShort(object, input.readShort());
                break;
            }
            case 4: {
                localAccessor.setInt(object, input.readInt());
                break;
            }
            case 8: {
                localAccessor.setLong(object, input.readLong());
                break;
            }
            case 6: {
                localAccessor.setFloat(object, input.readFloat());
                break;
            }
            case 10: {
                localAccessor.setDouble(object, input.readDouble());
                break;
            }
            case 14: {
                localAccessor.setChar(object, input.readChar());
                break;
            }
            case 12: {
                localAccessor.setBoolean(object, input.readBoolean());
                break;
            }
            default: {
                throw new IllegalStateException(mergedField.remote().typeName() + " is primitive but not covered");
            }
        }
    }
}

