/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization.marshal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.ignite.internal.util.VarIntUtils;

class ProtocolMarshalling {
    static final int MAX_LENGTH_BYTE_COUNT = 4;

    static void writeDescriptorOrCommandId(int id, DataOutput output) throws IOException {
        ProtocolMarshalling.writeUnsignedVarInt(id, output);
    }

    private static void writeUnsignedVarInt(int val, DataOutput output) throws IOException {
        assert (val >= 0) : val;
        VarIntUtils.writeVarInt(val - 1, output);
    }

    static int readDescriptorOrCommandId(DataInput input) throws IOException {
        return ProtocolMarshalling.readUnsignedVarInt(input);
    }

    private static int readUnsignedVarInt(DataInput input) throws IOException {
        long value = VarIntUtils.readVarInt(input);
        assert (value >= -1L && (long)((int)value) == value) : value;
        return (int)value + 1;
    }

    static void writeObjectId(int id, DataOutput output) throws IOException {
        ProtocolMarshalling.writeUnsignedVarInt(id, output);
    }

    static int readObjectId(DataInput input) throws IOException {
        return ProtocolMarshalling.readUnsignedVarInt(input);
    }

    static void writeLength(int length, DataOutput output) throws IOException {
        ProtocolMarshalling.writeUnsignedVarInt(length, output);
    }

    static int readLength(DataInput input) throws IOException {
        return ProtocolMarshalling.readUnsignedVarInt(input);
    }

    static void writeFixedLengthBitSet(BitSet bitset, int bitSetLength, DataOutput output) throws IOException {
        int bits = 0;
        int writtenBytes = 0;
        for (int i = 0; i < bitSetLength; ++i) {
            boolean bit = bitset.get(i);
            int bitIndex = i % 8;
            if (bit) {
                bits = (byte)(bits | 1 << bitIndex);
            }
            if (bitIndex != 7) continue;
            output.writeByte(bits);
            ++writtenBytes;
            bits = 0;
        }
        int totalBytesToWrite = bitSetLength / 8 + (bitSetLength % 8 == 0 ? 0 : 1);
        if (writtenBytes < totalBytesToWrite) {
            output.writeByte(bits);
        }
    }

    static BitSet readFixedLengthBitSet(int bitSetLength, DataInput input) throws IOException {
        BitSet bitSet = new BitSet(bitSetLength);
        int totalBytesToRead = bitSetLength / 8 + (bitSetLength % 8 == 0 ? 0 : 1);
        for (int byteIndex = 0; byteIndex < totalBytesToRead; ++byteIndex) {
            byte bits = input.readByte();
            int bitsToReadInThisByte = byteIndex < totalBytesToRead - 1 ? 8 : bitSetLength - (totalBytesToRead - 1) * 8;
            for (int bitIndex = 0; bitIndex < bitsToReadInThisByte; ++bitIndex) {
                if ((bits & 1 << bitIndex) == 0) continue;
                bitSet.set(byteIndex * 8 + bitIndex);
            }
        }
        return bitSet;
    }

    private ProtocolMarshalling() {
    }
}

