/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.ignite.internal.network.serialization.NetworkAddressSerializer;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.apache.ignite.network.NetworkAddress;

public class NetworkAddressesSerializer
extends VersionedSerializer<Set<NetworkAddress>> {
    public static final NetworkAddressesSerializer INSTANCE = new NetworkAddressesSerializer();
    private final NetworkAddressSerializer networkAddressSerializer = NetworkAddressSerializer.INSTANCE;

    @Override
    protected void writeExternalData(Set<NetworkAddress> addresses, IgniteDataOutput out) throws IOException {
        out.writeVarInt(addresses.size());
        for (NetworkAddress address : addresses) {
            this.networkAddressSerializer.writeExternal(address, out);
        }
    }

    @Override
    protected Set<NetworkAddress> readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        int length = in.readVarIntAsInt();
        HashSet<NetworkAddress> addresses = new HashSet<NetworkAddress>(IgniteUtils.capacity(length));
        for (int i = 0; i < length; ++i) {
            addresses.add((NetworkAddress)this.networkAddressSerializer.readExternal(in));
        }
        return addresses;
    }

    public static byte[] serialize(Set<NetworkAddress> addresses) {
        return VersionedSerialization.toBytes(addresses, INSTANCE);
    }

    public static Set<NetworkAddress> deserialize(byte[] bytes) {
        return VersionedSerialization.fromBytes(bytes, INSTANCE);
    }
}

