/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization;

import java.io.IOException;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.apache.ignite.internal.versioned.VersionedSerialization;
import org.apache.ignite.internal.versioned.VersionedSerializer;
import org.apache.ignite.network.NetworkAddress;

public class NetworkAddressSerializer
extends VersionedSerializer<NetworkAddress> {
    public static final NetworkAddressSerializer INSTANCE = new NetworkAddressSerializer();

    @Override
    protected void writeExternalData(NetworkAddress address, IgniteDataOutput out) throws IOException {
        out.writeUTF(address.host());
        out.writeInt(address.port());
    }

    @Override
    protected NetworkAddress readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        String host = in.readUTF();
        int port = in.readInt();
        return new NetworkAddress(host, port);
    }

    public static byte[] serialize(NetworkAddress address) {
        return VersionedSerialization.toBytes(address, INSTANCE);
    }

    public static NetworkAddress deserialize(byte[] bytes) {
        return VersionedSerialization.fromBytes(bytes, INSTANCE);
    }
}

