/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import org.apache.ignite.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessageV2;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessageV2Impl;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class HandshakeStartResponseMessageV2Serializer
implements MessageSerializer<HandshakeStartResponseMessageV2> {
    public static final HandshakeStartResponseMessageV2Serializer INSTANCE = new HandshakeStartResponseMessageV2Serializer();

    private HandshakeStartResponseMessageV2Serializer() {
    }

    @Override
    public boolean writeMessage(HandshakeStartResponseMessageV2 msg, MessageWriter writer) throws MessageMappingException {
        HandshakeStartResponseMessageV2Impl message = (HandshakeStartResponseMessageV2Impl)msg;
        writer.setMessageTypeInfo(NetworkMessagesTypeInfos.handshakeStartResponseMessageV2());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)4)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeShort("connectionId", message.connectionId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeBitSet("featureSet", message.featureSet());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeMessage("initiatorNode", message.initiatorNode());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeLong("receivedCount", message.receivedCount());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

