/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import java.util.BitSet;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite.internal.network.message.ClusterNodeMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessageV2;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartResponseMessageV2Builder;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class HandshakeStartResponseMessageV2Deserializer
implements MessageDeserializer<HandshakeStartResponseMessageV2> {
    private final HandshakeStartResponseMessageV2Builder msg;

    HandshakeStartResponseMessageV2Deserializer(NetworkMessagesFactory messageFactory) {
        this.msg = messageFactory.handshakeStartResponseMessageV2();
    }

    @Override
    public Class<HandshakeStartResponseMessageV2> klass() {
        return HandshakeStartResponseMessageV2.class;
    }

    @Override
    public HandshakeStartResponseMessageV2 getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(NetworkMessagesTypeInfos.handshakeStartResponseMessageV2());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                short tmp = reader.readShort("connectionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.connectionId(tmp);
                reader.incrementState();
            }
            case 1: {
                Cloneable tmp = reader.readBitSet("featureSet");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.featureSet((BitSet)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Cloneable tmp = (ClusterNodeMessage)reader.readMessage("initiatorNode");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initiatorNode((ClusterNodeMessage)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                long tmp = reader.readLong("receivedCount");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.receivedCount(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HandshakeStartResponseMessageV2.class);
    }
}

