/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import org.apache.ignite.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeStartMessageImpl;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class HandshakeStartMessageSerializer
implements MessageSerializer<HandshakeStartMessage> {
    public static final HandshakeStartMessageSerializer INSTANCE = new HandshakeStartMessageSerializer();

    private HandshakeStartMessageSerializer() {
    }

    @Override
    public boolean writeMessage(HandshakeStartMessage msg, MessageWriter writer) throws MessageMappingException {
        HandshakeStartMessageImpl message = (HandshakeStartMessageImpl)msg;
        writer.setMessageTypeInfo(NetworkMessagesTypeInfos.handshakeStartMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)4)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeString("productName", message.productName());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("productVersion", message.productVersion());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeUuid("serverClusterId", message.serverClusterId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeMessage("serverNode", message.serverNode());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

