/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import java.util.Objects;
import org.apache.ignite.internal.network.recovery.message.HandshakeRejectedMessage;
import org.apache.ignite.internal.network.recovery.message.HandshakeRejectedMessageBuilder;
import org.apache.ignite.internal.network.recovery.message.HandshakeRejectedMessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class HandshakeRejectedMessageImpl
implements HandshakeRejectedMessage,
Cloneable {
    public static final short GROUP_TYPE = 1;
    public static final short TYPE = 6;
    @IgniteToStringInclude
    private final String message;
    @IgniteToStringInclude
    private final String reasonString;

    private HandshakeRejectedMessageImpl(String message, String reasonString) {
        this.message = message;
        this.reasonString = reasonString;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public String reasonString() {
        return this.reasonString;
    }

    public MessageSerializer serializer() {
        return HandshakeRejectedMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 1;
    }

    public String toString() {
        return S.toString(HandshakeRejectedMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 6;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HandshakeRejectedMessageImpl otherMessage = (HandshakeRejectedMessageImpl)other;
        return Objects.equals(this.message, otherMessage.message) && Objects.equals(this.reasonString, otherMessage.reasonString);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.message, this.reasonString);
        return result;
    }

    @Override
    public HandshakeRejectedMessageImpl clone() {
        try {
            return (HandshakeRejectedMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static HandshakeRejectedMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements HandshakeRejectedMessageBuilder {
        private String message;
        private String reasonString;

        private Builder() {
        }

        @Override
        public HandshakeRejectedMessageBuilder message(String message) {
            Objects.requireNonNull(message, "message is not marked @Nullable");
            this.message = message;
            return this;
        }

        @Override
        public HandshakeRejectedMessageBuilder reasonString(String reasonString) {
            Objects.requireNonNull(reasonString, "reasonString is not marked @Nullable");
            this.reasonString = reasonString;
            return this;
        }

        @Override
        public String message() {
            return this.message;
        }

        @Override
        public String reasonString() {
            return this.reasonString;
        }

        @Override
        public HandshakeRejectedMessage build() {
            return new HandshakeRejectedMessageImpl(Objects.requireNonNull(this.message, "message is not marked @Nullable"), Objects.requireNonNull(this.reasonString, "reasonString is not marked @Nullable"));
        }

        @Override
        public HandshakeRejectedMessage buildDeserialized() {
            return new HandshakeRejectedMessageImpl(this.message, this.reasonString);
        }
    }
}

