/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.recovery.message;

import org.apache.ignite.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite.internal.network.recovery.message.AcknowledgementMessage;
import org.apache.ignite.internal.network.recovery.message.AcknowledgementMessageImpl;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class AcknowledgementMessageSerializer
implements MessageSerializer<AcknowledgementMessage> {
    public static final AcknowledgementMessageSerializer INSTANCE = new AcknowledgementMessageSerializer();

    private AcknowledgementMessageSerializer() {
    }

    @Override
    public boolean writeMessage(AcknowledgementMessage msg, MessageWriter writer) throws MessageMappingException {
        AcknowledgementMessageImpl message = (AcknowledgementMessageImpl)msg;
        writer.setMessageTypeInfo(NetworkMessagesTypeInfos.acknowledgementMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)1)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeLong("receivedMessages", message.receivedMessages());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

