/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.message;

import org.apache.ignite.internal.network.NetworkMessagesTypeInfos;
import org.apache.ignite.internal.network.message.ClassDescriptorListMessage;
import org.apache.ignite.internal.network.message.ClassDescriptorListMessageImpl;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class ClassDescriptorListMessageSerializer
implements MessageSerializer<ClassDescriptorListMessage> {
    public static final ClassDescriptorListMessageSerializer INSTANCE = new ClassDescriptorListMessageSerializer();

    private ClassDescriptorListMessageSerializer() {
    }

    @Override
    public boolean writeMessage(ClassDescriptorListMessage msg, MessageWriter writer) throws MessageMappingException {
        ClassDescriptorListMessageImpl message = (ClassDescriptorListMessageImpl)msg;
        writer.setMessageTypeInfo(NetworkMessagesTypeInfos.classDescriptorListMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)1)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeCollection("messages", message.messages(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

