/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.direct.stream;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.apache.ignite.internal.lang.IgniteUuid;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.direct.stream.DirectByteBufferStream;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.network.serialization.MessageSerializationRegistry;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;
import org.apache.ignite.internal.util.ArrayFactory;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class DirectByteBufferStreamImplV1
implements DirectByteBufferStream {
    private static final Object NULL = new Object();
    protected static final byte BYTE_BUFFER_NOT_NULL_FLAG = 1;
    protected static final byte BYTE_BUFFER_BIG_ENDIAN_FLAG = 2;
    private static final int MAX_VAR_SHORT_BYTES = 3;
    private static final int MAX_VAR_INT_BYTES = 5;
    private static final int MAX_VAR_LONG_BYTES = 10;
    private static final long POSITION_OFF;
    private final MessageSerializationRegistry serializationRegistry;
    protected ByteBuffer buf;
    private int bufLimit;
    protected byte @Nullable [] heapArr;
    protected long baseOff;
    private int arrOff = -1;
    private Object tmpArr;
    private int tmpArrOff;
    private int valReadBytes;
    private int tmpArrBytes;
    private boolean msgGroupTypeRead;
    private short msgGroupType;
    private boolean boxedTypeNotNull;
    @Nullable
    private MessageDeserializer<NetworkMessage> msgDeserializer;
    @Nullable
    private MessageSerializer<NetworkMessage> msgSerializer;
    private Iterator<?> mapIt;
    private Iterator<?> it;
    private int arrPos = -1;
    private Object arrCur = NULL;
    private Object mapCur = NULL;
    private Object cur = NULL;
    private boolean keyDone;
    private int readSize = -1;
    private int readItems;
    private Object[] objArr;
    private Collection<Object> col;
    private Map<Object, Object> map;
    private long prim;
    private int primShift;
    private int uuidState;
    private long uuidMost;
    private long uuidLeast;
    private long uuidLocId;
    private int byteBufferState;
    private byte byteBufferFlag;
    protected boolean lastFinished;
    private byte[] curStrBackingArr;

    public DirectByteBufferStreamImplV1(MessageSerializationRegistry serializationRegistry) {
        this.serializationRegistry = Objects.requireNonNull(serializationRegistry, "serializationRegistry");
    }

    @Override
    public void setBuffer(ByteBuffer buf) {
        assert (buf != null);
        if (this.buf != buf) {
            this.buf = buf;
            this.bufLimit = buf.limit();
            boolean isDirect = buf.isDirect();
            this.heapArr = isDirect ? null : buf.array();
            this.baseOff = isDirect ? GridUnsafe.bufferAddress(buf) : GridUnsafe.BYTE_ARR_OFF + (long)buf.arrayOffset();
        }
    }

    @Override
    public int remaining() {
        return this.remainingInternal();
    }

    private int remainingInternal() {
        return this.bufLimit - this.buf.position();
    }

    @Override
    public boolean lastFinished() {
        return this.lastFinished;
    }

    @Override
    public void writeByte(byte val) {
        boolean bl = this.lastFinished = this.remainingInternal() >= 1;
        if (this.lastFinished) {
            int pos = this.buf.position();
            GridUnsafe.putByte(this.heapArr, this.baseOff + (long)pos, val);
            this.setPosition(pos + 1);
        }
    }

    @Override
    public void writeBoxedByte(@Nullable Byte val) {
        if (val != null) {
            boolean bl = this.lastFinished = this.remainingInternal() >= 2;
            if (this.lastFinished) {
                this.writeBooleanUnchecked(true);
                this.writeByte(val);
            }
        } else {
            this.writeBoolean(false);
        }
    }

    @Override
    public void writeShort(short val) {
        this.lastFinished = this.remainingInternal() >= 3;
        this.writeVarInt(Short.toUnsignedInt((short)(val + 1)));
    }

    @Override
    public void writeBoxedShort(@Nullable Short val) {
        if (val != null) {
            boolean bl = this.lastFinished = this.remainingInternal() >= 4;
            if (this.lastFinished) {
                this.writeBooleanUnchecked(true);
                this.writeShort(val);
            }
        } else {
            this.writeBoolean(false);
        }
    }

    @Override
    public void writeInt(int val) {
        this.lastFinished = this.remainingInternal() >= 5;
        this.writeVarInt(val + 1);
    }

    @Override
    public void writeFixedInt(int val) {
        boolean bl = this.lastFinished = this.remainingInternal() >= 4;
        if (this.lastFinished) {
            int pos = this.buf.position();
            if (GridUnsafe.IS_BIG_ENDIAN) {
                GridUnsafe.putIntLittleEndian(this.heapArr, this.baseOff + (long)pos, val);
            } else {
                GridUnsafe.putInt(this.heapArr, this.baseOff + (long)pos, val);
            }
            this.setPosition(pos += 4);
        }
    }

    @Override
    public void writeFixedLong(long val) {
        boolean bl = this.lastFinished = this.remainingInternal() >= 8;
        if (this.lastFinished) {
            int pos = this.buf.position();
            if (GridUnsafe.IS_BIG_ENDIAN) {
                GridUnsafe.putLongLittleEndian(this.heapArr, this.baseOff + (long)pos, val);
            } else {
                GridUnsafe.putLong(this.heapArr, this.baseOff + (long)pos, val);
            }
            this.setPosition(pos += 8);
        }
    }

    @Override
    public void writeBoxedInt(@Nullable Integer val) {
        if (val != null) {
            boolean bl = this.lastFinished = this.remainingInternal() >= 6;
            if (this.lastFinished) {
                this.writeBooleanUnchecked(true);
                this.writeInt(val);
            }
        } else {
            this.writeBoolean(false);
        }
    }

    @Override
    public void writeLong(long val) {
        this.lastFinished = this.remainingInternal() >= 10;
        this.writeVarLong(val + 1L);
    }

    @Override
    public void writeBoxedLong(@Nullable Long val) {
        if (val != null) {
            boolean bl = this.lastFinished = this.remainingInternal() >= 11;
            if (this.lastFinished) {
                this.writeBooleanUnchecked(true);
                this.writeVarLong(val + 1L);
            }
        } else {
            this.writeBoolean(false);
        }
    }

    private void writeVarLong(long val) {
        if (this.lastFinished) {
            long shift;
            int pos = this.buf.position();
            while ((shift = val >>> 7) != 0L) {
                byte b = (byte)((int)val | 0x80);
                GridUnsafe.putByte(this.heapArr, this.baseOff + (long)pos++, b);
                val = shift;
            }
            GridUnsafe.putByte(this.heapArr, this.baseOff + (long)pos++, (byte)val);
            this.setPosition(pos);
        }
    }

    private void writeVarInt(int val) {
        if (this.lastFinished) {
            int shift;
            int pos = this.buf.position();
            while ((shift = val >>> 7) != 0) {
                byte b = (byte)(val | 0x80);
                GridUnsafe.putByte(this.heapArr, this.baseOff + (long)pos++, b);
                val = shift;
            }
            GridUnsafe.putByte(this.heapArr, this.baseOff + (long)pos++, (byte)val);
            this.setPosition(pos);
        }
    }

    @Override
    public void writeFloat(float val) {
        boolean bl = this.lastFinished = this.remainingInternal() >= 4;
        if (this.lastFinished) {
            int pos = this.buf.position();
            long off = this.baseOff + (long)pos;
            if (GridUnsafe.IS_BIG_ENDIAN) {
                GridUnsafe.putFloatLittleEndian(this.heapArr, off, val);
            } else {
                GridUnsafe.putFloat(this.heapArr, off, val);
            }
            this.setPosition(pos + 4);
        }
    }

    @Override
    public void writeBoxedFloat(@Nullable Float val) {
        if (val != null) {
            boolean bl = this.lastFinished = this.remainingInternal() >= 5;
            if (this.lastFinished) {
                this.writeBooleanUnchecked(true);
                this.writeFloat(val.floatValue());
            }
        } else {
            this.writeBoolean(false);
        }
    }

    @Override
    public void writeDouble(double val) {
        boolean bl = this.lastFinished = this.remainingInternal() >= 8;
        if (this.lastFinished) {
            int pos = this.buf.position();
            long off = this.baseOff + (long)pos;
            if (GridUnsafe.IS_BIG_ENDIAN) {
                GridUnsafe.putDoubleLittleEndian(this.heapArr, off, val);
            } else {
                GridUnsafe.putDouble(this.heapArr, off, val);
            }
            this.setPosition(pos + 8);
        }
    }

    @Override
    public void writeBoxedDouble(@Nullable Double val) {
        if (val != null) {
            boolean bl = this.lastFinished = this.remainingInternal() >= 9;
            if (this.lastFinished) {
                this.writeBooleanUnchecked(true);
                this.writeDouble(val);
            }
        } else {
            this.writeBoolean(false);
        }
    }

    @Override
    public void writeChar(char val) {
        boolean bl = this.lastFinished = this.remainingInternal() >= 2;
        if (this.lastFinished) {
            int pos = this.buf.position();
            long off = this.baseOff + (long)pos;
            if (GridUnsafe.IS_BIG_ENDIAN) {
                GridUnsafe.putCharLittleEndian(this.heapArr, off, val);
            } else {
                GridUnsafe.putChar(this.heapArr, off, val);
            }
            this.setPosition(pos + 2);
        }
    }

    @Override
    public void writeBoxedChar(@Nullable Character val) {
        if (val != null) {
            boolean bl = this.lastFinished = this.remainingInternal() >= 3;
            if (this.lastFinished) {
                this.writeBooleanUnchecked(true);
                this.writeChar(val.charValue());
            }
        } else {
            this.writeBoolean(false);
        }
    }

    @Override
    public void writeBoolean(boolean val) {
        boolean bl = this.lastFinished = this.remainingInternal() >= 1;
        if (this.lastFinished) {
            this.writeBooleanUnchecked(val);
        }
    }

    private void writeBooleanUnchecked(boolean val) {
        int pos = this.buf.position();
        GridUnsafe.putByte(this.heapArr, this.baseOff + (long)pos, (byte)(val ? 1 : 0));
        this.setPosition(pos + 1);
    }

    protected void setPosition(int pos) {
        GridUnsafe.putIntField(this.buf, POSITION_OFF, pos);
    }

    @Override
    public void writeBoxedBoolean(@Nullable Boolean val) {
        if (val != null) {
            boolean bl = this.lastFinished = this.remainingInternal() >= 2;
            if (this.lastFinished) {
                this.writeBooleanUnchecked(true);
                this.writeBoolean(val);
            }
        } else {
            this.writeBoolean(false);
        }
    }

    @Override
    public void writeByteArray(byte[] val) {
        if (val != null) {
            this.lastFinished = this.writeArray(val, GridUnsafe.BYTE_ARR_OFF, val.length, val.length);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeByteArray(byte[] val, long off, int len) {
        if (val != null) {
            this.lastFinished = this.writeArray(val, GridUnsafe.BYTE_ARR_OFF + off, len, len);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeShortArray(short[] val) {
        if (val != null) {
            this.lastFinished = GridUnsafe.IS_BIG_ENDIAN ? this.writeArrayLittleEndian(val, GridUnsafe.SHORT_ARR_OFF, val.length, 2, 1) : this.writeArray(val, GridUnsafe.SHORT_ARR_OFF, val.length, val.length << 1);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeIntArray(int[] val) {
        if (val != null) {
            this.lastFinished = GridUnsafe.IS_BIG_ENDIAN ? this.writeArrayLittleEndian(val, GridUnsafe.INT_ARR_OFF, val.length, 4, 2) : this.writeArray(val, GridUnsafe.INT_ARR_OFF, val.length, val.length << 2);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeLongArray(long[] val) {
        if (val != null) {
            this.lastFinished = GridUnsafe.IS_BIG_ENDIAN ? this.writeArrayLittleEndian(val, GridUnsafe.LONG_ARR_OFF, val.length, 8, 3) : this.writeArray(val, GridUnsafe.LONG_ARR_OFF, val.length, val.length << 3);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeLongArray(long[] val, int len) {
        if (val != null) {
            this.lastFinished = GridUnsafe.IS_BIG_ENDIAN ? this.writeArrayLittleEndian(val, GridUnsafe.LONG_ARR_OFF, len, 8, 3) : this.writeArray(val, GridUnsafe.LONG_ARR_OFF, len, len << 3);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeFloatArray(float[] val) {
        if (val != null) {
            this.lastFinished = GridUnsafe.IS_BIG_ENDIAN ? this.writeArrayLittleEndian(val, GridUnsafe.FLOAT_ARR_OFF, val.length, 4, 2) : this.writeArray(val, GridUnsafe.FLOAT_ARR_OFF, val.length, val.length << 2);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeDoubleArray(double[] val) {
        if (val != null) {
            this.lastFinished = GridUnsafe.IS_BIG_ENDIAN ? this.writeArrayLittleEndian(val, GridUnsafe.DOUBLE_ARR_OFF, val.length, 8, 3) : this.writeArray(val, GridUnsafe.DOUBLE_ARR_OFF, val.length, val.length << 3);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeCharArray(char[] val) {
        if (val != null) {
            this.lastFinished = GridUnsafe.IS_BIG_ENDIAN ? this.writeArrayLittleEndian(val, GridUnsafe.CHAR_ARR_OFF, val.length, 2, 1) : this.writeArray(val, GridUnsafe.CHAR_ARR_OFF, val.length, val.length << 1);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeBooleanArray(boolean[] val) {
        if (val != null) {
            this.lastFinished = this.writeArray(val, GridUnsafe.BOOLEAN_ARR_OFF, val.length, val.length);
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public void writeString(String val) {
        if (val != null) {
            if (this.curStrBackingArr == null) {
                this.curStrBackingArr = val.getBytes(StandardCharsets.UTF_8);
            }
            this.writeByteArray(this.curStrBackingArr);
            if (this.lastFinished) {
                this.curStrBackingArr = null;
            }
        } else {
            this.writeByteArray(null);
        }
    }

    @Override
    public void writeBitSet(BitSet val) {
        this.writeLongArray(val != null ? val.toLongArray() : null);
    }

    @Override
    public void writeByteBuffer(ByteBuffer val) {
        switch (this.byteBufferState) {
            case 0: {
                byte flag = 0;
                if (val != null) {
                    flag = (byte)(flag | 1);
                    if (val.order() == ByteOrder.BIG_ENDIAN) {
                        flag = (byte)(flag | 2);
                    }
                }
                this.writeByte(flag);
                if (!this.lastFinished || val == null) {
                    return;
                }
                ++this.byteBufferState;
            }
            case 1: {
                assert (!val.isReadOnly());
                int position = val.position();
                int length = val.limit() - position;
                this.lastFinished = val.isDirect() ? this.writeArray(null, GridUnsafe.bufferAddress(val) + (long)position, length, length) : this.writeArray(val.array(), GridUnsafe.BYTE_ARR_OFF + (long)val.arrayOffset() + (long)position, length, length);
                if (!this.lastFinished) {
                    return;
                }
                this.byteBufferState = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown byteBufferState: " + this.byteBufferState);
            }
        }
    }

    @Override
    public void writeUuid(UUID val) {
        if (val == null) {
            this.writeBoolean(true);
        } else {
            boolean bl = this.lastFinished = this.remainingInternal() >= 17;
            if (this.lastFinished) {
                int pos = this.buf.position();
                GridUnsafe.putBoolean(this.heapArr, this.baseOff + (long)pos, false);
                GridUnsafe.putLongLittleEndian(this.heapArr, this.baseOff + (long)pos + 1L, val.getMostSignificantBits());
                GridUnsafe.putLongLittleEndian(this.heapArr, this.baseOff + (long)pos + 9L, val.getLeastSignificantBits());
                this.setPosition(pos + 1 + 16);
            }
        }
    }

    @Override
    public void writeIgniteUuid(IgniteUuid val) {
        switch (this.uuidState) {
            case 0: {
                this.writeBoolean(val == null);
                if (!this.lastFinished || val == null) {
                    return;
                }
                ++this.uuidState;
            }
            case 1: {
                this.writeLong(val.globalId().getMostSignificantBits());
                if (!this.lastFinished) {
                    return;
                }
                ++this.uuidState;
            }
            case 2: {
                this.writeLong(val.globalId().getLeastSignificantBits());
                if (!this.lastFinished) {
                    return;
                }
                ++this.uuidState;
            }
            case 3: {
                this.writeLong(val.localId());
                if (!this.lastFinished) {
                    return;
                }
                this.uuidState = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown uuidState: " + this.uuidState);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeMessage(NetworkMessage msg, MessageWriter writer) {
        if (msg != null) {
            if (this.buf.hasRemaining()) {
                try {
                    writer.beforeInnerMessageWrite();
                    writer.setCurrentWriteClass(msg.getClass());
                    if (this.msgSerializer == null) {
                        this.msgSerializer = msg.serializer();
                    }
                    writer.setBuffer(this.buf);
                    this.lastFinished = this.msgSerializer.writeMessage(msg, writer);
                    if (!this.lastFinished) return;
                    this.msgSerializer = null;
                    return;
                }
                finally {
                    writer.afterInnerMessageWrite(this.lastFinished);
                }
            } else {
                this.lastFinished = false;
            }
            return;
        } else {
            this.writeShort((short)-1);
        }
    }

    @Override
    public <T> void writeObjectArray(T[] arr, MessageCollectionItemType itemType, MessageWriter writer) {
        if (arr != null) {
            int len = arr.length;
            if (this.arrPos == -1) {
                this.writeInt(len);
                if (!this.lastFinished) {
                    return;
                }
                this.arrPos = 0;
            }
            while (this.arrPos < len || this.arrCur != NULL) {
                if (this.arrCur == NULL) {
                    this.arrCur = arr[this.arrPos++];
                }
                this.write(itemType, this.arrCur, writer);
                if (!this.lastFinished) {
                    return;
                }
                this.arrCur = NULL;
            }
            this.arrPos = -1;
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public <T> void writeCollection(Collection<T> col, MessageCollectionItemType itemType, MessageWriter writer) {
        if (col != null) {
            if (col instanceof List && col instanceof RandomAccess) {
                this.writeRandomAccessList((List)col, itemType, writer);
            } else {
                if (this.it == null) {
                    this.writeInt(col.size());
                    if (!this.lastFinished) {
                        return;
                    }
                    this.it = col.iterator();
                }
                while (this.it.hasNext() || this.cur != NULL) {
                    if (this.cur == NULL) {
                        this.cur = this.it.next();
                    }
                    this.write(itemType, this.cur, writer);
                    if (!this.lastFinished) {
                        return;
                    }
                    this.cur = NULL;
                }
                this.it = null;
            }
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public <T> void writeSet(Set<T> set, MessageCollectionItemType itemType, MessageWriter writer) {
        this.writeCollection(set, itemType, writer);
    }

    private <T> void writeRandomAccessList(List<T> list, MessageCollectionItemType itemType, MessageWriter writer) {
        assert (list instanceof RandomAccess);
        int size = list.size();
        if (this.arrPos == -1) {
            this.writeInt(size);
            if (!this.lastFinished) {
                return;
            }
            this.arrPos = 0;
        }
        while (this.arrPos < size || this.arrCur != NULL) {
            if (this.arrCur == NULL) {
                this.arrCur = list.get(this.arrPos++);
            }
            this.write(itemType, this.arrCur, writer);
            if (!this.lastFinished) {
                return;
            }
            this.arrCur = NULL;
        }
        this.arrPos = -1;
    }

    @Override
    public <K, V> void writeMap(Map<K, V> map, MessageCollectionItemType keyType, MessageCollectionItemType valType, MessageWriter writer) {
        if (map != null) {
            if (this.mapIt == null) {
                this.writeInt(map.size());
                if (!this.lastFinished) {
                    return;
                }
                this.mapIt = map.entrySet().iterator();
            }
            while (this.mapIt.hasNext() || this.mapCur != NULL) {
                if (this.mapCur == NULL) {
                    this.mapCur = this.mapIt.next();
                }
                Map.Entry e = (Map.Entry)this.mapCur;
                if (!this.keyDone) {
                    this.write(keyType, e.getKey(), writer);
                    if (!this.lastFinished) {
                        return;
                    }
                    this.keyDone = true;
                }
                this.write(valType, e.getValue(), writer);
                if (!this.lastFinished) {
                    return;
                }
                this.mapCur = NULL;
                this.keyDone = false;
            }
            this.mapIt = null;
        } else {
            this.writeInt(-1);
        }
    }

    @Override
    public byte readByte() {
        boolean bl = this.lastFinished = this.remainingInternal() >= 1;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.setPosition(pos + 1);
            return GridUnsafe.getByte(this.heapArr, this.baseOff + (long)pos);
        }
        return 0;
    }

    @Override
    @Nullable
    public Byte readBoxedByte() {
        return this.readBoxedValue(this::readByte);
    }

    @Nullable
    private <T> T readBoxedValue(Supplier<T> valueReader) {
        if (this.boxedTypeNotNull || this.readBoolean()) {
            this.boxedTypeNotNull = true;
            T result = valueReader.get();
            if (this.lastFinished) {
                this.boxedTypeNotNull = false;
            }
            return result;
        }
        return null;
    }

    @Override
    public short readShort() {
        this.lastFinished = false;
        short val = 0;
        int pos = this.buf.position();
        int limit = this.buf.limit();
        while (pos < limit) {
            byte b = GridUnsafe.getByte(this.heapArr, this.baseOff + (long)pos);
            ++pos;
            this.prim |= ((long)b & 0x7FL) << 7 * this.primShift;
            if ((b & 0x80) == 0) {
                this.lastFinished = true;
                val = (short)(this.prim - 1L);
                this.prim = 0L;
                this.primShift = 0;
                break;
            }
            ++this.primShift;
        }
        this.setPosition(pos);
        return val;
    }

    @Override
    @Nullable
    public Short readBoxedShort() {
        return this.readBoxedValue(this::readShort);
    }

    @Override
    public int readInt() {
        this.lastFinished = false;
        int val = 0;
        int pos = this.buf.position();
        int limit = this.buf.limit();
        while (pos < limit) {
            byte b = GridUnsafe.getByte(this.heapArr, this.baseOff + (long)pos);
            ++pos;
            this.prim |= ((long)b & 0x7FL) << 7 * this.primShift;
            if ((b & 0x80) == 0) {
                this.lastFinished = true;
                val = (int)this.prim - 1;
                this.prim = 0L;
                this.primShift = 0;
                break;
            }
            ++this.primShift;
        }
        this.setPosition(pos);
        return val;
    }

    @Override
    public int readFixedInt() {
        this.lastFinished = this.remainingInternal() >= 4;
        int val = 0;
        if (this.lastFinished) {
            int pos = this.buf.position();
            val = GridUnsafe.getInt(this.heapArr, this.baseOff + (long)pos);
            this.setPosition(pos + 4);
        }
        return val;
    }

    @Override
    public long readFixedLong() {
        this.lastFinished = this.remainingInternal() >= 8;
        long val = 0L;
        if (this.lastFinished) {
            int pos = this.buf.position();
            val = GridUnsafe.getLong(this.heapArr, this.baseOff + (long)pos);
            this.setPosition(pos + 8);
        }
        return val;
    }

    @Override
    @Nullable
    public Integer readBoxedInt() {
        return this.readBoxedValue(this::readInt);
    }

    @Override
    public long readLong() {
        this.lastFinished = false;
        long val = 0L;
        int pos = this.buf.position();
        int limit = this.buf.limit();
        while (pos < limit) {
            byte b = GridUnsafe.getByte(this.heapArr, this.baseOff + (long)pos);
            ++pos;
            this.prim |= ((long)b & 0x7FL) << 7 * this.primShift;
            if ((b & 0x80) == 0) {
                this.lastFinished = true;
                val = this.prim - 1L;
                this.prim = 0L;
                this.primShift = 0;
                break;
            }
            ++this.primShift;
        }
        this.setPosition(pos);
        return val;
    }

    @Override
    @Nullable
    public Long readBoxedLong() {
        return this.readBoxedValue(this::readLong);
    }

    @Override
    public float readFloat() {
        boolean bl = this.lastFinished = this.remainingInternal() >= 4;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.setPosition(pos + 4);
            long off = this.baseOff + (long)pos;
            return GridUnsafe.IS_BIG_ENDIAN ? GridUnsafe.getFloatLittleEndian(this.heapArr, off) : GridUnsafe.getFloat(this.heapArr, off);
        }
        return 0.0f;
    }

    @Override
    @Nullable
    public Float readBoxedFloat() {
        return this.readBoxedValue(this::readFloat);
    }

    @Override
    public double readDouble() {
        boolean bl = this.lastFinished = this.remainingInternal() >= 8;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.setPosition(pos + 8);
            long off = this.baseOff + (long)pos;
            return GridUnsafe.IS_BIG_ENDIAN ? GridUnsafe.getDoubleLittleEndian(this.heapArr, off) : GridUnsafe.getDouble(this.heapArr, off);
        }
        return 0.0;
    }

    @Override
    @Nullable
    public Double readBoxedDouble() {
        return this.readBoxedValue(this::readDouble);
    }

    @Override
    public char readChar() {
        boolean bl = this.lastFinished = this.remainingInternal() >= 2;
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.setPosition(pos + 2);
            long off = this.baseOff + (long)pos;
            return GridUnsafe.IS_BIG_ENDIAN ? GridUnsafe.getCharLittleEndian(this.heapArr, off) : GridUnsafe.getChar(this.heapArr, off);
        }
        return '\u0000';
    }

    @Override
    @Nullable
    public Character readBoxedChar() {
        return this.readBoxedValue(this::readChar);
    }

    @Override
    public boolean readBoolean() {
        this.lastFinished = this.buf.hasRemaining();
        if (this.lastFinished) {
            int pos = this.buf.position();
            this.setPosition(pos + 1);
            return GridUnsafe.getBoolean(this.heapArr, this.baseOff + (long)pos);
        }
        return false;
    }

    @Override
    @Nullable
    public Boolean readBoxedBoolean() {
        return this.readBoxedValue(this::readBoolean);
    }

    @Override
    public byte[] readByteArray() {
        return this.readArray(ArrayUtils.BYTE_ARRAY, 0, GridUnsafe.BYTE_ARR_OFF);
    }

    @Override
    public short[] readShortArray() {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            return this.readArrayLittleEndian(ArrayUtils.SHORT_ARRAY, 2, 1, GridUnsafe.SHORT_ARR_OFF);
        }
        return this.readArray(ArrayUtils.SHORT_ARRAY, 1, GridUnsafe.SHORT_ARR_OFF);
    }

    @Override
    public int[] readIntArray() {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            return this.readArrayLittleEndian(ArrayUtils.INT_ARRAY, 4, 2, GridUnsafe.INT_ARR_OFF);
        }
        return this.readArray(ArrayUtils.INT_ARRAY, 2, GridUnsafe.INT_ARR_OFF);
    }

    @Override
    public long[] readLongArray() {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            return this.readArrayLittleEndian(ArrayUtils.LONG_ARRAY, 8, 3, GridUnsafe.LONG_ARR_OFF);
        }
        return this.readArray(ArrayUtils.LONG_ARRAY, 3, GridUnsafe.LONG_ARR_OFF);
    }

    @Override
    public float[] readFloatArray() {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            return this.readArrayLittleEndian(ArrayUtils.FLOAT_ARRAY, 4, 2, GridUnsafe.FLOAT_ARR_OFF);
        }
        return this.readArray(ArrayUtils.FLOAT_ARRAY, 2, GridUnsafe.FLOAT_ARR_OFF);
    }

    @Override
    public double[] readDoubleArray() {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            return this.readArrayLittleEndian(ArrayUtils.DOUBLE_ARRAY, 8, 3, GridUnsafe.DOUBLE_ARR_OFF);
        }
        return this.readArray(ArrayUtils.DOUBLE_ARRAY, 3, GridUnsafe.DOUBLE_ARR_OFF);
    }

    @Override
    public char[] readCharArray() {
        if (GridUnsafe.IS_BIG_ENDIAN) {
            return this.readArrayLittleEndian(ArrayUtils.CHAR_ARRAY, 2, 1, GridUnsafe.CHAR_ARR_OFF);
        }
        return this.readArray(ArrayUtils.CHAR_ARRAY, 1, GridUnsafe.CHAR_ARR_OFF);
    }

    @Override
    public boolean[] readBooleanArray() {
        return this.readArray(ArrayUtils.BOOLEAN_ARRAY, 0, GridUnsafe.BOOLEAN_ARR_OFF);
    }

    @Override
    public String readString() {
        byte[] arr = this.readByteArray();
        return arr != null ? new String(arr, StandardCharsets.UTF_8) : null;
    }

    @Override
    public BitSet readBitSet() {
        long[] arr = this.readLongArray();
        return arr != null ? BitSet.valueOf(arr) : null;
    }

    @Override
    public ByteBuffer readByteBuffer() {
        byte[] bytes;
        switch (this.byteBufferState) {
            case 0: {
                boolean isNull;
                this.byteBufferFlag = this.readByte();
                boolean bl = isNull = (this.byteBufferFlag & 1) == 0;
                if (!this.lastFinished || isNull) {
                    return null;
                }
                ++this.byteBufferState;
            }
            case 1: {
                bytes = this.readByteArray();
                if (!this.lastFinished) {
                    return null;
                }
                this.byteBufferState = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown byteBufferState: " + this.byteBufferState);
            }
        }
        ByteBuffer val = ByteBuffer.wrap(bytes);
        if ((this.byteBufferFlag & 2) == 0) {
            val.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            val.order(ByteOrder.BIG_ENDIAN);
        }
        return val;
    }

    @Override
    public UUID readUuid() {
        switch (this.uuidState) {
            case 0: {
                boolean isNull = this.readBoolean();
                if (!this.lastFinished || isNull) {
                    return null;
                }
                ++this.uuidState;
            }
            case 1: {
                boolean bl = this.lastFinished = this.remainingInternal() >= 16;
                if (!this.lastFinished) break;
                int pos = this.buf.position();
                long msb = GridUnsafe.getLongLittleEndian(this.heapArr, this.baseOff + (long)pos);
                long lsb = GridUnsafe.getLongLittleEndian(this.heapArr, this.baseOff + (long)pos + 8L);
                this.setPosition(pos + 16);
                this.uuidState = 0;
                return new UUID(msb, lsb);
            }
            default: {
                throw new IllegalArgumentException("Unknown uuidState: " + this.uuidState);
            }
        }
        return null;
    }

    @Override
    public IgniteUuid readIgniteUuid() {
        switch (this.uuidState) {
            case 0: {
                boolean isNull = this.readBoolean();
                if (!this.lastFinished || isNull) {
                    return null;
                }
                ++this.uuidState;
            }
            case 1: {
                this.uuidMost = this.readLong();
                if (!this.lastFinished) {
                    return null;
                }
                ++this.uuidState;
            }
            case 2: {
                this.uuidLeast = this.readLong();
                if (!this.lastFinished) {
                    return null;
                }
                ++this.uuidState;
            }
            case 3: {
                this.uuidLocId = this.readLong();
                if (!this.lastFinished) {
                    return null;
                }
                this.uuidState = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown uuidState: " + this.uuidState);
            }
        }
        IgniteUuid val = new IgniteUuid(new UUID(this.uuidMost, this.uuidLeast), this.uuidLocId);
        this.uuidMost = 0L;
        this.uuidLeast = 0L;
        this.uuidLocId = 0L;
        return val;
    }

    @Override
    @Nullable
    public <T extends NetworkMessage> T readMessage(MessageReader reader) {
        if (this.msgDeserializer == null) {
            if (!this.msgGroupTypeRead) {
                this.msgGroupType = this.readShort();
                if (!this.lastFinished) {
                    return null;
                }
                if (this.msgGroupType == -1) {
                    return null;
                }
                this.msgGroupTypeRead = true;
            }
            short msgType = this.readShort();
            if (!this.lastFinished) {
                return null;
            }
            this.msgDeserializer = this.serializationRegistry.createDeserializer(this.msgGroupType, msgType);
        }
        reader.beforeInnerMessageRead();
        try {
            reader.setCurrentReadClass(this.msgDeserializer.klass());
            reader.setBuffer(this.buf);
            this.lastFinished = this.msgDeserializer.readMessage(reader);
        }
        finally {
            reader.afterInnerMessageRead(this.lastFinished);
        }
        if (this.lastFinished) {
            NetworkMessage result = this.msgDeserializer.getMessage();
            this.msgGroupTypeRead = false;
            this.msgDeserializer = null;
            return (T)result;
        }
        return null;
    }

    @Override
    public <T> T[] readObjectArray(MessageCollectionItemType itemType, Class<T> itemCls, MessageReader reader) {
        if (this.readSize == -1) {
            int size = this.readInt();
            if (!this.lastFinished) {
                return null;
            }
            this.readSize = size;
        }
        if (this.readSize >= 0) {
            if (this.objArr == null) {
                this.objArr = itemCls != null ? (Object[])Array.newInstance(itemCls, this.readSize) : new Object[this.readSize];
            }
            for (int i = this.readItems; i < this.readSize; ++i) {
                Object item = this.read(itemType, reader);
                if (!this.lastFinished) {
                    return null;
                }
                this.objArr[i] = item;
                ++this.readItems;
            }
        }
        this.readSize = -1;
        this.readItems = 0;
        this.cur = null;
        Object[] objArr0 = this.objArr;
        this.objArr = null;
        return objArr0;
    }

    @Override
    public <C extends Collection<?>> C readCollection(MessageCollectionItemType itemType, MessageReader reader) {
        return (C)this.readCollection0(itemType, reader, ArrayList::new);
    }

    @Override
    public <C extends Set<?>> C readSet(MessageCollectionItemType itemType, MessageReader reader) {
        return (C)((Set)this.readCollection0(itemType, reader, HashSet::new));
    }

    @Nullable
    private Collection<?> readCollection0(MessageCollectionItemType itemType, MessageReader reader, IntFunction<Collection<Object>> ctor) {
        if (this.readSize == -1) {
            int size = this.readInt();
            if (!this.lastFinished) {
                return null;
            }
            this.readSize = size;
        }
        if (this.readSize >= 0) {
            if (this.col == null) {
                this.col = ctor.apply(this.readSize);
            }
            for (int i = this.readItems; i < this.readSize; ++i) {
                Object item = this.read(itemType, reader);
                if (!this.lastFinished) {
                    return null;
                }
                this.col.add(item);
                ++this.readItems;
            }
        }
        this.readSize = -1;
        this.readItems = 0;
        this.cur = null;
        Collection<Object> col0 = this.col;
        this.col = null;
        return col0;
    }

    @Override
    public <M extends Map<?, ?>> M readMap(MessageCollectionItemType keyType, MessageCollectionItemType valType, boolean linked, MessageReader reader) {
        if (this.readSize == -1) {
            int size = this.readInt();
            if (!this.lastFinished) {
                return null;
            }
            this.readSize = size;
        }
        if (this.readSize >= 0) {
            if (this.map == null) {
                this.map = linked ? IgniteUtils.newLinkedHashMap(this.readSize) : IgniteUtils.newHashMap(this.readSize);
            }
            for (int i = this.readItems; i < this.readSize; ++i) {
                if (!this.keyDone) {
                    Object key = this.read(keyType, reader);
                    if (!this.lastFinished) {
                        return null;
                    }
                    this.mapCur = key;
                    this.keyDone = true;
                }
                Object val = this.read(valType, reader);
                if (!this.lastFinished) {
                    return null;
                }
                this.map.put(this.mapCur, val);
                this.keyDone = false;
                ++this.readItems;
            }
        }
        this.readSize = -1;
        this.readItems = 0;
        this.mapCur = null;
        Map<Object, Object> map0 = this.map;
        this.map = null;
        return (M)map0;
    }

    boolean writeArray(@Nullable Object arr, long off, int len, int bytes) {
        assert (arr == null || arr.getClass().isArray() && arr.getClass().getComponentType().isPrimitive());
        assert (off > 0L);
        assert (len >= 0);
        assert (bytes >= 0);
        assert (bytes >= this.arrOff);
        if (this.writeArrayLength(len)) {
            return false;
        }
        int toWrite = bytes - this.arrOff;
        int pos = this.buf.position();
        int remaining = this.remainingInternal();
        if (toWrite <= remaining) {
            if (toWrite > 0) {
                GridUnsafe.copyMemory(arr, off + (long)this.arrOff, this.heapArr, this.baseOff + (long)pos, toWrite);
                this.setPosition(pos + toWrite);
            }
            this.arrOff = -1;
            return true;
        }
        if (remaining > 0) {
            GridUnsafe.copyMemory(arr, off + (long)this.arrOff, this.heapArr, this.baseOff + (long)pos, remaining);
            this.setPosition(pos + remaining);
            this.arrOff += remaining;
        }
        return false;
    }

    boolean writeArrayLittleEndian(Object arr, long off, int len, int typeSize, int shiftCnt) {
        assert (arr != null);
        assert (arr.getClass().isArray() && arr.getClass().getComponentType().isPrimitive());
        assert (off > 0L);
        assert (len >= 0);
        int bytes = len << shiftCnt;
        assert (bytes >= this.arrOff);
        if (this.writeArrayLength(len)) {
            return false;
        }
        int toWrite = bytes - this.arrOff >> shiftCnt;
        int remaining = this.remainingInternal() >> shiftCnt;
        if (toWrite <= remaining) {
            this.writeArrayLittleEndian(arr, off, toWrite, typeSize);
            this.arrOff = -1;
            return true;
        }
        if (remaining > 0) {
            this.writeArrayLittleEndian(arr, off, remaining, typeSize);
        }
        return false;
    }

    private void writeArrayLittleEndian(Object arr, long off, int len, int typeSize) {
        int pos = this.buf.position();
        for (int i = 0; i < len; ++i) {
            for (int j = 0; j < typeSize; ++j) {
                byte b = GridUnsafe.getByteField(arr, off + (long)this.arrOff + (long)(typeSize - j - 1));
                GridUnsafe.putByte(this.heapArr, this.baseOff + (long)pos++, b);
            }
            this.setPosition(pos);
            this.arrOff += typeSize;
        }
    }

    private boolean writeArrayLength(int len) {
        if (this.arrOff == -1) {
            this.writeInt(len);
            if (!this.lastFinished) {
                return true;
            }
            this.arrOff = 0;
        }
        return false;
    }

    <T> T readArray(ArrayFactory<T> creator, int lenShift, long off) {
        assert (creator != null);
        if (this.tmpArr == null) {
            int len = this.readInt();
            if (!this.lastFinished) {
                return null;
            }
            switch (len) {
                case -1: {
                    this.lastFinished = true;
                    return null;
                }
                case 0: {
                    this.lastFinished = true;
                    return creator.of(0);
                }
            }
            this.tmpArr = creator.of(len);
            this.tmpArrBytes = len << lenShift;
        }
        int toRead = this.tmpArrBytes - this.tmpArrOff;
        int remaining = this.remainingInternal();
        int pos = this.buf.position();
        boolean bl = this.lastFinished = toRead <= remaining;
        if (this.lastFinished) {
            GridUnsafe.copyMemory(this.heapArr, this.baseOff + (long)pos, this.tmpArr, off + (long)this.tmpArrOff, toRead);
            this.setPosition(pos + toRead);
            Object arr = this.tmpArr;
            this.tmpArr = null;
            this.tmpArrBytes = 0;
            this.tmpArrOff = 0;
            return (T)arr;
        }
        GridUnsafe.copyMemory(this.heapArr, this.baseOff + (long)pos, this.tmpArr, off + (long)this.tmpArrOff, remaining);
        this.setPosition(pos + remaining);
        this.tmpArrOff += remaining;
        return null;
    }

    <T> T readArrayLittleEndian(ArrayFactory<T> creator, int typeSize, int lenShift, long off) {
        int remaining;
        int toRead;
        assert (creator != null);
        if (this.tmpArr == null) {
            int len = this.readInt();
            if (!this.lastFinished) {
                return null;
            }
            switch (len) {
                case -1: {
                    this.lastFinished = true;
                    return null;
                }
                case 0: {
                    this.lastFinished = true;
                    return creator.of(0);
                }
            }
            this.tmpArr = creator.of(len);
            this.tmpArrBytes = len << lenShift;
        }
        boolean bl = this.lastFinished = (toRead = this.tmpArrBytes - this.tmpArrOff - this.valReadBytes) <= (remaining = this.remainingInternal());
        if (!this.lastFinished) {
            toRead = remaining;
        }
        int pos = this.buf.position();
        for (int i = 0; i < toRead; ++i) {
            byte b = GridUnsafe.getByte(this.heapArr, this.baseOff + (long)pos + (long)i);
            GridUnsafe.putByteField(this.tmpArr, off + (long)this.tmpArrOff + (long)(typeSize - this.valReadBytes - 1), b);
            if (++this.valReadBytes != typeSize) continue;
            this.valReadBytes = 0;
            this.tmpArrOff += typeSize;
        }
        this.setPosition(pos + toRead);
        if (this.lastFinished) {
            Object arr = this.tmpArr;
            this.tmpArr = null;
            this.tmpArrBytes = 0;
            this.tmpArrOff = 0;
            return (T)arr;
        }
        return null;
    }

    protected void write(MessageCollectionItemType type, Object val, MessageWriter writer) {
        switch (type) {
            case BYTE: {
                this.writeByte((Byte)val);
                break;
            }
            case SHORT: {
                this.writeShort((Short)val);
                break;
            }
            case INT: {
                this.writeInt((Integer)val);
                break;
            }
            case LONG: {
                this.writeLong((Long)val);
                break;
            }
            case FLOAT: {
                this.writeFloat(((Float)val).floatValue());
                break;
            }
            case DOUBLE: {
                this.writeDouble((Double)val);
                break;
            }
            case CHAR: {
                this.writeChar(((Character)val).charValue());
                break;
            }
            case BOOLEAN: {
                this.writeBoolean((Boolean)val);
                break;
            }
            case BYTE_ARR: {
                this.writeByteArray((byte[])val);
                break;
            }
            case SHORT_ARR: {
                this.writeShortArray((short[])val);
                break;
            }
            case INT_ARR: {
                this.writeIntArray((int[])val);
                break;
            }
            case LONG_ARR: {
                this.writeLongArray((long[])val);
                break;
            }
            case FLOAT_ARR: {
                this.writeFloatArray((float[])val);
                break;
            }
            case DOUBLE_ARR: {
                this.writeDoubleArray((double[])val);
                break;
            }
            case CHAR_ARR: {
                this.writeCharArray((char[])val);
                break;
            }
            case BOOLEAN_ARR: {
                this.writeBooleanArray((boolean[])val);
                break;
            }
            case STRING: {
                this.writeString((String)val);
                break;
            }
            case BIT_SET: {
                this.writeBitSet((BitSet)val);
                break;
            }
            case BYTE_BUFFER: {
                this.writeByteBuffer((ByteBuffer)val);
                break;
            }
            case UUID: {
                this.writeUuid((UUID)val);
                break;
            }
            case IGNITE_UUID: {
                this.writeIgniteUuid((IgniteUuid)val);
                break;
            }
            case MSG: {
                this.writeMessage((NetworkMessage)val, writer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
        }
    }

    protected Object read(MessageCollectionItemType type, MessageReader reader) {
        switch (type) {
            case BYTE: {
                return this.readByte();
            }
            case SHORT: {
                return this.readShort();
            }
            case INT: {
                return this.readInt();
            }
            case LONG: {
                return this.readLong();
            }
            case FLOAT: {
                return Float.valueOf(this.readFloat());
            }
            case DOUBLE: {
                return this.readDouble();
            }
            case CHAR: {
                return Character.valueOf(this.readChar());
            }
            case BOOLEAN: {
                return this.readBoolean();
            }
            case BYTE_ARR: {
                return this.readByteArray();
            }
            case SHORT_ARR: {
                return this.readShortArray();
            }
            case INT_ARR: {
                return this.readIntArray();
            }
            case LONG_ARR: {
                return this.readLongArray();
            }
            case FLOAT_ARR: {
                return this.readFloatArray();
            }
            case DOUBLE_ARR: {
                return this.readDoubleArray();
            }
            case CHAR_ARR: {
                return this.readCharArray();
            }
            case BOOLEAN_ARR: {
                return this.readBooleanArray();
            }
            case STRING: {
                return this.readString();
            }
            case BIT_SET: {
                return this.readBitSet();
            }
            case BYTE_BUFFER: {
                return this.readByteBuffer();
            }
            case UUID: {
                return this.readUuid();
            }
            case IGNITE_UUID: {
                return this.readIgniteUuid();
            }
            case MSG: {
                return this.readMessage(reader);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    static {
        try {
            Field position = Buffer.class.getDeclaredField("position");
            AccessController.doPrivileged(() -> {
                position.setAccessible(true);
                return null;
            });
            POSITION_OFF = GridUnsafe.objectFieldOffset(position);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

