/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.stream.Stream;
import org.apache.ignite.internal.network.ChannelType;
import org.apache.ignite.internal.network.CriticalStripedThreadPoolExecutorFactory;
import org.apache.ignite.internal.network.StripedExecutorByChannelTypeId;
import org.apache.ignite.internal.thread.StripedExecutor;
import org.apache.ignite.internal.util.CollectionUtils;

class MapStripedExecutorByChannelTypeId
implements StripedExecutorByChannelTypeId {
    private final Int2ObjectMap<StripedExecutor> map;

    MapStripedExecutorByChannelTypeId(CriticalStripedThreadPoolExecutorFactory factory, ChannelType ... channelTypes) {
        this.map = Arrays.stream(channelTypes).collect(CollectionUtils.toIntMapCollector(channelType -> channelType.id(), factory::create));
    }

    @Override
    public StripedExecutor get(short channelTypeId) {
        StripedExecutor stripedExecutor = (StripedExecutor)this.map.get(channelTypeId);
        assert (stripedExecutor != null) : "Channel type is not registered: " + channelTypeId;
        return stripedExecutor;
    }

    @Override
    public Stream<StripedExecutor> stream() {
        return this.map.values().stream();
    }
}

