/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.apache.ignite.internal.network.ChannelType;
import org.apache.ignite.internal.network.ChannelTypeRegistry;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;

class MapChannelTypeRegistry
implements ChannelTypeRegistry {
    private final Int2ObjectMap<ChannelType> map;

    MapChannelTypeRegistry(ChannelType ... channelTypes) {
        assert (!ArrayUtils.nullOrEmpty(channelTypes));
        this.map = Arrays.stream(channelTypes).collect(CollectionUtils.toIntMapCollector(channelType -> channelType.id(), Function.identity()));
    }

    @Override
    public ChannelType get(short id) {
        ChannelType channelType = (ChannelType)this.map.get(id);
        assert (channelType != null) : "Channel type is not registered: " + id;
        return channelType;
    }

    @Override
    public Collection<ChannelType> getAll() {
        return Collections.unmodifiableCollection(this.map.values());
    }
}

