/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.network.IgniteMessageServiceThread;
import org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.internal.thread.LogUncaughtExceptionHandler;
import org.apache.ignite.internal.thread.ThreadOperation;

public class IgniteMessageServiceThreadFactory
implements ThreadFactory {
    private final String prefix;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Thread.UncaughtExceptionHandler exceptionHandler;
    private final ThreadOperation[] allowedOperations;

    private IgniteMessageServiceThreadFactory(String prefix, ThreadOperation[] allowedOperations, IgniteLogger log) {
        this.prefix = prefix;
        this.allowedOperations = allowedOperations;
        this.exceptionHandler = new LogUncaughtExceptionHandler(log);
    }

    @Override
    public Thread newThread(Runnable r) {
        IgniteMessageServiceThread t = new IgniteMessageServiceThread(this.prefix + this.counter.getAndIncrement(), r, this.allowedOperations);
        t.setUncaughtExceptionHandler(this.exceptionHandler);
        return t;
    }

    public static IgniteMessageServiceThreadFactory create(String nodeName, String poolName, IgniteLogger logger, ThreadOperation ... allowedOperations) {
        return new IgniteMessageServiceThreadFactory(IgniteThread.threadPrefix(nodeName, poolName), allowedOperations, logger);
    }
}

