/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.util.List;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.network.ChannelType;
import org.apache.ignite.internal.network.IgniteMessageServiceThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.worker.CriticalStripedThreadPoolExecutor;
import org.apache.ignite.internal.worker.CriticalWorker;
import org.apache.ignite.internal.worker.CriticalWorkerRegistry;

class CriticalStripedThreadPoolExecutorFactory {
    private static final int DEFAULT_CHANNEL_INBOUND_WORKERS = 4;
    private final String nodeName;
    private final String poolNamePrefix;
    private final IgniteLogger log;
    private final CriticalWorkerRegistry workerRegistry;
    private final List<CriticalWorker> registeredWorkers;

    CriticalStripedThreadPoolExecutorFactory(String nodeName, String poolNamePrefix, IgniteLogger log, CriticalWorkerRegistry workerRegistry, List<CriticalWorker> registeredWorkers) {
        this.nodeName = nodeName;
        this.poolNamePrefix = poolNamePrefix;
        this.log = log;
        this.workerRegistry = workerRegistry;
        this.registeredWorkers = registeredWorkers;
    }

    CriticalStripedThreadPoolExecutor create(ChannelType channelType) {
        short channelTypeId = channelType.id();
        String poolName = this.poolNamePrefix + "-" + channelType.name() + "-" + channelTypeId;
        IgniteMessageServiceThreadFactory threadFactory = IgniteMessageServiceThreadFactory.create(this.nodeName, poolName, this.log, ThreadOperation.NOTHING_ALLOWED);
        CriticalStripedThreadPoolExecutor executor = new CriticalStripedThreadPoolExecutor(CriticalStripedThreadPoolExecutorFactory.stripeCountForIndex(channelTypeId), threadFactory, false, 0L);
        for (CriticalWorker worker : executor.workers()) {
            this.workerRegistry.register(worker);
            this.registeredWorkers.add(worker);
        }
        return executor;
    }

    private static int stripeCountForIndex(short channelTypeId) {
        return channelTypeId == ChannelType.DEFAULT.id() ? 4 : 1;
    }
}

