/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.network.ChannelTypeRegistry;
import org.apache.ignite.internal.network.CriticalStripedThreadPoolExecutorFactory;
import org.apache.ignite.internal.network.StripedExecutorByChannelTypeId;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.worker.CriticalWorker;
import org.apache.ignite.internal.worker.CriticalWorkerRegistry;

class CriticalStripedExecutors
implements ManuallyCloseable {
    private final CriticalWorkerRegistry workerRegistry;
    private final StripedExecutorByChannelTypeId executorByChannelTypeId;
    private final List<CriticalWorker> registeredWorkers = new CopyOnWriteArrayList<CriticalWorker>();
    private final AtomicBoolean closeGuard = new AtomicBoolean();

    CriticalStripedExecutors(String nodeName, String poolNamePrefix, CriticalWorkerRegistry workerRegistry, ChannelTypeRegistry channelTypeRegistry, IgniteLogger log) {
        this.workerRegistry = workerRegistry;
        CriticalStripedThreadPoolExecutorFactory factory = new CriticalStripedThreadPoolExecutorFactory(nodeName, poolNamePrefix, log, workerRegistry, this.registeredWorkers);
        this.executorByChannelTypeId = StripedExecutorByChannelTypeId.of(channelTypeRegistry, factory);
    }

    @Override
    public void close() throws Exception {
        if (!this.closeGuard.compareAndSet(false, true)) {
            return;
        }
        this.registeredWorkers.forEach(this.workerRegistry::unregister);
        IgniteUtils.closeAll(((Stream)this.executorByChannelTypeId.stream().parallel()).map(executor -> () -> IgniteUtils.shutdownAndAwaitTermination(executor, 10L, TimeUnit.SECONDS)));
    }

    Executor executorFor(short channelTypeId, int stripeIndex) {
        return this.executorByChannelTypeId.get(channelTypeId).stripeExecutor(stripeIndex);
    }
}

