/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.dsl;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.metastorage.dsl.ConditionType;
import org.apache.ignite.internal.metastorage.dsl.MetaStorageMessagesFactory;
import org.apache.ignite.internal.metastorage.dsl.MetaStorageMessagesTypeInfos;
import org.apache.ignite.internal.metastorage.dsl.SimpleCondition;
import org.apache.ignite.internal.metastorage.dsl.SimpleConditionBuilder;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class SimpleConditionDeserializer
implements MessageDeserializer<SimpleCondition> {
    private final SimpleConditionBuilder msg;

    SimpleConditionDeserializer(MetaStorageMessagesFactory messageFactory) {
        this.msg = messageFactory.simpleCondition();
    }

    @Override
    public Class<SimpleCondition> klass() {
        return SimpleCondition.class;
    }

    @Override
    public SimpleCondition getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(MetaStorageMessagesTypeInfos.simpleCondition());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ByteBuffer tmp = reader.readByteBuffer("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.key(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                ConditionType tmp;
                int shiftedId = reader.readInt("type");
                if (!reader.isLastRead()) {
                    return false;
                }
                ConditionType conditionType = tmp = shiftedId == 0 ? null : ConditionType.fromId(shiftedId - 1);
                if (tmp != null) {
                    this.msg.type(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SimpleCondition.class);
    }
}

