/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage;

import org.apache.ignite.internal.metastorage.CommandId;
import org.apache.ignite.internal.metastorage.CommandIdImpl;
import org.apache.ignite.internal.metastorage.dsl.MetaStorageMessagesTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class CommandIdSerializer
implements MessageSerializer<CommandId> {
    public static final CommandIdSerializer INSTANCE = new CommandIdSerializer();

    private CommandIdSerializer() {
    }

    @Override
    public boolean writeMessage(CommandId msg, MessageWriter writer) throws MessageMappingException {
        CommandIdImpl message = (CommandIdImpl)msg;
        writer.setMessageTypeInfo(MetaStorageMessagesTypeInfos.commandId());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeLong("counter", message.counter());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeUuid("nodeId", message.nodeId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

