/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.validation;

import org.apache.ignite.configuration.validation.Range;
import org.apache.ignite.configuration.validation.ValidationContext;
import org.apache.ignite.configuration.validation.ValidationIssue;
import org.apache.ignite.configuration.validation.Validator;

public class RangeValidator
implements Validator<Range, Number> {
    @Override
    public void validate(Range annotation, ValidationContext<Number> ctx) {
        long longValue = ctx.getNewValue().longValue();
        if (longValue < annotation.min()) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Configuration value '" + ctx.currentKey() + "' must not be less than " + annotation.min()));
        }
        if (longValue > annotation.max()) {
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), "Configuration value '" + ctx.currentKey() + "' must not be greater than " + annotation.max()));
        }
    }
}

