/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.notifications;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.apache.ignite.configuration.ConfigurationProperty;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.configuration.notifications.ConfigurationNotificationEvent;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.DynamicProperty;
import org.apache.ignite.internal.configuration.NamedListConfiguration;
import org.apache.ignite.internal.configuration.notifications.ConfigurationNotificationContext;
import org.apache.ignite.internal.configuration.notifications.ConfigurationNotificationUtils;
import org.apache.ignite.internal.configuration.notifications.NamedListChanges;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class ConfigurationNotifier {
    public static Collection<CompletableFuture<?>> notifyListeners(@Nullable InnerNode oldInnerNode, InnerNode newInnerNode, DynamicConfiguration<InnerNode, ?> config, long storageRevision, long notificationNumber) {
        if (oldInnerNode == newInnerNode) {
            return List.of();
        }
        ConfigurationNotificationContext ctx = new ConfigurationNotificationContext(storageRevision, notificationNumber);
        ctx.addContainer(oldInnerNode, newInnerNode, null, null);
        if (oldInnerNode == null) {
            ConfigurationNotifier.notifyListeners(newInnerNode, config, List.of(), ctx);
        } else {
            ConfigurationNotifier.notifyListeners(oldInnerNode, newInnerNode, config, List.of(), ctx);
        }
        ctx.removeContainer();
        return ctx.futures;
    }

    private static void notifyListeners(@Nullable InnerNode oldInnerNode, final InnerNode newInnerNode, final DynamicConfiguration<InnerNode, ?> config, final Iterable<DynamicConfiguration<InnerNode, ?>> anyConfigs, final ConfigurationNotificationContext ctx) {
        assert (!(config instanceof NamedListConfiguration));
        if (oldInnerNode == null || newInnerNode == oldInnerNode) {
            return;
        }
        ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.listeners(config, ctx.notificationNum), CollectionUtils.concat(ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.listeners(anyCfg, ctx.notificationNum))), oldInnerNode.specificNode(), newInnerNode.specificNode(), ctx, ConfigurationListener::onUpdate);
        if (oldInnerNode.schemaType() != newInnerNode.schemaType()) {
            return;
        }
        oldInnerNode.traverseChildren(new ConfigurationVisitor<Void>(){

            @Override
            public Void visitLeafNode(Field field, String key, Serializable oldLeaf) {
                Serializable newLeaf = newInnerNode.traverseChild(key, ConfigurationUtil.leafNodeVisitor(), true);
                if (newLeaf != oldLeaf) {
                    DynamicProperty<Serializable> node = config != null ? ConfigurationNotificationUtils.dynamicProperty(config, key) : null;
                    ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.listeners(node, ctx.notificationNum), CollectionUtils.concat(ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.dynamicProperty(anyCfg, key), ctx2.notificationNum))), oldLeaf, newLeaf, ctx, ConfigurationListener::onUpdate);
                }
                return null;
            }

            @Override
            public Void visitInnerNode(Field field, String key, InnerNode oldNode) {
                InnerNode newNode = newInnerNode.traverseChild(key, ConfigurationUtil.innerNodeVisitor(), true);
                DynamicConfiguration<InnerNode, ?> newConfig = ConfigurationNotificationUtils.dynamicConfig(config, key);
                ctx.addContainer(oldNode, newNode, null, null);
                ConfigurationNotifier.notifyListeners(oldNode, newNode, newConfig, ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.dynamicConfig(anyCfg, key)), ctx);
                ctx.removeContainer();
                return null;
            }

            @Override
            public Void visitNamedListNode(Field field, String key, NamedListNode<?> oldNamedList) {
                NamedListNode<?> newNamedList = newInnerNode.traverseChild(key, ConfigurationUtil.namedListNodeVisitor(), true);
                if (newNamedList != oldNamedList) {
                    InnerNode oldVal;
                    InnerNode newVal;
                    ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.namedDynamicConfig(config, key), ctx.notificationNum), CollectionUtils.concat(ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key), ctx2.notificationNum))), oldNamedList, newNamedList, ctx, ConfigurationListener::onUpdate);
                    NamedListChanges namedListChanges = NamedListChanges.of(oldNamedList, newNamedList);
                    NamedListConfiguration<?, InnerNode, ?> namedListCfg = ConfigurationNotificationUtils.namedDynamicConfig(config, key);
                    Map<String, ConfigurationProperty<?>> namedListCfgMembers = namedListCfg.touchMembers();
                    Iterable<DynamicConfiguration<InnerNode, ?>> newAnyConfigs = null;
                    for (String string : namedListChanges.created) {
                        DynamicConfiguration newNodeCfg = (DynamicConfiguration)namedListCfg.members().get(string);
                        ConfigurationUtil.touch(newNodeCfg);
                        newVal = newNamedList.getInnerNode(string);
                        ctx.addContainer(null, newVal, null, string);
                        ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(config, key), ctx.notificationNum), CollectionUtils.concat(ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key), ctx2.notificationNum))), null, newVal.specificNode(), ctx, ConfigurationNamedListListener::onCreate);
                        if (newAnyConfigs == null) {
                            newAnyConfigs = ConfigurationNotificationUtils.mergeAnyConfigs(ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.any(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key))), ConfigurationNotificationUtils.any(namedListCfg));
                        }
                        ConfigurationNotifier.notifyListeners(newVal, newNodeCfg, newAnyConfigs, ctx);
                        ctx.removeContainer();
                    }
                    for (String string : namedListChanges.deleted) {
                        DynamicConfiguration delNodeCfg = (DynamicConfiguration)namedListCfgMembers.get(string);
                        InnerNode oldVal2 = oldNamedList.getInnerNode(string);
                        ctx.addContainer(oldVal2, null, string, null);
                        ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(config, key), ctx.notificationNum), CollectionUtils.concat(ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key), ctx2.notificationNum))), oldVal2.specificNode(), null, ctx, ConfigurationNamedListListener::onDelete);
                        ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.listeners(delNodeCfg, ctx.notificationNum), CollectionUtils.concat(ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.any(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key)), ctx2.notificationNum))), oldVal2.specificNode(), null, ctx, ConfigurationListener::onUpdate);
                        ctx.removeContainer();
                    }
                    for (Map.Entry entry : namedListChanges.renamed.entrySet()) {
                        oldVal = oldNamedList.getInnerNode((String)entry.getKey());
                        newVal = newNamedList.getInnerNode((String)entry.getValue());
                        ctx.addContainer(oldVal, newVal, (String)entry.getKey(), (String)entry.getValue());
                        ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(config, key), ctx.notificationNum), CollectionUtils.concat(ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key), ctx2.notificationNum))), oldVal.specificNode(), newVal.specificNode(), ctx, (listener, event) -> listener.onRename(event));
                        ctx.removeContainer();
                    }
                    for (String string : namedListChanges.updated) {
                        oldVal = oldNamedList.getInnerNode(string);
                        if (oldVal == (newVal = newNamedList.getInnerNode(string))) continue;
                        DynamicConfiguration updNodeCfg = (DynamicConfiguration)namedListCfgMembers.get(string);
                        ctx.addContainer(oldVal, newVal, string, string);
                        ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(config, key), ctx.notificationNum), CollectionUtils.concat(ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key), ctx2.notificationNum))), oldVal.specificNode(), newVal.specificNode(), ctx, ConfigurationNamedListListener::onUpdate);
                        if (newAnyConfigs == null) {
                            newAnyConfigs = ConfigurationNotificationUtils.mergeAnyConfigs(ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.any(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key))), ConfigurationNotificationUtils.any(namedListCfg));
                        }
                        ConfigurationNotifier.notifyListeners(oldVal, newVal, updNodeCfg, newAnyConfigs, ctx);
                        ctx.removeContainer();
                    }
                }
                return null;
            }
        }, true);
    }

    private static void notifyListeners(InnerNode innerNode, final DynamicConfiguration<InnerNode, ?> config, final Iterable<DynamicConfiguration<InnerNode, ?>> anyConfigs, final ConfigurationNotificationContext ctx) {
        assert (!(config instanceof NamedListConfiguration));
        ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.listeners(config, ctx.notificationNum), CollectionUtils.concat(ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.listeners(anyCfg, ctx.notificationNum))), null, innerNode.specificNode(), ctx, ConfigurationListener::onUpdate);
        innerNode.traverseChildren(new ConfigurationVisitor<Void>(){

            @Override
            public Void visitLeafNode(Field field, String key, Serializable leaf) {
                ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.dynamicProperty(config, key), ctx.notificationNum), CollectionUtils.concat(ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.dynamicProperty(anyCfg, key), ctx2.notificationNum))), null, leaf, ctx, ConfigurationListener::onUpdate);
                return null;
            }

            @Override
            public Void visitInnerNode(Field field, String key, InnerNode nestedInnerNode) {
                DynamicConfiguration<InnerNode, ?> nestedNodeConfig = ConfigurationNotificationUtils.dynamicConfig(config, key);
                ctx.addContainer(null, nestedInnerNode, null, null);
                ConfigurationNotifier.notifyListeners(nestedInnerNode, nestedNodeConfig, ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.dynamicConfig(anyCfg, key)), ctx);
                ctx.removeContainer();
                return null;
            }

            @Override
            public Void visitNamedListNode(Field field, String key, NamedListNode<?> newNamedList) {
                ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.namedDynamicConfig(config, key), ctx.notificationNum), CollectionUtils.concat(ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.listeners(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key), ctx2.notificationNum))), null, newNamedList, ctx, ConfigurationListener::onUpdate);
                Iterable<DynamicConfiguration<InnerNode, ?>> newAnyConfigs = null;
                NamedListConfiguration<?, InnerNode, ?> namedListCfg = ConfigurationNotificationUtils.namedDynamicConfig(config, key);
                namedListCfg.touchMembers();
                for (String name : newNamedList.namedListKeys()) {
                    DynamicConfiguration<?, ?> namedNodeConfig = namedListCfg.getConfig(name);
                    InnerNode namedInnerNode = newNamedList.getInnerNode(name);
                    ctx.addContainer(null, namedInnerNode, null, name);
                    ConfigurationNotifier.notifyPublicListeners(ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(config, key), ctx.notificationNum), CollectionUtils.concat(ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.extendedListeners(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key), ctx2.notificationNum))), null, namedInnerNode.specificNode(), ctx, ConfigurationNamedListListener::onCreate);
                    if (newAnyConfigs == null) {
                        newAnyConfigs = ConfigurationNotificationUtils.mergeAnyConfigs(ConfigurationUtil.mapIterable(anyConfigs, anyCfg -> ConfigurationNotificationUtils.any(ConfigurationNotificationUtils.namedDynamicConfig(anyCfg, key))), ConfigurationNotificationUtils.any(ConfigurationNotificationUtils.namedDynamicConfig(config, key)));
                    }
                    ConfigurationNotifier.notifyListeners(namedInnerNode, namedNodeConfig, newAnyConfigs, ctx);
                    ctx.removeContainer();
                }
                return null;
            }
        }, true);
    }

    private static <L extends ConfigurationListener<?>> void notifyPublicListeners(Iterator<? extends L> configListeners, Iterator<? extends L> anyListeners, @Nullable Object oldValue, @Nullable Object newValue, ConfigurationNotificationContext notificationCtx, BiFunction<L, ConfigurationNotificationEvent, CompletableFuture<?>> invokeListener) {
        ConfigurationNotificationEvent<Object> event = null;
        Iterator it = CollectionUtils.concat(anyListeners, configListeners);
        while (it.hasNext()) {
            if (event == null) {
                event = notificationCtx.createEvent(oldValue, newValue);
            }
            try {
                CompletableFuture<?> future = invokeListener.apply((ConfigurationListener)it.next(), event);
                assert (future != null) : invokeListener;
                if (!future.isCompletedExceptionally() && !future.isCancelled() && future.isDone()) continue;
                notificationCtx.futures.add(future);
            }
            catch (Throwable t) {
                notificationCtx.futures.add(CompletableFuture.failedFuture(t));
            }
        }
    }
}

