/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.asm;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.configuration.ConfigurationWrongPolymorphicTypeIdException;
import org.apache.ignite.configuration.NamedListChange;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.configuration.annotation.AbstractConfiguration;
import org.apache.ignite.configuration.annotation.Name;
import org.apache.ignite.configuration.annotation.PolymorphicConfig;
import org.apache.ignite.configuration.annotation.PolymorphicId;
import org.apache.ignite.internal.configuration.asm.AbstractAsmGenerator;
import org.apache.ignite.internal.configuration.asm.ConfigurationAsmGenerator;
import org.apache.ignite.internal.configuration.asm.SchemaClassesInfo;
import org.apache.ignite.internal.configuration.asm.StringSwitchBuilder;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationVisitor;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

class InnerNodeAsmGenerator
extends AbstractAsmGenerator {
    private static final Method ACCEPT;
    private static final Method VISIT_LEAF;
    private static final Method VISIT_INNER;
    private static final Method VISIT_NAMED;
    private static final Method UNWRAP;
    private static final Method DESCEND;
    private static final Method INTERNAL_ID;
    private static final Method REQUIRE_NON_NULL;
    private static final Method CLASS_GET_NAME_MTD;
    private static final Method STRING_EQUALS_MTD;
    private static final Method POLYMORPHIC_TYPE_ID_MTD;
    private static final Method CONSTRUCT_DEFAULT_MTD;
    private static final Method SPECIFIC_NODE_MTD;
    private static final Method ADD_DEFAULTS_MTD;
    private static final Method SET_INJECTED_NAME_FIELD_VALUE_MTD;
    private static final Method IS_POLYMORPHIC_MTD;
    private static final Method EXTENSION_SCHEMA_TYPES_MTD;
    private static final Method ASSERT_MUTABILITY_MTD;
    private static final Method GET_DECLARED_FIELD_MTD;
    private static final String CONVERT_MTD_NAME = "convert";
    private static final String CONSTRUCT_MTD_NAME = "construct";
    private static final String INJECTED_VALUE_FIELD_NAME_MTD_NAME = "injectedValueFieldName";
    private final Map<Field, FieldDefinition> fieldToFieldDefinitionMap = new HashMap<Field, FieldDefinition>();
    private ClassDefinition innerNodeClassDef;

    InnerNodeAsmGenerator(ConfigurationAsmGenerator cgen, Class<?> schemaClass, Set<Class<?>> extensions, Set<Class<?>> polymorphicExtensions, List<Field> schemaFields, Collection<Field> publicExtensionFields, Collection<Field> internalExtensionFields, Collection<Field> polymorphicFields, @Nullable Field internalIdField) {
        super(cgen, schemaClass, extensions, polymorphicExtensions, schemaFields, publicExtensionFields, internalExtensionFields, polymorphicFields, internalIdField);
    }

    @Override
    public List<ClassDefinition> generate() {
        assert (this.innerNodeClassDef == null);
        ArrayList<ClassDefinition> classDefs = new ArrayList<ClassDefinition>();
        classDefs.add(this.createNodeClass());
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            Collection polymorphicFields = this.polymorphicFields.stream().filter(f -> f.getDeclaringClass() == polymorphicExtension).collect(Collectors.toList());
            classDefs.add(this.createPolymorphicExtensionNodeClass(polymorphicExtension, polymorphicFields));
        }
        return classDefs;
    }

    private ClassDefinition createNodeClass() {
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(this.schemaClass);
        this.innerNodeClassDef = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), ConfigurationAsmGenerator.internalName(schemaClassInfo.nodeClassName), ParameterizedType.type(InnerNode.class), ConfigurationAsmGenerator.nodeClassInterfaces(this.schemaClass, this.extensions));
        HashMap specFields = new HashMap();
        int i = 0;
        for (Class clazz : CollectionUtils.concat(new Collection[]{List.of(this.schemaClass), this.extensions, this.polymorphicExtensions})) {
            specFields.put(clazz, this.innerNodeClassDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "_spec" + i++, clazz));
        }
        HashMap<String, FieldDefinition> fieldDefs = new HashMap<String, FieldDefinition>();
        FieldDefinition polymorphicTypeIdFieldDef = null;
        FieldDefinition injectedNameFieldDef = null;
        Field injectedValueField = null;
        for (Field schemaField : CollectionUtils.concat(new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields, this.polymorphicFields})) {
            FieldDefinition fieldDef = this.addInnerNodeField(schemaField);
            fieldDefs.put(fieldDef.getName(), fieldDef);
            if (ConfigurationUtil.isPolymorphicId(schemaField)) {
                polymorphicTypeIdFieldDef = fieldDef;
                continue;
            }
            if (ConfigurationUtil.isInjectedName(schemaField)) {
                injectedNameFieldDef = fieldDef;
                continue;
            }
            if (!ConfigurationUtil.isInjectedValue(schemaField)) continue;
            injectedValueField = schemaField;
        }
        MethodDefinition classInitializer = this.innerNodeClassDef.getClassInitializer();
        this.fieldToFieldDefinitionMap.forEach((k, v) -> {
            BytecodeExpression getDeclaredFieldExp = BytecodeExpressions.constantClass(k.getDeclaringClass()).invoke(GET_DECLARED_FIELD_MTD, BytecodeExpressions.constantString(k.getName()));
            classInitializer.getBody().append(BytecodeExpressions.setStatic(v, getDeclaredFieldExp));
        });
        this.addNodeSchemaTypeMethod(polymorphicTypeIdFieldDef);
        FieldDefinition extensionSchemaTypesFieldDef = null;
        if (!this.extensions.isEmpty()) {
            extensionSchemaTypesFieldDef = this.innerNodeClassDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "_" + EXTENSION_SCHEMA_TYPES_MTD.getName(), Class[].class);
        }
        this.addNodeConstructor(specFields, fieldDefs, extensionSchemaTypesFieldDef);
        if (this.internalIdField != null) {
            this.addNodeInternalIdMethod();
        }
        for (Field schemaField : CollectionUtils.concat(new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields})) {
            String fieldName = schemaField.getName();
            FieldDefinition fieldDef = (FieldDefinition)fieldDefs.get(fieldName);
            this.addNodeViewMethod(this.innerNodeClassDef, schemaField, viewMtd -> ConfigurationAsmGenerator.getThisFieldCode(viewMtd, fieldDef), null);
            if (ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField)) continue;
            List<MethodDefinition> changeMethods = this.addNodeChangeMethod(this.innerNodeClassDef, schemaField, changeMtd -> ConfigurationAsmGenerator.getThisFieldCode(changeMtd, fieldDef), (changeMtd, newValue) -> ConfigurationAsmGenerator.setThisFieldCode(changeMtd, newValue, fieldDef), null);
            InnerNodeAsmGenerator.addNodeChangeBridgeMethod(this.innerNodeClassDef, SchemaClassesInfo.changeClassName(schemaField.getDeclaringClass()), changeMethods.get(0));
        }
        Map<Class<?>, List<Field>> polymorphicFieldsByExtension = Map.of();
        MethodDefinition changePolymorphicTypeIdMtd = null;
        if (!this.polymorphicExtensions.isEmpty()) {
            assert (polymorphicTypeIdFieldDef != null) : this.schemaClass.getName();
            this.addNodeSpecificNodeMethod(polymorphicTypeIdFieldDef);
            changePolymorphicTypeIdMtd = this.addNodeChangePolymorphicTypeIdMethod(fieldDefs, polymorphicTypeIdFieldDef);
            this.addNodeConvertMethods(changePolymorphicTypeIdMtd);
            polymorphicFieldsByExtension = new LinkedHashMap();
            for (Class polymorphicExtension : this.polymorphicExtensions) {
                polymorphicFieldsByExtension.put(polymorphicExtension, this.polymorphicFields.stream().filter(f -> polymorphicExtension.equals(f.getDeclaringClass())).collect(Collectors.toList()));
            }
        }
        this.addNodeTraverseChildrenMethod(fieldDefs, polymorphicFieldsByExtension, polymorphicTypeIdFieldDef);
        this.addNodeTraverseChildMethod(fieldDefs, polymorphicFieldsByExtension, polymorphicTypeIdFieldDef);
        this.addNodeConstructMethod(fieldDefs, polymorphicFieldsByExtension, polymorphicTypeIdFieldDef, changePolymorphicTypeIdMtd);
        this.addNodeConstructDefaultMethod(specFields, fieldDefs, polymorphicFieldsByExtension, polymorphicTypeIdFieldDef);
        if (injectedNameFieldDef != null) {
            this.addInjectedNameFieldMethods(injectedNameFieldDef);
        }
        if (injectedValueField != null) {
            this.implementInjectedValueFieldNameMethod(injectedValueField);
        }
        if (polymorphicTypeIdFieldDef != null) {
            this.addIsPolymorphicMethod();
        }
        if (extensionSchemaTypesFieldDef != null) {
            this.addExtensionSchemaTypesMethod(extensionSchemaTypesFieldDef);
        }
        if (this.schemaClass.getSuperclass().isAnnotationPresent(AbstractConfiguration.class)) {
            this.addIsExtendAbstractConfigurationMethod();
        }
        return this.innerNodeClassDef;
    }

    private void addNodeSchemaTypeMethod(@Nullable FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition schemaTypeMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "schemaType", ParameterizedType.type(Class.class), new Parameter[0]);
        BytecodeBlock mtdBody = schemaTypeMtd.getBody();
        if (this.polymorphicExtensions.isEmpty()) {
            mtdBody.append(BytecodeExpressions.constantClass(this.schemaClass)).retObject();
        } else {
            assert (polymorphicTypeIdFieldDef != null) : this.innerNodeClassDef.getName();
            StringSwitchBuilder switchBuilderTypeId = ConfigurationAsmGenerator.typeIdSwitchBuilder(schemaTypeMtd, polymorphicTypeIdFieldDef);
            for (Class polymorphicExtension : this.polymorphicExtensions) {
                switchBuilderTypeId.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), BytecodeExpressions.constantClass(polymorphicExtension).ret());
            }
            mtdBody.append(switchBuilderTypeId.build());
        }
    }

    private FieldDefinition addInnerNodeField(Field schemaField) {
        ParameterizedType nodeFieldType;
        String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
        Class<?> schemaFieldClass = schemaField.getType();
        if (ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) || ConfigurationUtil.isInjectedName(schemaField)) {
            nodeFieldType = ParameterizedType.type(ConfigurationAsmGenerator.box(schemaFieldClass));
        } else if (ConfigurationUtil.isConfigValue(schemaField)) {
            nodeFieldType = ParameterizedType.typeFromJavaClassName(this.cgen.schemaInfo(schemaFieldClass).nodeClassName);
        } else if (ConfigurationUtil.isNamedConfigValue(schemaField)) {
            nodeFieldType = ParameterizedType.type(NamedListNode.class);
        } else {
            throw new IllegalArgumentException("Unsupported field: " + schemaField);
        }
        this.fieldToFieldDefinitionMap.put(schemaField, this.innerNodeClassDef.declareField(EnumSet.of(Access.PUBLIC, Access.STATIC, Access.FINAL), fieldName.toUpperCase(Locale.ROOT) + "_SCHEMA_FIELD", Field.class));
        return this.innerNodeClassDef.declareField(EnumSet.of(Access.PUBLIC), fieldName, nodeFieldType);
    }

    private void addNodeConstructor(Map<Class<?>, FieldDefinition> specFields, Map<String, FieldDefinition> fieldDefs, @Nullable FieldDefinition extensionSchemaTypesFieldDef) {
        MethodDefinition ctor = this.innerNodeClassDef.declareConstructor(EnumSet.of(Access.PUBLIC), new Parameter[0]);
        BytecodeBlock ctorBody = ctor.getBody();
        ctorBody.append(ctor.getThis()).invokeConstructor(InnerNode.class, new Class[0]);
        for (Map.Entry<Class<?>, FieldDefinition> e : specFields.entrySet()) {
            ctorBody.append(ctor.getThis().setField(e.getValue(), BytecodeExpressions.newInstance(e.getKey(), new BytecodeExpression[0])));
        }
        for (Field schemaField : CollectionUtils.concat(new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields, this.polymorphicFields})) {
            if (!ConfigurationUtil.isNamedConfigValue(schemaField)) continue;
            FieldDefinition fieldDef = fieldDefs.get(ConfigurationAsmGenerator.fieldName(schemaField));
            ctorBody.append(ConfigurationAsmGenerator.setThisFieldCode(ctor, this.cgen.newNamedListNode(schemaField), fieldDef));
        }
        if (!this.extensions.isEmpty()) {
            assert (extensionSchemaTypesFieldDef != null) : this.innerNodeClassDef;
            Variable tmpVar = ctor.getScope().createTempVariable(Class[].class);
            BytecodeBlock initExtensionSchemaTypesField = new BytecodeBlock();
            initExtensionSchemaTypesField.append(tmpVar.set(BytecodeExpressions.newArray(ParameterizedType.type(Class[].class), this.extensions.size())));
            int i = 0;
            for (Class extension : this.extensions) {
                initExtensionSchemaTypesField.append(BytecodeExpressions.set(tmpVar, BytecodeExpressions.constantInt(i++), BytecodeExpressions.constantClass(extension)));
            }
            initExtensionSchemaTypesField.append(ConfigurationAsmGenerator.setThisFieldCode(ctor, tmpVar, extensionSchemaTypesFieldDef));
            ctorBody.append(initExtensionSchemaTypesField);
        }
        ctorBody.ret();
    }

    private void addNodeInternalIdMethod() {
        MethodDefinition internalIdMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), this.internalIdField.getName(), ParameterizedType.type(UUID.class), new Parameter[0]);
        internalIdMtd.getBody().append(internalIdMtd.getThis().invoke(INTERNAL_ID, new BytecodeExpression[0])).retObject();
    }

    private void addNodeViewMethod(ClassDefinition classDef, Field schemaField, Function<MethodDefinition, BytecodeExpression> getFieldCodeFun, @Nullable Function<MethodDefinition, BytecodeExpression> getPolymorphicTypeIdFieldFun) {
        Class<?> schemaFieldType = schemaField.getType();
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(schemaFieldType);
        ParameterizedType returnType = ConfigurationUtil.isConfigValue(schemaField) ? ParameterizedType.typeFromJavaClassName(schemaClassInfo.viewClassName) : (ConfigurationUtil.isNamedConfigValue(schemaField) ? ParameterizedType.type(NamedListView.class) : ParameterizedType.type(schemaFieldType));
        String fieldName = schemaField.getName();
        MethodDefinition viewMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), fieldName, returnType, new Parameter[0]);
        BytecodeBlock bytecodeBlock = new BytecodeBlock();
        bytecodeBlock.append(getFieldCodeFun.apply(viewMtd));
        if (schemaFieldType.isPrimitive()) {
            bytecodeBlock.invokeVirtual(ConfigurationAsmGenerator.box(schemaFieldType), schemaFieldType.getSimpleName() + "Value", schemaFieldType, new Class[0]);
        } else if (schemaFieldType.isArray()) {
            bytecodeBlock.invokeVirtual(schemaFieldType, "clone", Object.class, new Class[0]).checkCast(schemaFieldType);
        } else if (ConfigurationUtil.isPolymorphicConfig(schemaFieldType) && ConfigurationUtil.isConfigValue(schemaField)) {
            bytecodeBlock.invokeVirtual(SPECIFIC_NODE_MTD);
        }
        bytecodeBlock.ret(schemaFieldType);
        this.enrichWithPolymorphicTypeCheck(schemaField, getPolymorphicTypeIdFieldFun, viewMtd, bytecodeBlock);
    }

    private List<MethodDefinition> addNodeChangeMethod(ClassDefinition classDef, Field schemaField, Function<MethodDefinition, BytecodeExpression> getFieldCodeFun, BiFunction<MethodDefinition, BytecodeExpression, BytecodeExpression> setFieldCodeFun, @Nullable Function<MethodDefinition, BytecodeExpression> getPolymorphicTypeIdFieldFun) {
        Class<?> schemaFieldType = schemaField.getType();
        MethodDefinition changeMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), ConfigurationAsmGenerator.changeMethodName(schemaField.getName()), classDef.getType(), Parameter.arg("change", ConfigurationUtil.isValue(schemaField) ? ParameterizedType.type(schemaFieldType) : ParameterizedType.type(Consumer.class)));
        MethodDefinition shortChangeMtd = null;
        Variable changeVar = changeMtd.getScope().getVariable("change");
        BytecodeBlock bytecodeBlock = new BytecodeBlock();
        this.addAssertMutabilityMethodCall(classDef, changeMtd, bytecodeBlock);
        if (!schemaFieldType.isPrimitive()) {
            bytecodeBlock.append(BytecodeExpressions.invokeStatic(REQUIRE_NON_NULL, changeVar, BytecodeExpressions.constantString("change")));
        }
        if (ConfigurationUtil.isValue(schemaField)) {
            BytecodeExpression newValue;
            if (schemaFieldType.isPrimitive()) {
                ParameterizedType type = ParameterizedType.type(ConfigurationAsmGenerator.box(schemaFieldType));
                newValue = BytecodeExpressions.invokeStatic(type, "valueOf", type, Collections.singleton(changeVar));
            } else {
                newValue = schemaFieldType.isArray() ? changeVar.invoke("clone", Object.class, new BytecodeExpression[0]).cast(schemaFieldType) : changeVar;
            }
            bytecodeBlock.append(setFieldCodeFun.apply(changeMtd, newValue));
        } else {
            shortChangeMtd = this.createShortChangeMethod(classDef, schemaField, getFieldCodeFun, setFieldCodeFun, getPolymorphicTypeIdFieldFun);
            bytecodeBlock.append(changeVar.invoke(ACCEPT, changeMtd.getThis().invoke(shortChangeMtd, List.of())));
        }
        bytecodeBlock.append(changeMtd.getThis()).retObject();
        this.enrichWithPolymorphicTypeCheck(schemaField, getPolymorphicTypeIdFieldFun, changeMtd, bytecodeBlock);
        if (shortChangeMtd == null) {
            return List.of(changeMtd);
        }
        return List.of(changeMtd, shortChangeMtd);
    }

    private MethodDefinition createShortChangeMethod(ClassDefinition classDef, Field schemaField, Function<MethodDefinition, BytecodeExpression> getFieldCodeFun, BiFunction<MethodDefinition, BytecodeExpression, BytecodeExpression> setFieldCodeFun, @Nullable Function<MethodDefinition, BytecodeExpression> getPolymorphicTypeIdFieldFun) {
        BytecodeExpression newValue;
        MethodDefinition shortChangeMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), ConfigurationAsmGenerator.changeMethodName(schemaField.getName()), ConfigurationUtil.isConfigValue(schemaField) ? ParameterizedType.typeFromJavaClassName(SchemaClassesInfo.changeClassName(schemaField.getType())) : ParameterizedType.type(NamedListChange.class), new Parameter[0]);
        BytecodeBlock shortBytecodeBlock = new BytecodeBlock();
        this.addAssertMutabilityMethodCall(classDef, shortChangeMtd, shortBytecodeBlock);
        if (ConfigurationUtil.isConfigValue(schemaField)) {
            newValue = this.cgen.newOrCopyNodeField(schemaField, getFieldCodeFun.apply(shortChangeMtd));
        } else {
            assert (ConfigurationUtil.isNamedConfigValue(schemaField)) : schemaField;
            newValue = this.cgen.copyNodeField(schemaField, getFieldCodeFun.apply(shortChangeMtd));
        }
        shortBytecodeBlock.append(setFieldCodeFun.apply(shortChangeMtd, newValue));
        BytecodeExpression getFieldCode = getFieldCodeFun.apply(shortChangeMtd);
        if (ConfigurationUtil.isPolymorphicConfig(schemaField.getType()) && ConfigurationUtil.isConfigValue(schemaField)) {
            getFieldCode = getFieldCode.invoke(SPECIFIC_NODE_MTD, new BytecodeExpression[0]);
        }
        shortBytecodeBlock.append(getFieldCode).retObject();
        this.enrichWithPolymorphicTypeCheck(schemaField, getPolymorphicTypeIdFieldFun, shortChangeMtd, shortBytecodeBlock);
        shortChangeMtd.getBody().append(shortBytecodeBlock);
        return shortChangeMtd;
    }

    private void addAssertMutabilityMethodCall(ClassDefinition classDef, MethodDefinition changeMtd, BytecodeBlock body) {
        if (classDef == this.innerNodeClassDef) {
            body.append(changeMtd.getThis().invoke(ASSERT_MUTABILITY_MTD, new BytecodeExpression[0]));
        } else {
            body.append(changeMtd.getThis().getField(classDef.getType(), "this$0", this.innerNodeClassDef.getType()).invoke(ASSERT_MUTABILITY_MTD, new BytecodeExpression[0]));
        }
    }

    private void enrichWithPolymorphicTypeCheck(Field schemaField, @Nullable Function<MethodDefinition, BytecodeExpression> getPolymorphicTypeIdFieldFun, MethodDefinition method, BytecodeBlock bytecodeBlock) {
        if (getPolymorphicTypeIdFieldFun != null) {
            assert (ConfigurationUtil.isPolymorphicConfigInstance(schemaField.getDeclaringClass())) : schemaField;
            BytecodeExpression getPolymorphicTypeIdFieldValue = getPolymorphicTypeIdFieldFun.apply(method);
            String polymorphicInstanceId = ConfigurationUtil.polymorphicInstanceId(schemaField.getDeclaringClass());
            method.getBody().append(new IfStatement().condition(BytecodeExpressions.not(BytecodeExpressions.constantString(polymorphicInstanceId).invoke(STRING_EQUALS_MTD, getPolymorphicTypeIdFieldValue))).ifTrue(ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, getPolymorphicTypeIdFieldValue)).ifFalse(bytecodeBlock));
        } else {
            method.getBody().append(bytecodeBlock);
        }
    }

    private static void addNodeChangeBridgeMethod(ClassDefinition classDef, String changeClassName, MethodDefinition changeMtd) {
        MethodDefinition bridgeMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC, Access.SYNTHETIC, Access.BRIDGE), changeMtd.getName(), ParameterizedType.typeFromJavaClassName(changeClassName), changeMtd.getParameters());
        Variable changeVar = bridgeMtd.getScope().getVariable("change");
        BytecodeExpression invokeChangeMtd = bridgeMtd.getThis().invoke(changeMtd, List.of(changeVar));
        bridgeMtd.getBody().append(invokeChangeMtd).retObject();
    }

    private void addNodeTraverseChildrenMethod(Map<String, FieldDefinition> fieldDefs, Map<Class<?>, List<Field>> polymorphicFieldsByExtension, @Nullable FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition traverseChildrenMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "traverseChildren", ParameterizedType.type(Void.TYPE), Parameter.arg("visitor", ParameterizedType.type(ConfigurationVisitor.class)), Parameter.arg("includeInternal", ParameterizedType.type(Boolean.TYPE))).addException(NoSuchElementException.class);
        BytecodeBlock mtdBody = traverseChildrenMtd.getBody();
        for (Field schemaField : CollectionUtils.concat(new Collection[]{this.schemaFields, this.publicExtensionFields})) {
            if (ConfigurationUtil.isInjectedName(schemaField)) continue;
            mtdBody.append(this.invokeVisit(traverseChildrenMtd, schemaField, fieldDefs.get(schemaField.getName())).pop());
        }
        if (!this.internalExtensionFields.isEmpty()) {
            BytecodeBlock includeInternalBlock = new BytecodeBlock();
            for (Field field : this.internalExtensionFields) {
                includeInternalBlock.append(this.invokeVisit(traverseChildrenMtd, field, fieldDefs.get(field.getName())).pop());
            }
            mtdBody.append(new IfStatement().condition(traverseChildrenMtd.getScope().getVariable("includeInternal")).ifTrue(includeInternalBlock));
        } else if (!polymorphicFieldsByExtension.isEmpty()) {
            assert (polymorphicTypeIdFieldDef != null) : this.schemaClass.getName();
            assert (this.schemaFields.stream().anyMatch(ConfigurationUtil::isPolymorphicId)) : "Missing field with @PolymorphicId in " + this.schemaClass.getName();
            StringSwitchBuilder switchBuilderTypeId = ConfigurationAsmGenerator.typeIdSwitchBuilder(traverseChildrenMtd, polymorphicTypeIdFieldDef);
            for (Map.Entry entry : polymorphicFieldsByExtension.entrySet()) {
                BytecodeBlock codeBlock = new BytecodeBlock();
                for (Field polymorphicField : (List)entry.getValue()) {
                    String fieldName = ConfigurationAsmGenerator.fieldName(polymorphicField);
                    codeBlock.append(this.invokeVisit(traverseChildrenMtd, polymorphicField, fieldDefs.get(fieldName)).pop());
                }
                switchBuilderTypeId.addCase(ConfigurationUtil.polymorphicInstanceId((Class)entry.getKey()), codeBlock);
            }
            mtdBody.append(new IfStatement().condition(BytecodeExpressions.isNotNull(ConfigurationAsmGenerator.getThisFieldCode(traverseChildrenMtd, polymorphicTypeIdFieldDef))).ifTrue(switchBuilderTypeId.build()));
        }
        mtdBody.ret();
    }

    private void addNodeTraverseChildMethod(Map<String, FieldDefinition> fieldDefs, Map<Class<?>, List<Field>> polymorphicFieldsByExtension, @Nullable FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition traverseChildMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "traverseChild", ParameterizedType.type(Object.class), Parameter.arg("key", ParameterizedType.type(String.class)), Parameter.arg("visitor", ParameterizedType.type(ConfigurationVisitor.class)), Parameter.arg("includeInternal", ParameterizedType.type(Boolean.TYPE))).addException(NoSuchElementException.class);
        Variable keyVar = traverseChildMtd.getScope().getVariable("key");
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(traverseChildMtd.getScope()).expression(keyVar);
        for (Field schemaField : CollectionUtils.concat(new Collection[]{this.schemaFields, this.publicExtensionFields})) {
            if (ConfigurationUtil.isInjectedName(schemaField)) continue;
            String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
            String publicName = ConfigurationAsmGenerator.publicName(schemaField);
            switchBuilder.addCase(publicName, this.invokeVisit(traverseChildMtd, schemaField, fieldDefs.get(fieldName)).retObject());
        }
        if (!this.internalExtensionFields.isEmpty()) {
            StringSwitchBuilder switchBuilderAllFields = new StringSwitchBuilder(traverseChildMtd.getScope()).expression(keyVar).defaultCase(ConfigurationAsmGenerator.throwException(NoSuchElementException.class, keyVar));
            for (Field schemaField : CollectionUtils.concat(new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields})) {
                if (ConfigurationUtil.isInjectedName(schemaField)) continue;
                String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
                String publicName = ConfigurationAsmGenerator.publicName(schemaField);
                switchBuilderAllFields.addCase(publicName, this.invokeVisit(traverseChildMtd, schemaField, fieldDefs.get(fieldName)).retObject());
            }
            traverseChildMtd.getBody().append(new IfStatement().condition(traverseChildMtd.getScope().getVariable("includeInternal")).ifTrue(switchBuilderAllFields.build()).ifFalse(switchBuilder.defaultCase(ConfigurationAsmGenerator.throwException(NoSuchElementException.class, keyVar)).build()));
        } else if (!polymorphicFieldsByExtension.isEmpty()) {
            assert (polymorphicTypeIdFieldDef != null) : this.innerNodeClassDef.getName();
            StringSwitchBuilder switchBuilderTypeId = ConfigurationAsmGenerator.typeIdSwitchBuilder(traverseChildMtd, polymorphicTypeIdFieldDef);
            for (Map.Entry<Class<?>, List<Field>> e : polymorphicFieldsByExtension.entrySet()) {
                StringSwitchBuilder switchBuilderPolymorphicExtension = new StringSwitchBuilder(traverseChildMtd.getScope()).expression(keyVar).defaultCase(ConfigurationAsmGenerator.throwException(NoSuchElementException.class, keyVar));
                for (Field polymorphicField : e.getValue()) {
                    String fieldName = ConfigurationAsmGenerator.fieldName(polymorphicField);
                    String publicName = ConfigurationAsmGenerator.publicName(polymorphicField);
                    switchBuilderPolymorphicExtension.addCase(publicName, this.invokeVisit(traverseChildMtd, polymorphicField, fieldDefs.get(fieldName)).retObject());
                }
                switchBuilderTypeId.addCase(ConfigurationUtil.polymorphicInstanceId(e.getKey()), switchBuilderPolymorphicExtension.build());
            }
            traverseChildMtd.getBody().append(switchBuilder.defaultCase(new BytecodeBlock()).build()).append(switchBuilderTypeId.build());
        } else {
            traverseChildMtd.getBody().append(switchBuilder.defaultCase(ConfigurationAsmGenerator.throwException(NoSuchElementException.class, keyVar)).build());
        }
    }

    private BytecodeBlock invokeVisit(MethodDefinition mtd, Field schemaField, FieldDefinition fieldDef) {
        Method visitMethod = ConfigurationUtil.isValue(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) ? VISIT_LEAF : (ConfigurationUtil.isConfigValue(schemaField) ? VISIT_INNER : VISIT_NAMED);
        FieldDefinition definition = this.fieldToFieldDefinitionMap.get(schemaField);
        return new BytecodeBlock().append(mtd.getScope().getVariable("visitor").invoke(visitMethod, BytecodeExpressions.getStatic(definition), BytecodeExpressions.constantString(ConfigurationAsmGenerator.publicName(schemaField)), mtd.getThis().getField(fieldDef)));
    }

    private void addNodeConstructMethod(Map<String, FieldDefinition> fieldDefs, Map<Class<?>, List<Field>> polymorphicFieldsByExtension, @Nullable FieldDefinition polymorphicTypeIdFieldDef, @Nullable MethodDefinition changePolymorphicTypeIdMtd) {
        MethodDefinition constructMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), CONSTRUCT_MTD_NAME, ParameterizedType.type(Void.TYPE), Parameter.arg("key", ParameterizedType.type(String.class)), Parameter.arg("src", ParameterizedType.type(ConfigurationSource.class)), Parameter.arg("includeInternal", ParameterizedType.type(Boolean.TYPE))).addException(NoSuchElementException.class);
        Variable keyVar = constructMtd.getScope().getVariable("key");
        Variable srcVar = constructMtd.getScope().getVariable("src");
        this.addAssertMutabilityMethodCall(this.innerNodeClassDef, constructMtd, constructMtd.getBody());
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(constructMtd.getScope()).expression(keyVar);
        for (Field schemaField : CollectionUtils.concat(new Collection[]{this.schemaFields, this.publicExtensionFields})) {
            int n;
            if (ConfigurationUtil.isInjectedName(schemaField)) continue;
            String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
            String publicName = ConfigurationAsmGenerator.publicName(schemaField);
            FieldDefinition fieldDef = fieldDefs.get(fieldName);
            if (ConfigurationUtil.isPolymorphicId(schemaField)) {
                BytecodeExpression bytecodeExpression = BytecodeExpressions.inlineIf(BytecodeExpressions.isNull(srcVar), BytecodeExpressions.constantNull(fieldDef.getType()), srcVar.invoke(UNWRAP, BytecodeExpressions.constantClass(fieldDef.getType())).cast(fieldDef.getType()));
                switchBuilder.addCase(publicName, new BytecodeBlock().append(constructMtd.getThis()).append(bytecodeExpression).invokeVirtual(changePolymorphicTypeIdMtd).ret());
                String[] stringArray = ConfigurationAsmGenerator.legacyNames(schemaField);
                n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String legacyName = stringArray[i];
                    switchBuilder.addCase(legacyName, new BytecodeBlock().append(constructMtd.getThis()).append(bytecodeExpression).invokeVirtual(changePolymorphicTypeIdMtd).ret());
                }
                continue;
            }
            switchBuilder.addCase(publicName, this.treatSourceForConstruct(constructMtd, schemaField, fieldDef).ret());
            String[] stringArray = ConfigurationAsmGenerator.legacyNames(schemaField);
            int n2 = stringArray.length;
            for (n = 0; n < n2; ++n) {
                String legacyName = stringArray[n];
                switchBuilder.addCase(legacyName, this.treatSourceForConstruct(constructMtd, schemaField, fieldDef).ret());
            }
        }
        if (!this.internalExtensionFields.isEmpty()) {
            StringSwitchBuilder switchBuilderAllFields = new StringSwitchBuilder(constructMtd.getScope()).expression(keyVar).defaultCase(ConfigurationAsmGenerator.throwException(NoSuchElementException.class, keyVar));
            for (Field schemaField : CollectionUtils.concat(new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields})) {
                if (ConfigurationUtil.isInjectedName(schemaField)) continue;
                String fieldName = ConfigurationAsmGenerator.fieldName(schemaField);
                String publicName = ConfigurationAsmGenerator.publicName(schemaField);
                switchBuilderAllFields.addCase(publicName, this.treatSourceForConstruct(constructMtd, schemaField, fieldDefs.get(fieldName)).ret());
                for (String legacyName : ConfigurationAsmGenerator.legacyNames(schemaField)) {
                    switchBuilderAllFields.addCase(legacyName, this.treatSourceForConstruct(constructMtd, schemaField, fieldDefs.get(fieldName)).ret());
                }
            }
            constructMtd.getBody().append(new IfStatement().condition(constructMtd.getScope().getVariable("includeInternal")).ifTrue(switchBuilderAllFields.build()).ifFalse(switchBuilder.defaultCase(ConfigurationAsmGenerator.throwException(NoSuchElementException.class, keyVar)).build())).ret();
        } else if (!polymorphicFieldsByExtension.isEmpty()) {
            assert (polymorphicTypeIdFieldDef != null) : this.innerNodeClassDef.getName();
            StringSwitchBuilder switchBuilderTypeId = ConfigurationAsmGenerator.typeIdSwitchBuilder(constructMtd, polymorphicTypeIdFieldDef);
            for (Map.Entry<Class<?>, List<Field>> e : polymorphicFieldsByExtension.entrySet()) {
                StringSwitchBuilder switchBuilderPolymorphicExtension = new StringSwitchBuilder(constructMtd.getScope()).expression(keyVar).defaultCase(ConfigurationAsmGenerator.throwException(NoSuchElementException.class, keyVar));
                for (Field field : e.getValue()) {
                    String fieldName = ConfigurationAsmGenerator.fieldName(field);
                    String publicName = ConfigurationAsmGenerator.publicName(field);
                    FieldDefinition fieldDef = fieldDefs.get(fieldName);
                    switchBuilderPolymorphicExtension.addCase(publicName, this.treatSourceForConstruct(constructMtd, field, fieldDef).ret());
                    for (String legacyName : ConfigurationAsmGenerator.legacyNames(field)) {
                        switchBuilderPolymorphicExtension.addCase(legacyName, this.treatSourceForConstruct(constructMtd, field, fieldDef).ret());
                    }
                }
                switchBuilderTypeId.addCase(ConfigurationUtil.polymorphicInstanceId(e.getKey()), switchBuilderPolymorphicExtension.build());
            }
            constructMtd.getBody().append(switchBuilder.defaultCase(new BytecodeBlock()).build()).append(switchBuilderTypeId.build()).ret();
        } else {
            constructMtd.getBody().append(switchBuilder.defaultCase(ConfigurationAsmGenerator.throwException(NoSuchElementException.class, keyVar)).build()).ret();
        }
    }

    private BytecodeBlock treatSourceForConstruct(MethodDefinition constructMtd, Field schemaField, FieldDefinition schemaFieldDef) {
        BytecodeBlock codeBlock = new BytecodeBlock();
        Variable thisVar = constructMtd.getThis();
        Variable srcVar = constructMtd.getScope().getVariable("src");
        if (ConfigurationUtil.isValue(schemaField)) {
            codeBlock.append(thisVar.setField(schemaFieldDef, BytecodeExpressions.inlineIf(BytecodeExpressions.isNull(srcVar), BytecodeExpressions.constantNull(schemaFieldDef.getType()), srcVar.invoke(UNWRAP, BytecodeExpressions.constantClass(schemaFieldDef.getType())).cast(schemaFieldDef.getType()))));
        } else if (ConfigurationUtil.isConfigValue(schemaField)) {
            BytecodeNode setField;
            ParameterizedType fieldDefType = schemaFieldDef.getType();
            if (ConfigurationUtil.isPolymorphicConfig(schemaField.getType())) {
                Field polymorphicIdField = ConfigurationAsmGenerator.polymorphicIdField(schemaField.getType());
                assert (polymorphicIdField != null) : schemaField.getType().getName();
                BytecodeExpression thisField = ConfigurationAsmGenerator.getThisFieldCode(constructMtd, schemaFieldDef);
                Variable tmpStrVar = constructMtd.getScope().createTempVariable(String.class);
                BytecodeBlock copyWithChange = new BytecodeBlock().append(ConfigurationAsmGenerator.setThisFieldCode(constructMtd, thisField.invoke(COPY, new BytecodeExpression[0]).cast(fieldDefType), schemaFieldDef)).append(new IfStatement().condition(BytecodeExpressions.isNotNull(tmpStrVar)).ifTrue(thisField.invoke(ConfigurationAsmGenerator.changeMethodName(polymorphicIdField.getName()), Void.TYPE, tmpStrVar)));
                BytecodeBlock newInstanceWithChange = new BytecodeBlock().append(ConfigurationAsmGenerator.setThisFieldCode(constructMtd, BytecodeExpressions.newInstance(fieldDefType, new BytecodeExpression[0]), schemaFieldDef)).append(new IfStatement().condition(BytecodeExpressions.isNotNull(tmpStrVar)).ifTrue(thisField.invoke(ConfigurationAsmGenerator.changeMethodName(polymorphicIdField.getName()), Void.TYPE, tmpStrVar)).ifFalse(new BytecodeBlock().append(thisField.invoke(CONSTRUCT_DEFAULT_MTD, BytecodeExpressions.constantString(polymorphicIdField.getName()))).append(new IfStatement().condition(BytecodeExpressions.isNull(thisField.getField(polymorphicIdField.getName(), String.class))).ifTrue(ConfigurationAsmGenerator.throwException(IllegalStateException.class, BytecodeExpressions.constantString(InnerNodeAsmGenerator.polymorphicTypeNotDefinedErrorMessage(polymorphicIdField)))))));
                setField = new BytecodeBlock().append(tmpStrVar.set(srcVar.invoke(POLYMORPHIC_TYPE_ID_MTD, BytecodeExpressions.constantString(polymorphicIdField.getName())))).append(new IfStatement().condition(BytecodeExpressions.isNull(thisField)).ifTrue(newInstanceWithChange).ifFalse(copyWithChange));
            } else {
                BytecodeExpression newValue = this.cgen.newOrCopyNodeField(schemaField, ConfigurationAsmGenerator.getThisFieldCode(constructMtd, schemaFieldDef));
                setField = ConfigurationAsmGenerator.setThisFieldCode(constructMtd, newValue, schemaFieldDef);
            }
            if (ConfigurationUtil.containsNameAnnotation(schemaField)) {
                setField = new BytecodeBlock().append(setField).append(ConfigurationAsmGenerator.getThisFieldCode(constructMtd, schemaFieldDef).invoke(SET_INJECTED_NAME_FIELD_VALUE_MTD, BytecodeExpressions.constantString(schemaField.getAnnotation(Name.class).value())));
            }
            codeBlock.append(new IfStatement().condition(BytecodeExpressions.isNull(srcVar)).ifTrue(ConfigurationAsmGenerator.setThisFieldCode(constructMtd, BytecodeExpressions.constantNull(fieldDefType), schemaFieldDef)).ifFalse(new BytecodeBlock().append(setField).append(srcVar.invoke(DESCEND, thisVar.getField(schemaFieldDef)))));
        } else {
            codeBlock.append(new IfStatement().condition(BytecodeExpressions.isNull(srcVar)).ifTrue(ConfigurationAsmGenerator.setThisFieldCode(constructMtd, this.cgen.newNamedListNode(schemaField), schemaFieldDef)).ifFalse(new BytecodeBlock().append(ConfigurationAsmGenerator.setThisFieldCode(constructMtd, thisVar.getField(schemaFieldDef).invoke(COPY, new BytecodeExpression[0]).cast(schemaFieldDef.getType()), schemaFieldDef)).append(srcVar.invoke(DESCEND, thisVar.getField(schemaFieldDef)))));
        }
        return codeBlock;
    }

    private void addNodeConstructDefaultMethod(Map<Class<?>, FieldDefinition> specFields, Map<String, FieldDefinition> fieldDefs, Map<Class<?>, List<Field>> polymorphicFieldsByExtension, @Nullable FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition constructDfltMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "constructDefault", ParameterizedType.type(Void.TYPE), Parameter.arg("key", String.class)).addException(NoSuchElementException.class);
        this.addAssertMutabilityMethodCall(this.innerNodeClassDef, constructDfltMtd, constructDfltMtd.getBody());
        Variable keyVar = constructDfltMtd.getScope().getVariable("key");
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(constructDfltMtd.getScope()).expression(keyVar);
        for (Field schemaField : CollectionUtils.concat(new Collection[]{this.schemaFields, this.publicExtensionFields, this.internalExtensionFields})) {
            if (ConfigurationUtil.isInjectedName(schemaField) || !ConfigurationUtil.isValue(schemaField) && !ConfigurationUtil.isPolymorphicId(schemaField)) continue;
            String fieldName = schemaField.getName();
            String publicName = ConfigurationAsmGenerator.publicName(schemaField);
            if (ConfigurationUtil.isValue(schemaField) && !ConfigurationUtil.hasDefault(schemaField) || ConfigurationUtil.isPolymorphicId(schemaField) && !schemaField.getAnnotation(PolymorphicId.class).hasDefault()) {
                switchBuilder.addCase(publicName, new BytecodeBlock().ret());
                for (String string : ConfigurationAsmGenerator.legacyNames(schemaField)) {
                    switchBuilder.addCase(string, new BytecodeBlock().ret());
                }
                continue;
            }
            FieldDefinition fieldDef = fieldDefs.get(fieldName);
            Class<?> fieldType = schemaField.getDeclaringClass();
            FieldDefinition specFieldDef = fieldType.isAnnotationPresent(AbstractConfiguration.class) ? specFields.get(this.schemaClass) : specFields.get(fieldType);
            switchBuilder.addCase(publicName, InnerNodeAsmGenerator.addNodeConstructDefault(constructDfltMtd, schemaField, fieldDef, specFieldDef).ret());
            for (String legacyName3 : ConfigurationAsmGenerator.legacyNames(schemaField)) {
                switchBuilder.addCase(legacyName3, InnerNodeAsmGenerator.addNodeConstructDefault(constructDfltMtd, schemaField, fieldDef, specFieldDef).ret());
            }
        }
        if (!polymorphicFieldsByExtension.isEmpty()) {
            StringSwitchBuilder switchBuilderTypeId = ConfigurationAsmGenerator.typeIdSwitchBuilder(constructDfltMtd, polymorphicTypeIdFieldDef);
            for (Map.Entry<Class<?>, List<Field>> e : polymorphicFieldsByExtension.entrySet()) {
                StringSwitchBuilder switchBuilderPolymorphicExtension = new StringSwitchBuilder(constructDfltMtd.getScope()).expression(keyVar).defaultCase(ConfigurationAsmGenerator.throwException(NoSuchElementException.class, keyVar));
                for (Field polymorphicField : e.getValue()) {
                    if (!ConfigurationUtil.isValue(polymorphicField)) continue;
                    String publicName = ConfigurationAsmGenerator.publicName(polymorphicField);
                    if (!ConfigurationUtil.hasDefault(polymorphicField)) {
                        switchBuilderPolymorphicExtension.addCase(publicName, new BytecodeBlock().ret());
                        for (String legacyName : ConfigurationAsmGenerator.legacyNames(polymorphicField)) {
                            switchBuilderPolymorphicExtension.addCase(legacyName, new BytecodeBlock().ret());
                        }
                        continue;
                    }
                    FieldDefinition fieldDefinition = fieldDefs.get(ConfigurationAsmGenerator.fieldName(polymorphicField));
                    FieldDefinition specFieldDef = specFields.get(polymorphicField.getDeclaringClass());
                    switchBuilderPolymorphicExtension.addCase(publicName, InnerNodeAsmGenerator.addNodeConstructDefault(constructDfltMtd, polymorphicField, fieldDefinition, specFieldDef).ret());
                    for (String legacyName : ConfigurationAsmGenerator.legacyNames(polymorphicField)) {
                        switchBuilderPolymorphicExtension.addCase(legacyName, InnerNodeAsmGenerator.addNodeConstructDefault(constructDfltMtd, polymorphicField, fieldDefinition, specFieldDef).ret());
                    }
                }
                switchBuilderTypeId.addCase(ConfigurationUtil.polymorphicInstanceId(e.getKey()), switchBuilderPolymorphicExtension.build());
            }
            constructDfltMtd.getBody().append(switchBuilder.defaultCase(new BytecodeBlock()).build()).append(switchBuilderTypeId.build()).ret();
        } else {
            constructDfltMtd.getBody().append(switchBuilder.defaultCase(ConfigurationAsmGenerator.throwException(NoSuchElementException.class, keyVar)).build()).ret();
        }
    }

    private static BytecodeBlock addNodeConstructDefault(MethodDefinition constructDfltMtd, Field schemaField, FieldDefinition schemaFieldDef, FieldDefinition specFieldDef) {
        Variable thisVar = constructDfltMtd.getThis();
        BytecodeExpression defaultValue = thisVar.getField(specFieldDef).getField(schemaField);
        Class<?> schemaFieldType = schemaField.getType();
        if (schemaFieldType.isPrimitive()) {
            defaultValue = BytecodeExpressions.invokeStatic(schemaFieldDef.getType(), "valueOf", schemaFieldDef.getType(), Collections.singleton(defaultValue));
        }
        if (schemaFieldType.isArray()) {
            defaultValue = defaultValue.invoke("clone", Object.class, new BytecodeExpression[0]).cast(schemaFieldType);
        }
        return new BytecodeBlock().append(thisVar.setField(schemaFieldDef, defaultValue));
    }

    private void addInjectedNameFieldMethods(FieldDefinition injectedNameFieldDef) {
        MethodDefinition getInjectedNameFieldValueMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "getInjectedNameFieldValue", ParameterizedType.type(String.class), new Parameter[0]);
        getInjectedNameFieldValueMtd.getBody().append(ConfigurationAsmGenerator.getThisFieldCode(getInjectedNameFieldValueMtd, injectedNameFieldDef)).retObject();
        MethodDefinition setInjectedNameFieldValueMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "setInjectedNameFieldValue", ParameterizedType.type(Void.TYPE), Parameter.arg("value", String.class));
        this.addAssertMutabilityMethodCall(this.innerNodeClassDef, setInjectedNameFieldValueMtd, setInjectedNameFieldValueMtd.getBody());
        Variable valueVar = setInjectedNameFieldValueMtd.getScope().getVariable("value");
        setInjectedNameFieldValueMtd.getBody().append(BytecodeExpressions.invokeStatic(REQUIRE_NON_NULL, valueVar, BytecodeExpressions.constantString("value"))).append(ConfigurationAsmGenerator.setThisFieldCode(setInjectedNameFieldValueMtd, valueVar, injectedNameFieldDef)).ret();
    }

    private void implementInjectedValueFieldNameMethod(Field injectedValueField) {
        MethodDefinition method = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), INJECTED_VALUE_FIELD_NAME_MTD_NAME, ParameterizedType.type(String.class), new Parameter[0]);
        method.getBody().append(BytecodeExpressions.constantString(ConfigurationAsmGenerator.publicName(injectedValueField))).retObject();
    }

    private void addIsPolymorphicMethod() {
        MethodDefinition mtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), IS_POLYMORPHIC_MTD.getName(), ParameterizedType.type(Boolean.TYPE), new Parameter[0]);
        mtd.getBody().push(true).retBoolean();
    }

    private void addExtensionSchemaTypesMethod(FieldDefinition schemaTypesFieldDef) {
        MethodDefinition mtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), EXTENSION_SCHEMA_TYPES_MTD.getName(), ParameterizedType.type(Class[].class), new Parameter[0]);
        mtd.getBody().append(ConfigurationAsmGenerator.getThisFieldCode(mtd, schemaTypesFieldDef)).retObject();
    }

    private void addIsExtendAbstractConfigurationMethod() {
        MethodDefinition mtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), "extendsAbstractConfiguration", ParameterizedType.type(Boolean.TYPE), new Parameter[0]);
        mtd.getBody().push(true).retBoolean();
    }

    private ClassDefinition createPolymorphicExtensionNodeClass(Class<?> polymorphicExtension, Collection<Field> polymorphicFields) {
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(this.schemaClass);
        SchemaClassesInfo polymorphicExtensionClassInfo = this.cgen.schemaInfo(polymorphicExtension);
        ClassDefinition classDef = new ClassDefinition(EnumSet.of(Access.PUBLIC, Access.FINAL), ConfigurationAsmGenerator.internalName(polymorphicExtensionClassInfo.nodeClassName), ParameterizedType.type(Object.class), ArrayUtils.concat(ConfigurationAsmGenerator.nodeClassInterfaces(polymorphicExtension, Set.of()), ParameterizedType.type(ConstructableTreeNode.class)));
        FieldDefinition parentInnerNodeFieldDef = classDef.declareField(EnumSet.of(Access.PRIVATE, Access.FINAL), "this$0", ParameterizedType.typeFromJavaClassName(schemaClassInfo.nodeClassName));
        MethodDefinition constructorMtd = classDef.declareConstructor(EnumSet.of(Access.PUBLIC), Parameter.arg("delegate", ParameterizedType.typeFromJavaClassName(schemaClassInfo.nodeClassName)));
        Variable delegateVar = constructorMtd.getScope().getVariable("delegate");
        constructorMtd.getBody().append(constructorMtd.getThis()).invokeConstructor(Object.class, new Class[0]).append(constructorMtd.getThis().setField(parentInnerNodeFieldDef, (BytecodeExpression)delegateVar)).ret();
        Map fieldDefs = this.innerNodeClassDef.getFields().stream().collect(Collectors.toMap(FieldDefinition::getName, Function.identity()));
        if (this.internalIdField != null) {
            this.addNodeViewMethod(classDef, this.internalIdField, viewMtd -> ConfigurationAsmGenerator.getThisFieldCode(viewMtd, parentInnerNodeFieldDef).invoke(INTERNAL_ID, new BytecodeExpression[0]), null);
        }
        for (Object schemaField : this.schemaFields) {
            FieldDefinition schemaFieldDef = (FieldDefinition)fieldDefs.get(ConfigurationAsmGenerator.fieldName((Field)schemaField));
            this.addNodeViewMethod(classDef, (Field)schemaField, viewMtd -> ConfigurationAsmGenerator.getThisFieldCode(viewMtd, parentInnerNodeFieldDef, schemaFieldDef), null);
            if (ConfigurationUtil.isReadOnly((Field)schemaField)) continue;
            List<MethodDefinition> changeMethods = this.addNodeChangeMethod(classDef, (Field)schemaField, changeMtd -> ConfigurationAsmGenerator.getThisFieldCode(changeMtd, parentInnerNodeFieldDef, schemaFieldDef), (changeMtd, newValue) -> ConfigurationAsmGenerator.setThisFieldCode(changeMtd, newValue, parentInnerNodeFieldDef, schemaFieldDef), null);
            InnerNodeAsmGenerator.addNodeChangeBridgeMethod(classDef, schemaClassInfo.changeClassName, changeMethods.get(0));
        }
        FieldDefinition polymorphicTypeIdFieldDef = (FieldDefinition)fieldDefs.get(ConfigurationAsmGenerator.polymorphicIdField(this.schemaClass).getName());
        for (Field polymorphicField : polymorphicFields) {
            FieldDefinition polymorphicFieldDef = (FieldDefinition)fieldDefs.get(ConfigurationAsmGenerator.fieldName(polymorphicField));
            this.addNodeViewMethod(classDef, polymorphicField, viewMtd -> ConfigurationAsmGenerator.getThisFieldCode(viewMtd, parentInnerNodeFieldDef, polymorphicFieldDef), viewMtd -> ConfigurationAsmGenerator.getThisFieldCode(viewMtd, parentInnerNodeFieldDef, polymorphicTypeIdFieldDef));
            List<MethodDefinition> changeMethods = this.addNodeChangeMethod(classDef, polymorphicField, changeMtd -> ConfigurationAsmGenerator.getThisFieldCode(changeMtd, parentInnerNodeFieldDef, polymorphicFieldDef), (changeMtd, newValue) -> ConfigurationAsmGenerator.setThisFieldCode(changeMtd, newValue, parentInnerNodeFieldDef, polymorphicFieldDef), changeMtd -> ConfigurationAsmGenerator.getThisFieldCode(changeMtd, parentInnerNodeFieldDef, polymorphicTypeIdFieldDef));
            InnerNodeAsmGenerator.addNodeChangeBridgeMethod(classDef, polymorphicExtensionClassInfo.changeClassName, changeMethods.get(0));
        }
        ParameterizedType returnType = ParameterizedType.typeFromJavaClassName(schemaClassInfo.changeClassName);
        MethodDefinition convertByChangeClassMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), CONVERT_MTD_NAME, returnType, Parameter.arg("changeClass", Class.class));
        convertByChangeClassMtd.getBody().append(ConfigurationAsmGenerator.getThisFieldCode(convertByChangeClassMtd, parentInnerNodeFieldDef)).append(convertByChangeClassMtd.getScope().getVariable("changeClass")).invokeVirtual(this.innerNodeClassDef.getType(), CONVERT_MTD_NAME, returnType, ParameterizedType.type(Class.class)).retObject();
        MethodDefinition convertByPolymorphicTypeIdMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), CONVERT_MTD_NAME, returnType, Parameter.arg("polymorphicTypeId", String.class));
        convertByPolymorphicTypeIdMtd.getBody().append(ConfigurationAsmGenerator.getThisFieldCode(convertByPolymorphicTypeIdMtd, parentInnerNodeFieldDef)).append(convertByPolymorphicTypeIdMtd.getScope().getVariable("polymorphicTypeId")).invokeVirtual(this.innerNodeClassDef.getType(), CONVERT_MTD_NAME, returnType, ParameterizedType.type(String.class)).retObject();
        MethodDefinition constructMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), CONSTRUCT_MTD_NAME, ParameterizedType.type(Void.TYPE), Parameter.arg("key", ParameterizedType.type(String.class)), Parameter.arg("src", ParameterizedType.type(ConfigurationSource.class)), Parameter.arg("includeInternal", ParameterizedType.type(Boolean.TYPE))).addException(NoSuchElementException.class);
        constructMtd.getBody().append(ConfigurationAsmGenerator.getThisFieldCode(constructMtd, parentInnerNodeFieldDef)).append(constructMtd.getScope().getVariable("key")).append(constructMtd.getScope().getVariable("src")).append(constructMtd.getScope().getVariable("includeInternal")).invokeVirtual(this.innerNodeClassDef.getType(), CONSTRUCT_MTD_NAME, ParameterizedType.type(Void.TYPE), ParameterizedType.type(String.class), ParameterizedType.type(ConfigurationSource.class), ParameterizedType.type(Boolean.TYPE)).ret();
        MethodDefinition copyMtd = classDef.declareMethod(EnumSet.of(Access.PUBLIC), "copy", ParameterizedType.type(ConstructableTreeNode.class), new Parameter[0]);
        copyMtd.getBody().append(ConfigurationAsmGenerator.getThisFieldCode(copyMtd, parentInnerNodeFieldDef)).invokeVirtual(this.innerNodeClassDef.getType(), "copy", ParameterizedType.type(ConstructableTreeNode.class), new ParameterizedType[0]).retObject();
        return classDef;
    }

    private void addNodeSpecificNodeMethod(FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition specificNodeMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), SPECIFIC_NODE_MTD.getName(), ParameterizedType.type(Object.class), new Parameter[0]);
        StringSwitchBuilder switchBuilder = ConfigurationAsmGenerator.typeIdSwitchBuilder(specificNodeMtd, polymorphicTypeIdFieldDef);
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            SchemaClassesInfo polymorphicExtensionClassInfo = this.cgen.schemaInfo(polymorphicExtension);
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), BytecodeExpressions.newInstance(ParameterizedType.typeFromJavaClassName(polymorphicExtensionClassInfo.nodeClassName), specificNodeMtd.getThis()).ret());
        }
        specificNodeMtd.getBody().append(switchBuilder.build());
    }

    private void addNodeConvertMethods(MethodDefinition changePolymorphicTypeIdMtd) {
        SchemaClassesInfo schemaClassInfo = this.cgen.schemaInfo(this.schemaClass);
        MethodDefinition convertByChangeClassMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), CONVERT_MTD_NAME, ParameterizedType.typeFromJavaClassName(schemaClassInfo.changeClassName), Parameter.arg("changeClass", Class.class));
        MethodDefinition convertByPolymorphicTypeIdMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), CONVERT_MTD_NAME, ParameterizedType.typeFromJavaClassName(schemaClassInfo.changeClassName), Parameter.arg("polymorphicTypeId", String.class));
        BytecodeExpression changeClassName = convertByChangeClassMtd.getScope().getVariable("changeClass").invoke(CLASS_GET_NAME_MTD, new BytecodeExpression[0]);
        StringSwitchBuilder switchByChangeClassBuilder = new StringSwitchBuilder(convertByChangeClassMtd.getScope()).expression(changeClassName).defaultCase(ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, changeClassName));
        Variable polymorphicTypeId = convertByPolymorphicTypeIdMtd.getScope().getVariable("polymorphicTypeId");
        StringSwitchBuilder switchByPolymorphicTypeIdBuilder = new StringSwitchBuilder(convertByPolymorphicTypeIdMtd.getScope()).expression(polymorphicTypeId).defaultCase(ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, polymorphicTypeId));
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            SchemaClassesInfo polymorphicExtensionClassInfo = this.cgen.schemaInfo(polymorphicExtension);
            String polymorphicInstanceId = ConfigurationUtil.polymorphicInstanceId(polymorphicExtension);
            switchByChangeClassBuilder.addCase(polymorphicExtensionClassInfo.changeClassName, new BytecodeBlock().append(BytecodeExpressions.constantString(polymorphicInstanceId)).invokeVirtual(changePolymorphicTypeIdMtd).append(BytecodeExpressions.newInstance(ParameterizedType.typeFromJavaClassName(polymorphicExtensionClassInfo.nodeClassName), convertByChangeClassMtd.getThis())).retObject());
            switchByPolymorphicTypeIdBuilder.addCase(polymorphicInstanceId, new BytecodeBlock().append(BytecodeExpressions.constantString(polymorphicInstanceId)).invokeVirtual(changePolymorphicTypeIdMtd).append(BytecodeExpressions.newInstance(ParameterizedType.typeFromJavaClassName(polymorphicExtensionClassInfo.nodeClassName), convertByPolymorphicTypeIdMtd.getThis())).retObject());
        }
        convertByChangeClassMtd.getBody().append(convertByChangeClassMtd.getThis()).append(switchByChangeClassBuilder.build()).ret();
        convertByPolymorphicTypeIdMtd.getBody().append(convertByPolymorphicTypeIdMtd.getThis()).append(switchByPolymorphicTypeIdBuilder.build()).ret();
    }

    private MethodDefinition addNodeChangePolymorphicTypeIdMethod(Map<String, FieldDefinition> fieldDefs, FieldDefinition polymorphicTypeIdFieldDef) {
        MethodDefinition changePolymorphicTypeIdMtd = this.innerNodeClassDef.declareMethod(EnumSet.of(Access.PUBLIC), ConfigurationAsmGenerator.changeMethodName(polymorphicTypeIdFieldDef.getName()), ParameterizedType.type(Void.TYPE), Parameter.arg("typeId", String.class));
        Variable typeIdVar = changePolymorphicTypeIdMtd.getScope().getVariable("typeId");
        StringSwitchBuilder switchBuilder = new StringSwitchBuilder(changePolymorphicTypeIdMtd.getScope()).expression(typeIdVar).defaultCase(ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, typeIdVar));
        for (Class polymorphicExtension : this.polymorphicExtensions) {
            Collection resetFields = this.polymorphicFields.stream().filter(f -> !polymorphicExtension.equals(f.getDeclaringClass())).collect(Collectors.toList());
            BytecodeBlock codeBlock = new BytecodeBlock().append(ConfigurationAsmGenerator.setThisFieldCode(changePolymorphicTypeIdMtd, typeIdVar, polymorphicTypeIdFieldDef));
            for (Field resetField : resetFields) {
                FieldDefinition fieldDef = fieldDefs.get(ConfigurationAsmGenerator.fieldName(resetField));
                if (ConfigurationUtil.isValue(resetField) || ConfigurationUtil.isConfigValue(resetField)) {
                    codeBlock.append(ConfigurationAsmGenerator.setThisFieldCode(changePolymorphicTypeIdMtd, BytecodeExpressions.constantNull(fieldDef.getType()), fieldDef));
                    continue;
                }
                codeBlock.append(ConfigurationAsmGenerator.setThisFieldCode(changePolymorphicTypeIdMtd, this.cgen.newNamedListNode(resetField), fieldDef));
            }
            codeBlock.append(changePolymorphicTypeIdMtd.getThis()).invokeStatic(ADD_DEFAULTS_MTD);
            switchBuilder.addCase(ConfigurationUtil.polymorphicInstanceId(polymorphicExtension), codeBlock);
        }
        changePolymorphicTypeIdMtd.getBody().append(typeIdVar).append(ConfigurationAsmGenerator.getThisFieldCode(changePolymorphicTypeIdMtd, polymorphicTypeIdFieldDef)).append(new IfStatement().condition(new BytecodeBlock().invokeVirtual(STRING_EQUALS_MTD)).ifTrue(new BytecodeBlock().ret()).ifFalse(switchBuilder.build().ret()));
        return changePolymorphicTypeIdMtd;
    }

    private static String polymorphicTypeNotDefinedErrorMessage(Field polymorphicIdField) {
        return "Polymorphic configuration type is not defined: " + polymorphicIdField.getDeclaringClass().getName() + ". See @" + PolymorphicConfig.class.getSimpleName() + " documentation.";
    }

    static {
        try {
            ACCEPT = Consumer.class.getDeclaredMethod("accept", Object.class);
            VISIT_LEAF = ConfigurationVisitor.class.getDeclaredMethod("visitLeafNode", Field.class, String.class, Serializable.class);
            VISIT_INNER = ConfigurationVisitor.class.getDeclaredMethod("visitInnerNode", Field.class, String.class, InnerNode.class);
            VISIT_NAMED = ConfigurationVisitor.class.getDeclaredMethod("visitNamedListNode", Field.class, String.class, NamedListNode.class);
            UNWRAP = ConfigurationSource.class.getDeclaredMethod("unwrap", Class.class);
            DESCEND = ConfigurationSource.class.getDeclaredMethod("descend", ConstructableTreeNode.class);
            INTERNAL_ID = InnerNode.class.getDeclaredMethod("internalId", new Class[0]);
            REQUIRE_NON_NULL = Objects.class.getDeclaredMethod("requireNonNull", Object.class, String.class);
            CLASS_GET_NAME_MTD = Class.class.getDeclaredMethod("getName", new Class[0]);
            STRING_EQUALS_MTD = String.class.getDeclaredMethod("equals", Object.class);
            POLYMORPHIC_TYPE_ID_MTD = ConfigurationSource.class.getDeclaredMethod("polymorphicTypeId", String.class);
            CONSTRUCT_DEFAULT_MTD = InnerNode.class.getDeclaredMethod("constructDefault", String.class);
            SPECIFIC_NODE_MTD = InnerNode.class.getDeclaredMethod("specificNode", new Class[0]);
            ADD_DEFAULTS_MTD = ConfigurationUtil.class.getDeclaredMethod("addDefaults", InnerNode.class);
            SET_INJECTED_NAME_FIELD_VALUE_MTD = InnerNode.class.getDeclaredMethod("setInjectedNameFieldValue", String.class);
            IS_POLYMORPHIC_MTD = InnerNode.class.getDeclaredMethod("isPolymorphic", new Class[0]);
            EXTENSION_SCHEMA_TYPES_MTD = InnerNode.class.getDeclaredMethod("extensionSchemaTypes", new Class[0]);
            ASSERT_MUTABILITY_MTD = InnerNode.class.getDeclaredMethod("assertMutability", new Class[0]);
            GET_DECLARED_FIELD_MTD = Class.class.getDeclaredMethod("getDeclaredField", String.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExceptionInInitializerError(nsme);
        }
    }
}

