/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.compute.ComputeException;
import org.apache.ignite.internal.binarytuple.BinaryTupleBuilder;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.binarytuple.inlineschema.TupleWithSchemaMarshalling;
import org.apache.ignite.internal.client.proto.ClientBinaryTupleUtils;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.ComputeJobDataType;
import org.apache.ignite.internal.compute.PojoConversionException;
import org.apache.ignite.internal.compute.PojoConverter;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.marshalling.MarshallingException;
import org.apache.ignite.marshalling.UnmarshallingException;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.table.Tuple;
import org.jetbrains.annotations.Nullable;

public class SharedComputeUtils {
    private static final Set<Class<?>> NATIVE_TYPES = Arrays.stream(ColumnType.values()).map(ColumnType::javaClass).collect(Collectors.toUnmodifiableSet());

    public static <T> ComputeJobDataHolder marshalArgOrResult(@Nullable T obj, @Nullable Marshaller<T, byte[]> marshaller) {
        return SharedComputeUtils.marshalArgOrResult(obj, marshaller, null);
    }

    public static <T> ComputeJobDataHolder marshalArgOrResult(@Nullable T obj, @Nullable Marshaller<T, byte[]> marshaller, @Nullable Long observableTimestamp) {
        if (obj == null) {
            return new ComputeJobDataHolder(ComputeJobDataType.NATIVE, null, observableTimestamp);
        }
        if (marshaller != null) {
            byte[] data = marshaller.marshal(obj);
            if (data == null) {
                return new ComputeJobDataHolder(ComputeJobDataType.NATIVE, null, observableTimestamp);
            }
            return new ComputeJobDataHolder(ComputeJobDataType.MARSHALLED_CUSTOM, data, observableTimestamp);
        }
        if (obj instanceof Tuple) {
            Tuple tuple = (Tuple)obj;
            return new ComputeJobDataHolder(ComputeJobDataType.TUPLE, TupleWithSchemaMarshalling.marshal(tuple), observableTimestamp);
        }
        if (obj instanceof Collection) {
            Collection col = (Collection)obj;
            BinaryTupleBuilder tupleBuilder = SharedComputeUtils.writeTupleCollection(col);
            ByteBuffer binTupleBytes = tupleBuilder.build();
            byte[] resArr = new byte[4 + binTupleBytes.remaining()];
            ByteBuffer resBuf = ByteBuffer.wrap(resArr).order(ByteOrder.LITTLE_ENDIAN);
            resBuf.putInt(col.size());
            resBuf.put(binTupleBytes);
            return new ComputeJobDataHolder(ComputeJobDataType.TUPLE_COLLECTION, resArr, observableTimestamp);
        }
        if (SharedComputeUtils.isNativeType(obj.getClass())) {
            BinaryTupleBuilder builder = new BinaryTupleBuilder(3, 3, false);
            ClientBinaryTupleUtils.appendObject(builder, obj);
            return new ComputeJobDataHolder(ComputeJobDataType.NATIVE, IgniteUtils.byteBufferToByteArray(builder.build()), observableTimestamp);
        }
        try {
            Tuple tuple = PojoConverter.toTuple(obj);
            return new ComputeJobDataHolder(ComputeJobDataType.POJO, TupleWithSchemaMarshalling.marshal(tuple), observableTimestamp);
        }
        catch (PojoConversionException e) {
            throw new MarshallingException("Can't pack object: " + obj, (Throwable)e);
        }
    }

    @Nullable
    public static <T> T unmarshalArgOrResult(@Nullable ComputeJobDataHolder holder, @Nullable Marshaller<?, byte[]> marshaller, @Nullable Class<?> resultClass) {
        return SharedComputeUtils.unmarshalArgOrResult(holder, marshaller, resultClass, Thread.currentThread().getContextClassLoader());
    }

    @Nullable
    public static <T> T unmarshalArgOrResult(@Nullable ComputeJobDataHolder holder, @Nullable Marshaller<?, byte[]> marshaller, @Nullable Class<?> resultClass, ClassLoader classLoader) {
        if (holder == null || holder.data() == null) {
            return null;
        }
        ComputeJobDataType type = holder.type();
        if (type != ComputeJobDataType.MARSHALLED_CUSTOM && marshaller != null) {
            throw new ComputeException(ErrorGroups.Compute.MARSHALLING_TYPE_MISMATCH_ERR, "Marshaller is defined on the server, but the argument was not marshalled on the client. If you want to use default marshalling strategy, then you should not define your marshaller in the job. If you would like to use your own marshaller, then double-check that both of them are defined in the client and in the server.");
        }
        switch (type) {
            case NATIVE: {
                BinaryTupleReader reader = new BinaryTupleReader(3, holder.data());
                return (T)ClientBinaryTupleUtils.readObject(reader, 0);
            }
            case TUPLE: {
                return (T)TupleWithSchemaMarshalling.unmarshal(holder.data());
            }
            case POJO: {
                if (resultClass == null) {
                    throw new ComputeException(ErrorGroups.Compute.MARSHALLING_TYPE_MISMATCH_ERR, "JobDescriptor.resultClass is not defined, but the job result is packed as a POJO");
                }
                Tuple tuple = TupleWithSchemaMarshalling.unmarshal(holder.data());
                return (T)(resultClass == Tuple.class ? tuple : SharedComputeUtils.unmarshalPojo(resultClass, tuple));
            }
            case MARSHALLED_CUSTOM: {
                if (marshaller == null) {
                    throw new ComputeException(ErrorGroups.Compute.MARSHALLING_TYPE_MISMATCH_ERR, "Marshaller should be defined on the client");
                }
                return SharedComputeUtils.unmarshalData(marshaller, classLoader, holder.data());
            }
            case TUPLE_COLLECTION: {
                return (T)SharedComputeUtils.readTupleCollection(ByteBuffer.wrap(holder.data()).order(ByteOrder.LITTLE_ENDIAN));
            }
        }
        throw new ComputeException(ErrorGroups.Compute.MARSHALLING_TYPE_MISMATCH_ERR, "Unexpected job argument type: " + type);
    }

    public static Object unmarshalPojo(Class<?> pojoType, Tuple input) {
        try {
            Object obj = pojoType.getConstructor(new Class[0]).newInstance(new Object[0]);
            PojoConverter.fromTuple(obj, input);
            return obj;
        }
        catch (NoSuchMethodException e) {
            throw new UnmarshallingException("Class " + pojoType.getName() + " doesn't have public default constructor. Add the constructor or define argument marshaller in the compute job.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new UnmarshallingException("Constructor has thrown an exception", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new UnmarshallingException("Can't instantiate an object of class " + pojoType.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new UnmarshallingException("Constructor is inaccessible", (Throwable)e);
        }
        catch (PojoConversionException e) {
            throw new UnmarshallingException("Can't unpack object", (Throwable)e);
        }
    }

    @Nullable
    public static <T> T unmarshalData(Marshaller<?, byte[]> marshaller, ClassLoader classLoader, byte[] raw) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            Object obj = marshaller.unmarshal(raw);
            return (T)obj;
        }
        catch (Exception ex) {
            throw new ComputeException(ErrorGroups.Compute.MARSHALLING_TYPE_MISMATCH_ERR, "Exception in user-defined marshaller", (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private static boolean isNativeType(Class<?> clazz) {
        return NATIVE_TYPES.contains(clazz);
    }

    private static BinaryTupleBuilder writeTupleCollection(Collection<?> col) {
        BinaryTupleBuilder builder = new BinaryTupleBuilder(col.size());
        for (Object el : col) {
            if (el == null) {
                builder.appendNull();
                continue;
            }
            if (!(el instanceof Tuple)) {
                throw new MarshallingException("Can't pack collection: expected Tuple, but got " + el.getClass(), null);
            }
            builder.appendBytes(TupleWithSchemaMarshalling.marshal((Tuple)el));
        }
        return builder;
    }

    private static List<Tuple> readTupleCollection(ByteBuffer collectionBuf) {
        int count = collectionBuf.getInt();
        BinaryTupleReader reader = new BinaryTupleReader(count, collectionBuf.slice().order(ByteOrder.LITTLE_ENDIAN));
        ArrayList<Tuple> res = new ArrayList<Tuple>(count);
        for (int i = 0; i < count; ++i) {
            ByteBuffer elementBytes = reader.bytesValueAsBuffer(i);
            if (elementBytes == null) {
                res.add(null);
                continue;
            }
            res.add(TupleWithSchemaMarshalling.unmarshal(elementBytes));
        }
        return res;
    }
}

