/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.sql;

import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.table.MutableTupleBinaryTupleAdapter;
import org.apache.ignite.sql.ColumnType;
import org.apache.ignite.sql.ResultSetMetadata;
import org.apache.ignite.sql.SqlRow;
import org.apache.ignite.table.Tuple;

class ClientSqlRow
extends MutableTupleBinaryTupleAdapter
implements SqlRow {
    private final ResultSetMetadata metadata;

    ClientSqlRow(BinaryTupleReader row, ResultSetMetadata meta) {
        super(row, meta.columns().size(), null);
        assert (row != null);
        assert (meta != null);
        this.metadata = meta;
    }

    @Override
    public int columnCount() {
        return this.metadata.columns().size();
    }

    @Override
    public String columnName(int columnIndex) {
        return this.metadata.columns().get(columnIndex).name();
    }

    @Override
    public int columnIndex(String columnName) {
        return this.metadata.indexOf(columnName);
    }

    @Override
    public Tuple set(String columnName, Object value) {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    protected String schemaColumnName(int binaryTupleIndex) {
        return this.columnName(binaryTupleIndex);
    }

    @Override
    protected int binaryTupleIndex(String columnName) {
        return this.columnIndex(columnName);
    }

    @Override
    protected ColumnType schemaColumnType(int binaryTupleIndex) {
        return this.metadata.columns().get(binaryTupleIndex).type();
    }

    @Override
    protected int schemaDecimalScale(int binaryTupleIndex) {
        return this.metadata.columns().get(binaryTupleIndex).scale();
    }

    @Override
    public ResultSetMetadata metadata() {
        return this.metadata;
    }
}

