/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.catalog.ColumnSorted;
import org.apache.ignite.catalog.IndexType;
import org.apache.ignite.catalog.definitions.CacheDefinition;
import org.apache.ignite.catalog.definitions.ColumnDefinition;
import org.apache.ignite.catalog.definitions.IndexDefinition;
import org.apache.ignite.catalog.definitions.TableDefinition;
import org.apache.ignite.catalog.definitions.ZoneDefinition;
import org.apache.ignite.internal.catalog.sql.AbstractCatalogQuery;
import org.apache.ignite.internal.catalog.sql.CreateCacheImpl;
import org.apache.ignite.internal.catalog.sql.CreateDataSource;
import org.apache.ignite.internal.catalog.sql.CreateFromAnnotationsImpl;
import org.apache.ignite.internal.catalog.sql.CreateTableImpl;
import org.apache.ignite.internal.catalog.sql.CreateZoneImpl;
import org.apache.ignite.internal.catalog.sql.DataSourceZoneId;
import org.apache.ignite.internal.catalog.sql.QueryContext;
import org.apache.ignite.internal.catalog.sql.QueryUtils;
import org.apache.ignite.internal.util.StringUtils;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.QualifiedName;
import org.jetbrains.annotations.Nullable;

class CreateFromDefinitionImpl
extends AbstractCatalogQuery<DataSourceZoneId> {
    private CreateZoneImpl createZone;
    private String zoneName;
    private CreateDataSource createDataSource;
    private QualifiedName name;

    CreateFromDefinitionImpl(IgniteSql sql) {
        super(sql);
    }

    @Override
    protected DataSourceZoneId result() {
        return new DataSourceZoneId(this.name, this.zoneName);
    }

    CreateFromDefinitionImpl from(ZoneDefinition def) {
        String zoneName;
        this.createZone = new CreateZoneImpl(this.sql);
        this.zoneName = zoneName = def.zoneName();
        this.createZone.name(zoneName);
        this.createZone.storageProfiles(def.storageProfiles());
        if (def.ifNotExists()) {
            this.createZone.ifNotExists();
        }
        if (QueryUtils.isGreaterThanZero(def.partitions())) {
            this.createZone.partitions(def.partitions());
        }
        if (QueryUtils.isGreaterThanZero(def.replicas())) {
            this.createZone.replicas(def.replicas());
        }
        if (QueryUtils.isGreaterThanZero(def.quorumSize())) {
            this.createZone.quorumSize(def.quorumSize());
        }
        if (!StringUtils.nullOrBlank(def.distributionAlgorithm())) {
            this.createZone.distributionAlgorithm(def.distributionAlgorithm());
        }
        if (QueryUtils.isGreaterThanOrEqualToZero(def.dataNodesAutoAdjustScaleUp())) {
            this.createZone.dataNodesAutoAdjustScaleUp(def.dataNodesAutoAdjustScaleUp());
        }
        if (QueryUtils.isGreaterThanOrEqualToZero(def.dataNodesAutoAdjustScaleDown())) {
            this.createZone.dataNodesAutoAdjustScaleDown(def.dataNodesAutoAdjustScaleDown());
        }
        if (!StringUtils.nullOrBlank(def.filter())) {
            this.createZone.filter(def.filter());
        }
        if (!StringUtils.nullOrBlank(def.consistencyMode())) {
            this.createZone.consistencyMode(def.consistencyMode());
        }
        return this;
    }

    CreateFromDefinitionImpl from(TableDefinition def) {
        this.createDataSource = new CreateTableImpl(this.sql);
        return this.from(def.qualifiedName(), def.ifNotExists(), def.columns(), def.primaryKeyType(), def.primaryKeyColumns(), def.colocationColumns(), def.zoneName(), def.keyClass(), def.valueClass(), def.indexes());
    }

    CreateFromDefinitionImpl from(CacheDefinition def) {
        this.createDataSource = new CreateCacheImpl(this.sql);
        return this.from(def.qualifiedName(), def.ifNotExists(), def.columns(), def.primaryKeyType(), def.primaryKeyColumns(), def.colocationColumns(), def.zoneName(), def.keyClass(), def.valueClass(), def.indexes());
    }

    CreateFromDefinitionImpl from(QualifiedName qualifiedName, boolean ifNotExists, @Nullable List<ColumnDefinition> columns, @Nullable IndexType primaryKeyType, @Nullable List<ColumnSorted> pkColumns, @Nullable List<String> colocationColumns, @Nullable String zoneName, @Nullable Class<?> keyClass, @Nullable Class<?> valueClass, @Nullable List<IndexDefinition> indexes) {
        IndexType pkType;
        this.name = qualifiedName;
        this.createDataSource.name(qualifiedName);
        if (ifNotExists) {
            this.createDataSource.ifNotExists();
        }
        if (!CreateFromDefinitionImpl.nullOrEmpty(colocationColumns)) {
            this.createDataSource.colocateBy(colocationColumns);
        }
        if (zoneName != null) {
            this.createDataSource.zone(zoneName);
        }
        IndexType indexType = pkType = primaryKeyType == null ? IndexType.DEFAULT : primaryKeyType;
        if (keyClass != null) {
            CreateFromAnnotationsImpl.processColumns(pkType, keyClass, true, this.createDataSource);
            if (valueClass != null) {
                CreateFromAnnotationsImpl.processColumns(pkType, valueClass, false, this.createDataSource);
            }
        } else {
            if (columns != null) {
                for (ColumnDefinition column : columns) {
                    if (column.type() != null) {
                        this.createDataSource.addColumn(column.name(), column.type());
                        continue;
                    }
                    if (column.definition() == null) continue;
                    this.createDataSource.addColumn(column.name(), column.definition());
                }
            }
            if (!CreateFromDefinitionImpl.nullOrEmpty(pkColumns)) {
                this.createDataSource.primaryKey(pkType, pkColumns);
            }
        }
        if (indexes != null) {
            for (IndexDefinition ix : indexes) {
                this.createDataSource.addIndex(CreateFromDefinitionImpl.toIndexName(ix), ix.type(), ix.columns());
            }
        }
        return this;
    }

    @Override
    protected void accept(QueryContext ctx) {
        if (this.createZone != null) {
            ctx.visit(this.createZone).formatSeparator();
        }
        if (this.createDataSource != null) {
            ctx.visit(this.createDataSource).formatSeparator();
        }
    }

    private static String toIndexName(IndexDefinition ix) {
        if (!StringUtils.nullOrEmpty(ix.name())) {
            return ix.name();
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("ix");
        for (ColumnSorted col : ix.columns()) {
            list.add(col.columnName());
        }
        return String.join((CharSequence)"_", list);
    }

    private static boolean nullOrEmpty(@Nullable Collection<?> c) {
        return c == null || c.isEmpty();
    }
}

