/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.app;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteServer;
import org.apache.ignite.InitParameters;
import org.apache.ignite.internal.app.IgniteImpl;
import org.apache.ignite.internal.eventlog.api.IgniteEventType;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.properties.IgniteProperties;
import org.apache.ignite.internal.restart.IgniteAttachmentLock;
import org.apache.ignite.internal.restart.RestartProofIgnite;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ClusterInitFailureException;
import org.apache.ignite.lang.ClusterNotInitializedException;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.NodeNotStartedException;
import org.apache.ignite.lang.NodeStartException;
import org.gridgain.internal.eventlog.api.GridGainEventType;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class IgniteServerImpl
implements IgniteServer {
    private static final IgniteLogger LOG = Loggers.forClass(IgniteServerImpl.class);
    private static final String[] BANNER = new String[]{"", "  _________        _____ __________________        _____", "  __  ____/___________(_)______  /__  ____/______ ____(_)_______", "  _  / __  __  ___/__  / _  __  / _  / __  _  __ `/__  / __  __ \\", "  / /_/ /  _  /    _  /  / /_/ /  / /_/ /  / /_/ / _  /  _  / / /", "  \\____/   /_/     /_/   \\_,__/   \\____/   \\__,_/  /_/   /_/ /_/"};
    private final String nodeName;
    private final Path configPath;
    private final Path workDir;
    private final ClassLoader classLoader;
    private final Executor asyncContinuationExecutor;
    @Nullable
    private volatile IgniteImpl ignite;
    private final IgniteAttachmentLock attachmentLock;
    private final Ignite publicIgnite;
    @Nullable
    private volatile CompletableFuture<Void> joinFuture;
    private final Object igniteChangeMutex = new Object();
    private final Object restartOrShutdownMutex = new Object();
    @Nullable
    private CompletableFuture<Void> restartOrShutdownFuture;
    @Nullable
    private CompletableFuture<Void> restartFuture;
    private volatile boolean shutDown;

    public IgniteServerImpl(String nodeName, Path configPath, Path workDir, @Nullable ClassLoader classLoader, Executor asyncContinuationExecutor) {
        if (nodeName == null) {
            throw new NodeStartException("Node name must not be null");
        }
        if (nodeName.isEmpty()) {
            throw new NodeStartException("Node name must not be empty.");
        }
        if (configPath == null) {
            throw new NodeStartException("Config path must not be null");
        }
        if (Files.notExists(configPath, new LinkOption[0])) {
            throw new NodeStartException("Config file doesn't exist");
        }
        if (workDir == null) {
            throw new NodeStartException("Working directory must not be null");
        }
        if (asyncContinuationExecutor == null) {
            throw new NodeStartException("Async continuation executor must not be null");
        }
        this.nodeName = nodeName;
        this.configPath = configPath;
        this.workDir = workDir;
        this.classLoader = classLoader;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
        this.attachmentLock = new IgniteAttachmentLock(() -> this.ignite, asyncContinuationExecutor);
        this.publicIgnite = new RestartProofIgnite(this.attachmentLock);
    }

    @Override
    public Ignite api() {
        IgniteImpl instance = this.ignite;
        if (instance == null) {
            throw new NodeNotStartedException();
        }
        this.throwIfNotJoined();
        return this.publicIgnite;
    }

    private void throwIfNotJoined() {
        CompletableFuture<Void> joinFuture = this.joinFuture;
        if (joinFuture == null || !joinFuture.isDone()) {
            throw new ClusterNotInitializedException();
        }
        if (joinFuture.isCancelled()) {
            throw new ClusterInitFailureException("Cluster initialization cancelled.");
        }
        if (joinFuture.isCompletedExceptionally()) {
            throw new ClusterInitFailureException("Cluster initialization failed.", (Throwable)((CompletableFuture)joinFuture.handle((res, ex) -> ex)).join());
        }
    }

    @Override
    public CompletableFuture<Void> initClusterAsync(InitParameters parameters) {
        IgniteImpl instance = this.ignite;
        if (instance == null) {
            throw new NodeNotStartedException();
        }
        try {
            return instance.initClusterAsync(parameters.metaStorageNodeNames(), parameters.cmgNodeNames(), parameters.clusterName(), parameters.clusterConfiguration(), parameters.license()).thenCompose(unused -> this.waitForInitAsync());
        }
        catch (NodeStoppingException e) {
            throw new ClusterInitFailureException("Node stop detected during init", (Throwable)e);
        }
    }

    @Override
    public void initCluster(InitParameters parameters) {
        IgniteServerImpl.sync(this.initClusterAsync(parameters));
    }

    @Override
    public CompletableFuture<Void> waitForInitAsync() {
        CompletableFuture<Void> joinFuture = this.joinFuture;
        if (joinFuture == null) {
            throw new NodeNotStartedException();
        }
        return joinFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> restartAsync() {
        CompletableFuture<Void> result;
        Object object = this.restartOrShutdownMutex;
        synchronized (object) {
            if (this.shutDown) {
                throw new NodeNotStartedException();
            }
            IgniteImpl instance = this.ignite;
            if (instance == null) {
                throw new NodeNotStartedException();
            }
            result = this.chainRestartOrShutdownAction(() -> this.doRestartAsync(instance));
            this.restartFuture = result;
        }
        return result;
    }

    private CompletableFuture<Void> chainRestartOrShutdownAction(Supplier<CompletableFuture<Void>> action) {
        CompletionStage result = ((CompletableFuture)(this.restartOrShutdownFuture == null ? CompletableFutures.nullCompletedFuture() : this.restartOrShutdownFuture).handle((res, ex) -> null)).thenCompose(unused -> (CompletionStage)action.get());
        this.restartOrShutdownFuture = result;
        return result;
    }

    private CompletableFuture<Void> doRestartAsync(IgniteImpl instance) {
        return this.attachmentLock.detachedAsync(() -> {
            Object object = this.igniteChangeMutex;
            synchronized (object) {
                LOG.info("Setting Ignite ref to null as restart is initiated [name={}]", this.nodeName);
                this.ignite = null;
            }
            this.joinFuture = null;
            return ((CompletableFuture)instance.stopAsync().thenCompose(unused -> this.doStartAsync())).thenCompose(unused -> this.waitForInitAsync());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> shutdownAsync() {
        CompletableFuture<Void> result;
        Object object = this.restartOrShutdownMutex;
        synchronized (object) {
            if (this.shutDown) {
                return Objects.requireNonNull(this.restartOrShutdownFuture);
            }
            this.shutDown = true;
            result = this.chainRestartOrShutdownAction(this::doShutdownAsync);
        }
        this.triggerStopOnCurrentIgnite();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerStopOnCurrentIgnite() {
        IgniteImpl currentIgnite;
        Object object = this.igniteChangeMutex;
        synchronized (object) {
            currentIgnite = this.ignite;
        }
        if (currentIgnite != null) {
            currentIgnite.stopAsync();
        }
    }

    private CompletableFuture<Void> doShutdownAsync() {
        IgniteImpl instance = this.ignite;
        if (instance != null) {
            try {
                return instance.stopAsync().thenRun(() -> {
                    Object object = this.igniteChangeMutex;
                    synchronized (object) {
                        LOG.info("Setting Ignite ref to null as shutdown is completed [name={}]", this.nodeName);
                        this.ignite = null;
                    }
                    this.joinFuture = null;
                });
            }
            catch (Exception e) {
                throw new IgniteException(ErrorGroups.Common.NODE_STOPPING_ERR, (Throwable)e);
            }
        }
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public void shutdown() {
        IgniteServerImpl.sync(this.shutdownAsync());
    }

    @Override
    public String name() {
        return this.nodeName;
    }

    @Override
    public CompletableFuture<Void> startAsync() {
        if (this.ignite != null) {
            throw new NodeStartException("Node is already started.");
        }
        return this.attachmentLock.detachedAsync(this::doStartAsync);
    }

    private CompletableFuture<Void> doStartAsync() {
        if (this.shutDown) {
            return CompletableFuture.failedFuture(new NodeNotStartedException());
        }
        IgniteImpl instance = new IgniteImpl(this, this::restartAsync, this.configPath, this.workDir, this.classLoader, this.asyncContinuationExecutor);
        IgniteServerImpl.ackBanner();
        IgniteServerImpl.logAvailableResources();
        IgniteServerImpl.logOsInfo();
        IgniteServerImpl.logVmInfo();
        IgniteServerImpl.ackRemoteManagement();
        return instance.startAsync().thenCompose(unused -> {
            Object object = this.igniteChangeMutex;
            synchronized (object) {
                if (this.shutDown) {
                    LOG.info("A new Ignite instance has started, but a shutdown is requested, so not setting it, stopping it instead [name={}]", this.nodeName);
                    return instance.stopAsync();
                }
                LOG.info("Initiating join process [name={}]", this.nodeName);
                this.doWaitForInitAsync(instance);
                LOG.info("Setting Ignite ref to new instance as it has started [name={}]", this.nodeName);
                this.ignite = instance;
            }
            return CompletableFutures.nullCompletedFuture();
        });
    }

    private void doWaitForInitAsync(IgniteImpl instance) {
        try {
            this.joinFuture = instance.joinClusterAsync().handle((ignite, e) -> {
                if (e == null) {
                    IgniteServerImpl.ackSuccessStart();
                    return null;
                }
                throw IgniteServerImpl.handleStartException(e);
            });
        }
        catch (Exception e2) {
            throw IgniteServerImpl.handleStartException(e2);
        }
    }

    @Override
    public void start() {
        IgniteServerImpl.sync(this.startAsync());
    }

    private static IgniteException handleStartException(Throwable e) {
        if (e instanceof IgniteException) {
            return (IgniteException)e;
        }
        return new NodeStartException("Error during node start.", e);
    }

    private static void ackSuccessStart() {
        LOG.info("GridGain started successfully!", new Object[0]);
    }

    private static void ackBanner() {
        String banner = String.join((CharSequence)System.lineSeparator(), BANNER);
        String padding = " ".repeat(22);
        String version = IgniteProperties.get("ignite.version");
        String commitHash = IgniteProperties.get("ignite.release.commit");
        LOG.info("{}" + System.lineSeparator() + "{}{}" + System.lineSeparator(), banner, padding, "GridGain version " + version + "-sha1:" + commitHash);
    }

    private static void logAvailableResources() {
        LOG.info("Available processors: {}", Runtime.getRuntime().availableProcessors());
        LOG.info("Max heap: {}", Runtime.getRuntime().maxMemory());
    }

    private static void logOsInfo() {
        Long jvmPid = null;
        try {
            jvmPid = ProcessHandle.current().pid();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        String osUser = System.getProperty("user.name");
        LOG.info("OS: [name={}, version={}, arch={}, user={}, pid={}]", osName, osVersion, osArch, osUser, jvmPid == null ? "N/A" : jvmPid);
    }

    private static void logVmInfo() {
        String jreName = System.getProperty("java.runtime.name");
        String jreVersion = System.getProperty("java.runtime.version");
        String jvmVendor = System.getProperty("java.vm.vendor");
        String jvmName = System.getProperty("java.vm.name");
        String jvmVersion = System.getProperty("java.vm.version");
        LOG.info("VM: [jreName={}, jreVersion={}, jvmVendor={}, jvmName={}, jvmVersion={}]", jreName, jreVersion, jvmVendor, jvmName, jvmVersion);
    }

    private static void ackRemoteManagement() {
        if (LOG.isInfoEnabled()) {
            boolean jmxEnabled;
            boolean bl = jmxEnabled = System.getProperty("com.sun.management.jmxremote") != null;
            if (jmxEnabled) {
                String jmxMessage = "Remote management[JMX (remote: on, port: {}, auth: {}, ssl: {})]";
                String port = System.getProperty("com.sun.management.jmxremote.port", "<n/a>");
                boolean authEnabled = Boolean.getBoolean("com.sun.management.jmxremote.authenticate");
                boolean sslEnabled = Boolean.getBoolean("com.sun.management.jmxremote.ssl") || System.getProperty("com.sun.management.jmxremote.ssl") == null;
                LOG.info(IgniteStringFormatter.format(jmxMessage, port, IgniteServerImpl.onOff(authEnabled), IgniteServerImpl.onOff(sslEnabled)), new Object[0]);
            } else {
                LOG.info("Remote management[JMX (remote: off)]", new Object[0]);
            }
        }
    }

    private static String onOff(boolean b) {
        return b ? "on" : "off";
    }

    private static void sync(CompletableFuture<Void> future) {
        try {
            future.get();
        }
        catch (ExecutionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(IgniteServerImpl.tryToCopyExceptionWithCause(e));
        }
        catch (InterruptedException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(e);
        }
    }

    private static Throwable tryToCopyExceptionWithCause(ExecutionException exception) {
        Throwable copy = ExceptionUtils.copyExceptionWithCause(exception);
        if (copy == null) {
            return new IgniteException(ErrorGroups.Common.INTERNAL_ERR, "Cannot make a proper copy of " + exception.getCause().getClass(), (Throwable)exception);
        }
        return copy;
    }

    @TestOnly
    public IgniteImpl igniteImpl() {
        IgniteImpl instance = this.ignite;
        if (instance == null) {
            throw new NodeNotStartedException();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    @Nullable
    public CompletableFuture<Void> restartFuture() {
        Object object = this.restartOrShutdownMutex;
        synchronized (object) {
            return this.restartFuture;
        }
    }

    @TestOnly
    public Path workDir() {
        return this.workDir;
    }

    static {
        ErrorGroups.initialize();
        IgniteEventType.initialize();
        GridgainErrorGroups.initialize();
        GridGainEventType.initialize();
    }
}

