/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache;

public enum CacheWriteMode {
    SYNC,
    ASYNC;

    private static final CacheWriteMode[] VALS;

    public static CacheWriteMode fromOrdinal(int ordinal) {
        if (ordinal < 0 || ordinal >= VALS.length) {
            throw new IllegalArgumentException("Unexpected write mode id: " + ordinal);
        }
        return VALS[ordinal];
    }

    public static CacheWriteMode fromString(String name) {
        for (CacheWriteMode v : VALS) {
            if (!v.name().equalsIgnoreCase(name)) continue;
            return v;
        }
        throw new IllegalArgumentException("Unexpected write mode name: '" + name + "'");
    }

    static {
        VALS = CacheWriteMode.values();
    }
}

