/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.transport.api;

import io.scalecube.cluster.transport.api.Message;
import io.scalecube.cluster.transport.api.TransportConfig;
import io.scalecube.net.Address;
import java.util.Objects;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface Transport {
    public Address address();

    public Mono<Transport> start();

    public Mono<Void> stop();

    public boolean isStopped();

    public Mono<Void> send(Address var1, Message var2);

    public Mono<Message> requestResponse(Address var1, Message var2);

    public Flux<Message> listen();

    public static Transport bindAwait() {
        return Transport.bindAwait(TransportConfig.defaultConfig());
    }

    public static Transport bindAwait(TransportConfig config) {
        try {
            return Transport.bind(config).block();
        }
        catch (Exception e) {
            throw Exceptions.propagate(e.getCause() != null ? e.getCause() : e);
        }
    }

    public static Mono<Transport> bind() {
        return Transport.bind(TransportConfig.defaultConfig());
    }

    public static Mono<Transport> bind(TransportConfig config) {
        Objects.requireNonNull(config.transportFactory(), "[bind] transportFactory");
        return config.transportFactory().createTransport(config).start();
    }
}

