/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster;

import io.scalecube.net.Address;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.UUID;

public final class Member
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String alias;
    private Address address;
    private String namespace;

    public Member() {
    }

    public Member(String id, String alias, Address address, String namespace) {
        this.id = Objects.requireNonNull(id, "member id");
        this.alias = alias;
        this.address = Objects.requireNonNull(address, "member address");
        this.namespace = Objects.requireNonNull(namespace, "member namespace");
    }

    public String id() {
        return this.id;
    }

    public String alias() {
        return this.alias;
    }

    public String namespace() {
        return this.namespace;
    }

    public Address address() {
        return this.address;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Member member = (Member)that;
        return Objects.equals(this.id, member.id) && Objects.equals(this.address, member.address) && Objects.equals(this.namespace, member.namespace);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.address, this.namespace);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        boolean aliasNotNull = this.alias != null;
        out.writeBoolean(aliasNotNull);
        if (aliasNotNull) {
            out.writeUTF(this.alias);
        }
        out.writeUTF(this.address.toString());
        out.writeUTF(this.namespace);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.id = in.readUTF();
        boolean aliasNotNull = in.readBoolean();
        if (aliasNotNull) {
            this.alias = in.readUTF();
        }
        this.address = Address.from(in.readUTF());
        this.namespace = in.readUTF();
    }

    private static String stringifyId(String id) {
        try {
            UUID uuid = UUID.fromString(id);
            return Long.toHexString(uuid.getMostSignificantBits() & Long.MAX_VALUE);
        }
        catch (Exception ex) {
            return id;
        }
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner(":");
        if (this.alias == null) {
            return stringJoiner.add(this.namespace).add(Member.stringifyId(this.id) + "@" + this.address).toString();
        }
        return stringJoiner.add(this.namespace).add(this.alias).add(Member.stringifyId(this.id) + "@" + this.address).toString();
    }
}

