/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import com.facebook.presto.bytecode.BytecodeUtils;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.debug.LocalVariableNode;
import com.facebook.presto.bytecode.instruction.LabelNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MethodGenerationContext {
    private final MethodVisitor methodVisitor;
    private final Set<Scope> allEnteredScopes = new LinkedHashSet<Scope>();
    private final Deque<ScopeContext> scopes = new ArrayDeque<ScopeContext>();
    private final Map<Variable, Integer> variableSlots = new HashMap<Variable, Integer>();
    private int nextSlot;
    private int currentLineNumber = -1;

    public MethodGenerationContext(MethodVisitor methodVisitor) {
        this.methodVisitor = Objects.requireNonNull(methodVisitor, "methodVisitor is null");
    }

    public void enterScope(Scope scope) {
        Objects.requireNonNull(scope, "scope is null");
        BytecodeUtils.checkArgument(!this.allEnteredScopes.contains(scope), "scope has already been entered", new Object[0]);
        this.allEnteredScopes.add(scope);
        ScopeContext scopeContext = new ScopeContext(scope);
        this.scopes.addLast(scopeContext);
        for (Variable variable : scopeContext.getVariables()) {
            BytecodeUtils.checkArgument(!"this".equals(variable.getName()) || this.nextSlot == 0, "The 'this' variable must be in slot 0", new Object[0]);
            this.variableSlots.put(variable, this.nextSlot);
            this.nextSlot += Type.getType(variable.getType().getType()).getSize();
        }
        scopeContext.getStartLabel().accept(this.methodVisitor, this);
    }

    public void exitScope(Scope scope) {
        BytecodeUtils.checkArgument(this.allEnteredScopes.contains(scope), "scope has not been entered", new Object[0]);
        BytecodeUtils.checkArgument(!this.scopes.isEmpty() && scope == this.scopes.peekLast().getScope(), "Scope is not top of the stack", new Object[0]);
        ScopeContext scopeContext = this.scopes.removeLast();
        scopeContext.getEndLabel().accept(this.methodVisitor, this);
        for (Variable variable : scopeContext.getVariables()) {
            new LocalVariableNode(variable, scopeContext.getStartLabel(), scopeContext.getEndLabel()).accept(this.methodVisitor, this);
        }
        this.variableSlots.keySet().removeAll(scopeContext.getVariables());
    }

    public int getVariableSlot(Variable variable) {
        Integer slot = this.variableSlots.get(variable);
        BytecodeUtils.checkArgument(slot != null, "Variable '%s' has not been assigned a slot", variable);
        return slot;
    }

    public boolean updateLineNumber(int lineNumber) {
        if (lineNumber == this.currentLineNumber) {
            return false;
        }
        this.currentLineNumber = lineNumber;
        return true;
    }

    private static final class ScopeContext {
        private final Scope scope;
        private final List<Variable> variables;
        private final LabelNode startLabel = new LabelNode("VariableStart");
        private final LabelNode endLabel = new LabelNode("VariableEnd");

        ScopeContext(Scope scope) {
            this.scope = scope;
            this.variables = List.copyOf(scope.getVariables());
        }

        public Scope getScope() {
            return this.scope;
        }

        public List<Variable> getVariables() {
            return this.variables;
        }

        public LabelNode getStartLabel() {
            return this.startLabel;
        }

        public LabelNode getEndLabel() {
            return this.endLabel;
        }
    }
}

