/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.bytecode;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class AddFakeLineNumberClassVisitor
extends ClassVisitor {
    int methodCount;

    AddFakeLineNumberClassVisitor(ClassVisitor cv) {
        super(327680, cv);
        super.visitSource("FakeSource.java", null);
    }

    @Override
    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor methodVisitor = this.cv.visitMethod(access, name, desc, signature, exceptions);
        ++this.methodCount;
        return new AddFakeLineNumberMethodVisitor(methodVisitor, 1000 * this.methodCount);
    }

    private static class AddFakeLineNumberMethodVisitor
    extends MethodVisitor {
        private int count;

        AddFakeLineNumberMethodVisitor(MethodVisitor mv, int startLineNumber) {
            super(327680, mv);
            this.count = startLineNumber;
        }

        private void addFakeLineNumber() {
            Label label = new Label();
            this.mv.visitLabel(label);
            this.mv.visitLineNumber(++this.count, label);
        }

        @Override
        public void visitInsn(int opcode) {
            this.addFakeLineNumber();
            super.visitInsn(opcode);
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            this.addFakeLineNumber();
            super.visitIntInsn(opcode, operand);
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            this.addFakeLineNumber();
            super.visitVarInsn(opcode, var);
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            this.addFakeLineNumber();
            super.visitTypeInsn(opcode, type);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.addFakeLineNumber();
            super.visitFieldInsn(opcode, owner, name, desc);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            this.addFakeLineNumber();
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            this.addFakeLineNumber();
            super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            this.addFakeLineNumber();
            super.visitJumpInsn(opcode, label);
        }

        @Override
        public void visitLdcInsn(Object cst) {
            this.addFakeLineNumber();
            super.visitLdcInsn(cst);
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            this.addFakeLineNumber();
            super.visitIincInsn(var, increment);
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            this.addFakeLineNumber();
            super.visitTableSwitchInsn(min, max, dflt, labels);
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.addFakeLineNumber();
            super.visitLookupSwitchInsn(dflt, keys, labels);
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.addFakeLineNumber();
            super.visitMultiANewArrayInsn(desc, dims);
        }
    }
}

