/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.metrics;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.gridgain.internal.dr.metrics.DrBatchEventListener;
import org.gridgain.internal.dr.metrics.DrReceiverCacheMetricsMxBean;

public class DrReceiverCacheMetricsMxBeanImpl
implements DrReceiverCacheMetricsMxBean,
DrBatchEventListener {
    private final AtomicInteger batchesReceived = new AtomicInteger();
    private final AtomicLong entriesReceived = new AtomicLong();
    private final AtomicLong bytesReceived = new AtomicLong();
    private final AtomicLong messageQueueSize = new AtomicLong();
    private final AtomicInteger messageQueueLength = new AtomicInteger();
    private final DrBatchEventListener parent;

    DrReceiverCacheMetricsMxBeanImpl(DrBatchEventListener parent) {
        this.parent = parent;
    }

    @Override
    public int getBatchesReceived() {
        return this.batchesReceived.get();
    }

    @Override
    public long getEntriesReceived() {
        return this.entriesReceived.get();
    }

    @Override
    public long getBytesReceived() {
        return this.bytesReceived.get();
    }

    @Override
    public long getMessageQueueSizeBytes() {
        return this.messageQueueSize.get();
    }

    @Override
    public long getMessageQueueLength() {
        return this.messageQueueLength.get();
    }

    @Override
    public void onReceived(int entriesCnt, int bytesCnt) {
        this.batchesReceived.incrementAndGet();
        this.entriesReceived.addAndGet(entriesCnt);
        this.bytesReceived.addAndGet(bytesCnt);
        this.messageQueueLength.incrementAndGet();
        this.messageQueueSize.addAndGet(bytesCnt);
        this.parent.onReceived(entriesCnt, bytesCnt);
    }

    @Override
    public void onProcessed(long messageSize) {
        this.messageQueueLength.decrementAndGet();
        this.messageQueueSize.addAndGet(-messageSize);
        this.parent.onProcessed(messageSize);
    }
}

