/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.binary;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.UUID;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.gridgain.internal.dr.MarshallerContext;
import org.gridgain.internal.dr.binary.BinaryContext;
import org.gridgain.internal.dr.binary.BinaryMetadata;
import org.gridgain.internal.dr.binary.BinaryObject;
import org.gridgain.internal.dr.binary.BinaryObjectException;
import org.gridgain.internal.dr.binary.BinaryPrimitives;
import org.gridgain.internal.dr.binary.BinarySchema;
import org.gridgain.internal.dr.common.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public final class BinaryUtils {
    public static final byte PROTO_VER = 1;
    public static final int PROTO_VER_POS = 1;
    public static final int FLAGS_POS = 2;
    public static final int TYPE_ID_POS = 4;
    public static final int HASH_CODE_POS = 8;
    public static final int TOTAL_LEN_POS = 12;
    public static final int SCHEMA_ID_POS = 16;
    public static final int SCHEMA_OR_RAW_OFF_POS = 20;
    public static final byte HEADER_LEN = 24;
    public static final int FIELD_ID_LEN = 4;
    public static final int OFFSET_1 = 1;
    public static final int OFFSET_2 = 2;
    public static final int OFFSET_4 = 4;

    public static boolean isFlagSet(short flags, short flag) {
        return (flags & flag) == flag;
    }

    public static boolean hasSchema(short flags) {
        return BinaryUtils.isFlagSet(flags, (short)2);
    }

    public static boolean hasRaw(short flags) {
        return BinaryUtils.isFlagSet(flags, (short)4);
    }

    public static boolean isCompactFooter(short flags) {
        return BinaryUtils.isFlagSet(flags, (short)32);
    }

    public static int fieldIdLength(short flags) {
        return BinaryUtils.isCompactFooter(flags) ? 0 : 4;
    }

    public static int fieldOffsetLength(short flags) {
        if ((flags & 8) == 8) {
            return 1;
        }
        if ((flags & 0x10) == 16) {
            return 2;
        }
        return 4;
    }

    public static int typeId(String clsName) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public static void checkProtocolVersion(byte protoVer) {
        if (1 != protoVer) {
            throw new BinaryObjectException("Unsupported protocol version: " + protoVer);
        }
    }

    public static BinarySchema getOrCreateSchema(BinaryContext ctx, BinaryObject binaryObject) {
        int schemaId;
        int typeId = binaryObject.typeId();
        BinarySchema schema = ctx.schema(typeId, schemaId = binaryObject.schemaId());
        if (schema != null) {
            return schema;
        }
        BinaryMetadata meta = ctx.binaryMetadata(typeId);
        if (meta == null) {
            throw new BinaryObjectException(IgniteStringFormatter.format("Cannot find metadata for object: [typeId={}, schemaId={}", typeId, schemaId));
        }
        if (binaryObject.isFlagSet((short)32)) {
            throw new BinaryObjectException(IgniteStringFormatter.format("Cannot find schema for object with compact footer [typeName={}, typeId={}, missingSchemaId={}, existingSchemaIds={}]", meta.typeName(), typeId, schemaId, ctx.binarySchemas(typeId)));
        }
        if (!binaryObject.hasSchema()) {
            throw new BinaryObjectException(IgniteStringFormatter.format("Cannot find schema for object [typeName={}, typeId={}, missingSchemaId={}, existingSchemaIds={}]", meta.typeName(), typeId, schemaId, ctx.binarySchemas(typeId)));
        }
        schema = binaryObject.readSchema();
        ctx.registerBinarySchema(typeId, schema);
        return schema;
    }

    @Nullable
    static <T> T unmarshal(MarshallerContext ctx, byte[] arr, int start) {
        Object val;
        byte type = BinaryPrimitives.readByte(arr, start);
        switch (type) {
            case 101: {
                return null;
            }
            case 8: {
                val = BinaryPrimitives.readBoolean(arr, start + 1);
                break;
            }
            case 1: {
                val = BinaryPrimitives.readByte(arr, start + 1);
                break;
            }
            case 2: {
                val = BinaryPrimitives.readShort(arr, start + 1);
                break;
            }
            case 3: {
                val = BinaryPrimitives.readInt(arr, start + 1);
                break;
            }
            case 4: {
                val = BinaryPrimitives.readLong(arr, start + 1);
                break;
            }
            case 5: {
                val = BinaryPrimitives.readFloat(arr, start + 1);
                break;
            }
            case 6: {
                val = BinaryPrimitives.readDouble(arr, start + 1);
                break;
            }
            case 30: {
                boolean negative;
                int scale = BinaryPrimitives.readInt(arr, start + 1);
                int dataLen = BinaryPrimitives.readInt(arr, start + 5);
                byte[] data = BinaryPrimitives.readByteArray(arr, start + 9, dataLen);
                boolean bl = negative = data[0] < 0;
                if (negative) {
                    data[0] = (byte)(data[0] & 0x7F);
                }
                BigInteger intVal = new BigInteger(data);
                if (negative) {
                    intVal = intVal.negate();
                }
                val = new BigDecimal(intVal, scale);
                break;
            }
            case 7: {
                val = BinaryPrimitives.readChar(arr, start + 1);
                break;
            }
            case 9: {
                int dataLen = BinaryPrimitives.readInt(arr, start + 1);
                val = new String(arr, start + 5, dataLen, StandardCharsets.UTF_8);
                break;
            }
            case 11: {
                long time = BinaryPrimitives.readLong(arr, start + 1);
                val = new Date(time);
                break;
            }
            case 36: {
                long time = BinaryPrimitives.readLong(arr, start + 1);
                val = new Time(time);
                break;
            }
            case 33: {
                long time = BinaryPrimitives.readLong(arr, start + 1);
                int nanos = BinaryPrimitives.readInt(arr, start + 1 + 8);
                Timestamp ts = new Timestamp(time);
                ts.setNanos(ts.getNanos() + nanos);
                val = ts;
                break;
            }
            case 10: {
                long most = BinaryPrimitives.readLong(arr, start + 1);
                long least = BinaryPrimitives.readLong(arr, start + 1 + 8);
                val = new UUID(most, least);
                break;
            }
            case 103: {
                BinaryUtils.checkProtocolVersion(BinaryPrimitives.readByte(arr, start + 1));
                short flags = BinaryPrimitives.readShort(arr, start + 2);
                int typeId0 = BinaryPrimitives.readInt(arr, start + 4);
                boolean userType = BinaryUtils.isFlagSet(flags, (short)1);
                if (userType || typeId0 == 0) {
                    throw new IllegalStateException("User type is not supported: typeId=" + typeId0);
                }
                int dataStart = start + 24;
                val = BinaryUtils.readSystemObject(arr, dataStart, typeId0);
                break;
            }
            case 12: {
                int len = BinaryPrimitives.readInt(arr, start + 1);
                val = BinaryPrimitives.readByteArray(arr, start + 1 + 4, len);
                break;
            }
            case 27: {
                int len = BinaryPrimitives.readInt(arr, start + 1);
                byte[] slice = BinaryPrimitives.readByteArray(arr, start + 1 + 4, len);
                int start0 = BinaryPrimitives.readInt(arr, start + 1 + 4 + len);
                val = new BinaryObject(ctx, slice, start0);
                break;
            }
            case -2: {
                int len = BinaryPrimitives.readInt(arr, start + 1);
                val = ctx.optimizedMarshaller().readOptimized(arr, start + 1 + 4, len);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported type: " + type);
            }
        }
        return (T)val;
    }

    private static Object readSystemObject(byte[] arr, int off, int typeId) {
        switch (typeId) {
            case 63: {
                long local = BinaryPrimitives.readLong(arr, off);
                long most = BinaryPrimitives.readLong(arr, off + 8);
                long least = BinaryPrimitives.readLong(arr, off + 8 + 8);
                IgniteUuid val = new IgniteUuid(new UUID(most, least), local);
                return val;
            }
        }
        throw new IllegalStateException("Object of system type is not supported yet: typeId=" + typeId);
    }

    private BinaryUtils() {
    }

    public static class Flags {
        public static final short FLAG_USR_TYP = 1;
        public static final short FLAG_HAS_SCHEMA = 2;
        public static final short FLAG_HAS_RAW = 4;
        public static final short FLAG_OFFSET_ONE_BYTE = 8;
        public static final short FLAG_OFFSET_TWO_BYTES = 16;
        public static final short FLAG_COMPACT_FOOTER = 32;
        public static final short FLAG_CUSTOM_DOTNET_TYPE = 64;
    }
}

