/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.lang.AsyncCursor;
import org.apache.ignite.lang.Cursor;
import org.apache.ignite.table.ContinuousQueryOptions;
import org.apache.ignite.table.DataStreamerItem;
import org.apache.ignite.table.DataStreamerOptions;
import org.apache.ignite.table.DataStreamerReceiverDescriptor;
import org.apache.ignite.table.ReceiverDescriptor;
import org.apache.ignite.table.RecordView;
import org.apache.ignite.table.TableRowEventBatch;
import org.apache.ignite.table.criteria.Criteria;
import org.apache.ignite.table.criteria.CriteriaQueryOptions;
import org.apache.ignite.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class CloseableRecordView<R>
implements RecordView<R>,
Closeable,
Wrapper {
    private final RecordView<R> base;
    private volatile boolean closed = false;

    public CloseableRecordView(RecordView<R> base) {
        this.base = base;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public R get(@Nullable Transaction tx, R keyRec) {
        this.checkState();
        return this.base.get(tx, keyRec);
    }

    @Override
    public CompletableFuture<R> getAsync(@Nullable Transaction tx, R keyRec) {
        this.checkState();
        return this.base.getAsync(tx, keyRec);
    }

    @Override
    public List<R> getAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        this.checkState();
        return this.base.getAll(tx, keyRecs);
    }

    @Override
    public CompletableFuture<List<R>> getAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        this.checkState();
        return this.base.getAllAsync(tx, keyRecs);
    }

    @Override
    public boolean contains(@Nullable Transaction tx, R keyRec) {
        this.checkState();
        return this.base.contains(tx, keyRec);
    }

    @Override
    public CompletableFuture<Boolean> containsAsync(@Nullable Transaction tx, R keyRec) {
        this.checkState();
        return this.base.containsAsync(tx, keyRec);
    }

    @Override
    public boolean containsAll(@Nullable Transaction tx, Collection<R> keys) {
        this.checkState();
        return this.base.containsAll(tx, keys);
    }

    @Override
    public CompletableFuture<Boolean> containsAllAsync(@Nullable Transaction tx, Collection<R> keys) {
        this.checkState();
        return this.base.containsAllAsync(tx, keys);
    }

    @Override
    public void upsert(@Nullable Transaction tx, R rec) {
        this.checkState();
        this.base.upsert(tx, rec);
    }

    @Override
    public CompletableFuture<Void> upsertAsync(@Nullable Transaction tx, R rec) {
        this.checkState();
        return this.base.upsertAsync(tx, rec);
    }

    @Override
    public void upsertAll(@Nullable Transaction tx, Collection<R> recs) {
        this.checkState();
        this.base.upsertAll(tx, recs);
    }

    @Override
    public CompletableFuture<Void> upsertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        this.checkState();
        return this.base.upsertAllAsync(tx, recs);
    }

    @Override
    public R getAndUpsert(@Nullable Transaction tx, R rec) {
        this.checkState();
        return this.base.getAndUpsert(tx, rec);
    }

    @Override
    public CompletableFuture<R> getAndUpsertAsync(@Nullable Transaction tx, R rec) {
        this.checkState();
        return this.base.getAndUpsertAsync(tx, rec);
    }

    @Override
    public boolean insert(@Nullable Transaction tx, R rec) {
        this.checkState();
        return this.base.insert(tx, rec);
    }

    @Override
    public CompletableFuture<Boolean> insertAsync(@Nullable Transaction tx, R rec) {
        this.checkState();
        return this.base.insertAsync(tx, rec);
    }

    @Override
    public List<R> insertAll(@Nullable Transaction tx, Collection<R> recs) {
        this.checkState();
        return this.base.insertAll(tx, recs);
    }

    @Override
    public CompletableFuture<List<R>> insertAllAsync(@Nullable Transaction tx, Collection<R> recs) {
        this.checkState();
        return this.base.insertAllAsync(tx, recs);
    }

    @Override
    public boolean replace(@Nullable Transaction tx, R rec) {
        this.checkState();
        return this.base.replace(tx, rec);
    }

    @Override
    public boolean replace(@Nullable Transaction tx, R oldRec, R newRec) {
        this.checkState();
        return this.base.replace(tx, oldRec, newRec);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R rec) {
        this.checkState();
        return this.base.replaceAsync(tx, rec);
    }

    @Override
    public CompletableFuture<Boolean> replaceAsync(@Nullable Transaction tx, R oldRec, R newRec) {
        this.checkState();
        return this.base.replaceAsync(tx, oldRec, newRec);
    }

    @Override
    public R getAndReplace(@Nullable Transaction tx, R rec) {
        this.checkState();
        return this.base.getAndReplace(tx, rec);
    }

    @Override
    public CompletableFuture<R> getAndReplaceAsync(@Nullable Transaction tx, R rec) {
        this.checkState();
        return this.base.getAndReplaceAsync(tx, rec);
    }

    @Override
    public boolean delete(@Nullable Transaction tx, R keyRec) {
        this.checkState();
        return this.base.delete(tx, keyRec);
    }

    @Override
    public CompletableFuture<Boolean> deleteAsync(@Nullable Transaction tx, R keyRec) {
        this.checkState();
        return this.base.deleteAsync(tx, keyRec);
    }

    @Override
    public boolean deleteExact(@Nullable Transaction tx, R rec) {
        this.checkState();
        return this.base.deleteExact(tx, rec);
    }

    @Override
    public CompletableFuture<Boolean> deleteExactAsync(@Nullable Transaction tx, R rec) {
        this.checkState();
        return this.base.deleteExactAsync(tx, rec);
    }

    @Override
    public R getAndDelete(@Nullable Transaction tx, R keyRec) {
        this.checkState();
        return this.base.getAndDelete(tx, keyRec);
    }

    @Override
    public CompletableFuture<R> getAndDeleteAsync(@Nullable Transaction tx, R keyRec) {
        this.checkState();
        return this.base.getAndDeleteAsync(tx, keyRec);
    }

    @Override
    public List<R> deleteAll(@Nullable Transaction tx, Collection<R> keyRecs) {
        this.checkState();
        return this.base.deleteAll(tx, keyRecs);
    }

    @Override
    public void deleteAll(@Nullable Transaction tx) {
        this.checkState();
        this.base.deleteAll(tx);
    }

    @Override
    public CompletableFuture<List<R>> deleteAllAsync(@Nullable Transaction tx, Collection<R> keyRecs) {
        this.checkState();
        return this.base.deleteAllAsync(tx, keyRecs);
    }

    @Override
    public CompletableFuture<Void> deleteAllAsync(@Nullable Transaction tx) {
        this.checkState();
        return this.base.deleteAllAsync(tx);
    }

    @Override
    public List<R> deleteAllExact(@Nullable Transaction tx, Collection<R> recs) {
        this.checkState();
        return this.base.deleteAllExact(tx, recs);
    }

    @Override
    public CompletableFuture<List<R>> deleteAllExactAsync(@Nullable Transaction tx, Collection<R> recs) {
        this.checkState();
        return this.base.deleteAllExactAsync(tx, recs);
    }

    @Override
    public CompletableFuture<Void> streamData(Flow.Publisher<DataStreamerItem<R>> publisher, @Nullable DataStreamerOptions options) {
        this.checkState();
        return this.base.streamData(publisher, options);
    }

    @Override
    @Deprecated
    public <E, V, R1, A> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, Function<E, R> keyFunc, Function<E, V> payloadFunc, ReceiverDescriptor<A> receiver, @Nullable Flow.Subscriber<R1> resultSubscriber, @Nullable DataStreamerOptions options, @Nullable A receiverArg) {
        this.checkState();
        return this.base.streamData(publisher, keyFunc, payloadFunc, receiver, resultSubscriber, options, receiverArg);
    }

    @Override
    public <E, V, A, R1> CompletableFuture<Void> streamData(Flow.Publisher<E> publisher, DataStreamerReceiverDescriptor<V, A, R1> receiver, Function<E, R> keyFunc, Function<E, V> payloadFunc, @Nullable A receiverArg, @Nullable Flow.Subscriber<R1> resultSubscriber, @Nullable DataStreamerOptions options) {
        this.checkState();
        return this.base.streamData(publisher, receiver, keyFunc, payloadFunc, receiverArg, resultSubscriber, options);
    }

    @Override
    public Cursor<R> query(@Nullable Transaction tx, @Nullable Criteria criteria) {
        this.checkState();
        return this.base.query(tx, criteria);
    }

    @Override
    public Cursor<R> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName) {
        this.checkState();
        return this.base.query(tx, criteria, indexName);
    }

    @Override
    public Cursor<R> query(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        this.checkState();
        return this.base.query(tx, criteria, indexName, opts);
    }

    @Override
    public CompletableFuture<AsyncCursor<R>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria) {
        this.checkState();
        return this.base.queryAsync(tx, criteria);
    }

    @Override
    public CompletableFuture<AsyncCursor<R>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName) {
        this.checkState();
        return this.base.queryAsync(tx, criteria, indexName);
    }

    @Override
    public CompletableFuture<AsyncCursor<R>> queryAsync(@Nullable Transaction tx, @Nullable Criteria criteria, @Nullable String indexName, @Nullable CriteriaQueryOptions opts) {
        this.checkState();
        return this.base.queryAsync(tx, criteria, indexName, opts);
    }

    @Override
    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<R>> subscriber, @Nullable ContinuousQueryOptions options) {
        this.checkState();
        this.base.queryContinuously(subscriber, options);
    }

    @Override
    public void queryContinuously(Flow.Subscriber<TableRowEventBatch<R>> subscriber) {
        this.checkState();
        this.base.queryContinuously(subscriber);
    }

    protected void checkState() {
        if (this.closed) {
            throw new IllegalStateException("View already closed.");
        }
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return Wrappers.unwrap(this.base, classToUnwrap);
    }
}

