/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.replicator;

import java.util.regex.Pattern;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.ZonePartitionId;

public interface PartitionGroupId
extends ReplicationGroupId {
    public static final Pattern STRING_REPRESENTATION_PATTERN = Pattern.compile("\\d+_part_\\d+");

    public int objectId();

    public int partitionId();

    public static boolean isAbsent(ReplicationGroupId groupId) {
        if (groupId instanceof TablePartitionId) {
            return ((TablePartitionId)groupId).isAbsent();
        }
        if (groupId instanceof ZonePartitionId) {
            return ((ZonePartitionId)groupId).isAbsent();
        }
        throw new IllegalArgumentException("Argument must be a TablePartitionId or a ZonePartitionId, but it's " + groupId.getClass());
    }

    public static boolean matchesString(String str) {
        return STRING_REPRESENTATION_PATTERN.matcher(str).matches();
    }
}

