/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.gossip;

import java.util.StringJoiner;
import reactor.core.Exceptions;

public final class GossipConfig
implements Cloneable {
    public static final long DEFAULT_GOSSIP_INTERVAL = 200L;
    public static final int DEFAULT_GOSSIP_FANOUT = 3;
    public static final int DEFAULT_GOSSIP_REPEAT_MULT = 3;
    public static final int GOSSIP_SEGMENTATION_THRESHOLD = 1000;
    public static final int DEFAULT_WAN_GOSSIP_FANOUT = 4;
    public static final int DEFAULT_LOCAL_GOSSIP_REPEAT_MULT = 2;
    public static final int DEFAULT_LOCAL_GOSSIP_INTERVAL = 100;
    private int gossipFanout = 3;
    private long gossipInterval = 200L;
    private int gossipRepeatMult = 3;
    private int gossipSegmentationThreshold = 1000;

    public static GossipConfig defaultConfig() {
        return new GossipConfig();
    }

    public static GossipConfig defaultLanConfig() {
        return GossipConfig.defaultConfig();
    }

    public static GossipConfig defaultWanConfig() {
        return GossipConfig.defaultConfig().gossipFanout(4);
    }

    public static GossipConfig defaultLocalConfig() {
        return GossipConfig.defaultConfig().gossipRepeatMult(2).gossipInterval(100L);
    }

    public GossipConfig gossipFanout(int gossipFanout) {
        GossipConfig g = this.clone();
        g.gossipFanout = gossipFanout;
        return g;
    }

    public int gossipFanout() {
        return this.gossipFanout;
    }

    public GossipConfig gossipInterval(long gossipInterval) {
        GossipConfig g = this.clone();
        g.gossipInterval = gossipInterval;
        return g;
    }

    public long gossipInterval() {
        return this.gossipInterval;
    }

    public GossipConfig gossipRepeatMult(int gossipRepeatMult) {
        GossipConfig g = this.clone();
        g.gossipRepeatMult = gossipRepeatMult;
        return g;
    }

    public int gossipRepeatMult() {
        return this.gossipRepeatMult;
    }

    public GossipConfig gossipSegmentationThreshold(int gossipSegmentationThreshold) {
        GossipConfig g = this.clone();
        g.gossipSegmentationThreshold = gossipSegmentationThreshold;
        return g;
    }

    public int gossipSegmentationThreshold() {
        return this.gossipSegmentationThreshold;
    }

    public GossipConfig clone() {
        try {
            return (GossipConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Exceptions.propagate(e);
        }
    }

    public String toString() {
        return new StringJoiner(", ", GossipConfig.class.getSimpleName() + "[", "]").add("gossipFanout=" + this.gossipFanout).add("gossipInterval=" + this.gossipInterval).add("gossipRepeatMult=" + this.gossipRepeatMult).add("gossipSegmentationThreshold=" + this.gossipSegmentationThreshold).toString();
    }
}

