/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.dr.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.gridgain.internal.dr.DrUtils;
import org.gridgain.internal.dr.binary.BinaryMarshallerV8;
import org.gridgain.internal.dr.common.CacheObject;
import org.jetbrains.annotations.Nullable;

abstract class CacheObjectAdapter
implements CacheObject,
Externalizable {
    private static final long serialVersionUID = 2006765505127197251L;
    @Nullable
    protected transient Object val;
    protected byte[] valBytes;

    CacheObjectAdapter() {
    }

    @Nullable
    public Object value() {
        return this.val;
    }

    @Override
    public void writeExternal(ObjectOutput out) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.valBytes = DrUtils.readByteArray(in);
    }

    public void finishUnmarshal(BinaryMarshallerV8 marsh) {
        if (this.val == null) {
            assert (this.valBytes != null);
            this.val = marsh.unmarshal(this.valBytes);
        }
    }
}

